/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class CopyRequest
implements TransferObjectRequest,
ToCopyableBuilder<Builder, CopyRequest> {
    private final CopyObjectRequest copyObjectRequest;
    private final List<TransferListener> transferListeners;

    private CopyRequest(DefaultBuilder builder) {
        this.copyObjectRequest = (CopyObjectRequest)Validate.paramNotNull((Object)builder.copyObjectRequest, (String)"copyObjectRequest");
        this.transferListeners = builder.transferListeners;
    }

    public CopyObjectRequest copyObjectRequest() {
        return this.copyObjectRequest;
    }

    @Override
    public List<TransferListener> transferListeners() {
        return this.transferListeners;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyRequest that = (CopyRequest)o;
        if (!Objects.equals(this.copyObjectRequest, that.copyObjectRequest)) {
            return false;
        }
        return Objects.equals(this.transferListeners, that.transferListeners);
    }

    public int hashCode() {
        int result = this.copyObjectRequest != null ? this.copyObjectRequest.hashCode() : 0;
        result = 31 * result + (this.transferListeners != null ? this.transferListeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"CopyRequest").add("copyRequest", (Object)this.copyObjectRequest).add("transferListeners", this.transferListeners).build();
    }

    private static class DefaultBuilder
    implements Builder {
        private CopyObjectRequest copyObjectRequest;
        private List<TransferListener> transferListeners;

        private DefaultBuilder() {
        }

        private DefaultBuilder(CopyRequest copyRequest) {
            this.copyObjectRequest = copyRequest.copyObjectRequest;
            this.transferListeners = copyRequest.transferListeners;
        }

        @Override
        public Builder copyObjectRequest(CopyObjectRequest copyRequest) {
            this.copyObjectRequest = copyRequest;
            return this;
        }

        public CopyObjectRequest getCopyObjectRequest() {
            return this.copyObjectRequest;
        }

        public void setCopyObjectRequest(CopyObjectRequest copyObjectRequest) {
            this.copyObjectRequest(copyObjectRequest);
        }

        @Override
        public DefaultBuilder transferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public DefaultBuilder addTransferListener(TransferListener transferListener) {
            if (this.transferListeners == null) {
                this.transferListeners = new ArrayList<TransferListener>();
            }
            this.transferListeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getTransferListeners() {
            return this.transferListeners;
        }

        public void setTransferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners((Collection)transferListeners);
        }

        @Override
        public CopyRequest build() {
            return new CopyRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, CopyRequest> {
        public Builder copyObjectRequest(CopyObjectRequest var1);

        default public Builder copyObjectRequest(Consumer<CopyObjectRequest.Builder> copyRequestBuilder) {
            return this.copyObjectRequest((CopyObjectRequest)((CopyObjectRequest.Builder)CopyObjectRequest.builder().applyMutation(copyRequestBuilder)).build());
        }

        public Builder transferListeners(Collection<TransferListener> var1);

        public Builder addTransferListener(TransferListener var1);

        public CopyRequest build();
    }
}

