/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder.geonames;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.util.Map;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GeonamesQueryBuilder {
    private final Analyzer analyzer;
    private String queryText;
    private String countryCode = "";
    private boolean scoringByPopulation;
    private boolean andOperator;
    private String featureCode;

    public GeonamesQueryBuilder() {
        this(GeocoderConstants.ANALYZER);
    }

    public GeonamesQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public GeonamesQueryBuilder queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    public GeonamesQueryBuilder countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public GeonamesQueryBuilder scoringByPopulation() {
        this.scoringByPopulation = true;
        return this;
    }

    public GeonamesQueryBuilder featureCode(String featureCode) {
        this.featureCode = featureCode;
        return this;
    }

    public GeonamesQueryBuilder andOperator() {
        this.andOperator = true;
        return this;
    }

    public Query build() throws ParseException {
        String countryCodeEsc;
        String queryTextEsc;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (this.queryText != null && !(queryTextEsc = QueryParserBase.escape((String)this.queryText)).isBlank()) {
            Map<String, Float> fieldWeights = Map.of("name", Float.valueOf(1.0f), "asciiname", Float.valueOf(1.0f), "country", Float.valueOf(1.0f), "countryCode", Float.valueOf(1.0f));
            SimpleQueryParser parser = new SimpleQueryParser(this.analyzer, fieldWeights);
            if (this.andOperator) {
                parser.setDefaultOperator(BooleanClause.Occur.MUST);
            }
            Query termsQuery = parser.parse(queryTextEsc);
            builder.add(termsQuery, BooleanClause.Occur.MUST);
        }
        if (this.countryCode != null && !(countryCodeEsc = QueryParserBase.escape((String)this.countryCode)).isBlank()) {
            TermQuery countryCodeQuery = new TermQuery(new Term("countryCode", countryCodeEsc));
            builder.add((Query)countryCodeQuery, BooleanClause.Occur.MUST);
        }
        if (!Strings.isNullOrEmpty((String)this.featureCode)) {
            TermQuery featureCodeQuery = new TermQuery(new Term("featureCode", this.featureCode));
            builder.add((Query)featureCodeQuery, BooleanClause.Occur.MUST);
        }
        if (this.scoringByPopulation) {
            BooleanQuery query = builder.build();
            Expression expr = JavascriptCompiler.compile((String)"_score + ln(1+population)");
            SimpleBindings bindings = new SimpleBindings();
            bindings.add("_score", DoubleValuesSource.SCORES);
            bindings.add("population", DoubleValuesSource.fromIntField((String)"population"));
            return new FunctionScoreQuery((Query)query, expr.getDoubleValuesSource((Bindings)bindings));
        }
        return builder.build();
    }
}

