/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.pbf.PbfBlockReader;
import org.apache.baremaps.openstreetmap.stream.StreamUtils;
import org.apache.baremaps.postgres.openstreetmap.BlockImporter;
import org.apache.baremaps.postgres.openstreetmap.HeaderRepository;
import org.apache.baremaps.postgres.openstreetmap.NodeRepository;
import org.apache.baremaps.postgres.openstreetmap.RelationRepository;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.WayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;

public class ImportOsmPbf
implements Task {
    private Path file;
    private Object database;
    private Integer databaseSrid;
    private Boolean replaceExisting;
    private Boolean truncateTables;

    public ImportOsmPbf() {
    }

    public ImportOsmPbf(Path file, Object database, Integer databaseSrid, Boolean replaceExisting, Boolean truncateTables) {
        this.file = file;
        this.database = database;
        this.databaseSrid = databaseSrid;
        this.replaceExisting = replaceExisting;
        this.truncateTables = truncateTables;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        DataSource datasource = context.getDataSource(this.database);
        HeaderRepository headerRepository = new HeaderRepository(datasource);
        NodeRepository nodeRepository = new NodeRepository(datasource);
        WayRepository wayRepository = new WayRepository(datasource);
        RelationRepository relationRepository = new RelationRepository(datasource);
        if (Boolean.TRUE.equals(this.replaceExisting)) {
            headerRepository.drop();
            nodeRepository.drop();
            wayRepository.drop();
            relationRepository.drop();
            headerRepository.create();
            nodeRepository.create();
            wayRepository.create();
            relationRepository.create();
        }
        if (Boolean.TRUE.equals(this.truncateTables)) {
            headerRepository.truncate();
            nodeRepository.truncate();
            wayRepository.truncate();
            relationRepository.truncate();
        }
        Map<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        Map<Long, List<Long>> referenceMap = context.getReferenceMap();
        ImportOsmPbf.execute(path, coordinateMap, referenceMap, headerRepository, (Repository<Long, Node>)nodeRepository, (Repository<Long, Way>)wayRepository, (Repository<Long, Relation>)relationRepository, this.databaseSrid);
    }

    static void execute(Path path, Map<Long, Coordinate> coordinateMap, Map<Long, List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, Integer databaseSrid) throws IOException {
        PbfBlockReader reader = new PbfBlockReader().setGeometries(true).setSrid(databaseSrid.intValue()).setCoordinateMap(coordinateMap).setReferenceMap(referenceMap);
        BlockImporter importer = new BlockImporter((Repository)headerRepository, nodeRepository, wayRepository, relationRepository);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch((Stream)reader.read(input)).forEach(importer);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportOsmPbf.class.getSimpleName() + "[", "]").add("file=" + String.valueOf(this.file)).add("database=" + String.valueOf(this.database)).add("databaseSrid=" + this.databaseSrid).add("replaceExisting=" + this.replaceExisting).toString();
    }
}

