/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.XMLMetadata;
import org.apache.sis.storage.geotiff.internal.Compression;
import org.apache.sis.storage.geotiff.internal.Resources;
import org.apache.sis.util.CharSequences;

final class ImageMetadataBuilder
extends MetadataBuilder {
    private double resolution = Double.NaN;
    private Unit<Length> resolutionUnit = Units.INCH;
    private short cellWidth = (short)-1;
    private short cellHeight = (short)-1;
    private XMLMetadata complement;

    ImageMetadataBuilder() {
    }

    Integer setThreshholding(int value) {
        switch (value) {
            default: {
                return value;
            }
            case 2: {
                if ((this.cellWidth & this.cellHeight) >= 0) break;
            }
            case 1: 
            case 3: {
                this.cellWidth = this.cellHeight = (short)(-value);
            }
        }
        return null;
    }

    void setCellSize(short size, boolean w) {
        if (w) {
            this.cellWidth = size;
        } else {
            this.cellHeight = size;
        }
    }

    void setResolution(double r) {
        if (Double.isNaN(this.resolution) || r > this.resolution) {
            this.resolution = r;
        }
    }

    Integer setResolutionUnit(int unit) {
        switch (unit) {
            case 1: {
                this.resolutionUnit = null;
                break;
            }
            case 2: {
                this.resolutionUnit = Units.INCH;
                break;
            }
            case 3: {
                this.resolutionUnit = Units.CENTIMETRE;
                break;
            }
            default: {
                return unit;
            }
        }
        return null;
    }

    void addXML(XMLMetadata xml) {
        if (this.complement == null) {
            this.complement = xml;
        } else {
            xml.appendTo(this.complement);
        }
    }

    void finish(ImageFileDirectory image, StoreListeners listeners) throws DataStoreException {
        Compression compression;
        image.getIdentifier().ifPresent(id -> {
            if (!image.getImageIndex().equals(id.tip().toString())) {
                this.addTitle(id.toString());
            }
        });
        GeoTiffStore store = image.reader.store;
        if (store.hidden) {
            store.setFormatInfo(this);
        }
        if ((compression = image.getCompression()) != null) {
            this.addCompression(CharSequences.upperCaseToSentence((CharSequence)compression.name()));
        }
        if (!Double.isNaN(this.resolution) && this.resolutionUnit != null) {
            this.addResolution(this.resolutionUnit.getConverterTo(Units.METRE).convert(this.resolution));
        }
        int cellWidth = this.cellWidth;
        int cellHeight = this.cellHeight;
        switch (Math.min(cellWidth, cellHeight)) {
            case -1: {
                break;
            }
            case -3: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)15));
                break;
            }
            default: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)5, cellWidth >= 0 ? cellWidth : 63, cellHeight >= 0 ? cellHeight : 63));
            }
        }
        while (this.complement != null) {
            try {
                this.complement = this.complement.appendTo(this);
            }
            catch (Exception ex) {
                listeners.warning(image.reader.errors().getString((short)15, (Object)this.complement.tag()), ex);
            }
        }
    }
}

