/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.referencing;

import jakarta.xml.bind.annotation.XmlElementRef;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.bind.referencing.CC_OperationMethod;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public final class CC_GeneralOperationParameter
extends PropertyType<CC_GeneralOperationParameter, GeneralParameterDescriptor> {
    public static final short DEFAULT_OCCURRENCE = 1;
    private static final String[] IGNORE_DURING_MERGE = new String[]{"name", "alias", "identifiers"};

    public CC_GeneralOperationParameter() {
    }

    protected Class<GeneralParameterDescriptor> getBoundType() {
        return GeneralParameterDescriptor.class;
    }

    private CC_GeneralOperationParameter(GeneralParameterDescriptor parameter) {
        super((Object)parameter);
    }

    protected CC_GeneralOperationParameter wrap(GeneralParameterDescriptor parameter) {
        return new CC_GeneralOperationParameter(parameter);
    }

    @XmlElementRef
    public AbstractParameterDescriptor getElement() {
        GeneralParameterDescriptor metadata = (GeneralParameterDescriptor)this.metadata;
        if (metadata instanceof AbstractParameterDescriptor) {
            return (AbstractParameterDescriptor)metadata;
        }
        if (metadata instanceof ParameterDescriptor) {
            return DefaultParameterDescriptor.castOrCopy((ParameterDescriptor)metadata);
        }
        if (metadata instanceof ParameterDescriptorGroup) {
            return DefaultParameterDescriptorGroup.castOrCopy((ParameterDescriptorGroup)metadata);
        }
        return null;
    }

    public void setElement(AbstractParameterDescriptor parameter) {
        this.metadata = parameter;
    }

    static void validate(GeneralParameterDescriptor descriptor, String parent, String property) {
        if (descriptor == null || descriptor.getName() == null) {
            String link;
            int key = 85;
            String[] args = new String[]{parent, property};
            if (descriptor instanceof IdentifiedObject && (link = (String)((IdentifiedObject)descriptor).getIdentifierMap().get((Object)IdentifierSpace.XLINK)) != null) {
                key = 108;
                args = new String[]{link};
            }
            throw new GeodeticException(Errors.format((short)key, (Object)args));
        }
    }

    private static boolean isRestricted(ParameterDescriptor<?> descriptor) {
        Comparable max;
        Comparable min = descriptor.getMinimumValue();
        if (min instanceof Number && (max = descriptor.getMaximumValue()) instanceof Number) {
            return ((Number)((Object)min)).doubleValue() == ((Number)((Object)max)).doubleValue();
        }
        return false;
    }

    static GeneralParameterDescriptor merge(GeneralParameterDescriptor provided, GeneralParameterDescriptor complete) {
        boolean canSubstitute;
        boolean isGroup;
        if (provided == complete) {
            return complete;
        }
        if (provided instanceof ParameterDescriptor && complete instanceof ParameterDescriptor) {
            isGroup = false;
        } else if (provided instanceof ParameterDescriptorGroup && complete instanceof ParameterDescriptorGroup) {
            isGroup = true;
        } else {
            return provided;
        }
        int minimumOccurs = provided.getMinimumOccurs();
        int maximumOccurs = provided.getMaximumOccurs();
        Map<String, ?> expected = IdentifiedObjects.getProperties((org.opengis.referencing.IdentifiedObject)complete, new String[0]);
        Map<String, ?> actual = IdentifiedObjects.getProperties((org.opengis.referencing.IdentifiedObject)provided, IGNORE_DURING_MERGE);
        boolean bl = canSubstitute = complete.getMinimumOccurs() == minimumOccurs && complete.getMaximumOccurs() == maximumOccurs && expected.entrySet().containsAll(actual.entrySet()) && CC_GeneralOperationParameter.containsAll(complete.getAlias(), provided.getAlias()) && CC_GeneralOperationParameter.containsAll(complete.getIdentifiers(), provided.getIdentifiers());
        if (canSubstitute && !isGroup && !CC_GeneralOperationParameter.isRestricted((ParameterDescriptor)complete)) {
            return complete;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(expected);
        merged.putAll(actual);
        CC_GeneralOperationParameter.mergeArrays("alias", GenericName.class, provided.getAlias(), merged, (Identifier)complete.getName());
        CC_GeneralOperationParameter.mergeArrays("identifiers", ReferenceIdentifier.class, provided.getIdentifiers(), merged, null);
        if (isGroup) {
            List descriptors = ((ParameterDescriptorGroup)provided).descriptors();
            return CC_GeneralOperationParameter.merge(DefaultParameterValueGroup.class, merged, merged, minimumOccurs, maximumOccurs, (GeneralParameterDescriptor[])descriptors.toArray(GeneralParameterDescriptor[]::new), (ParameterDescriptorGroup)complete, canSubstitute);
        }
        return CC_GeneralOperationParameter.create(merged, (ParameterDescriptor)provided, (ParameterDescriptor)complete);
    }

    static ParameterDescriptorGroup merge(Class<?> caller, Map<String, ?> properties, Map<String, ?> merged, int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor[] provided, ParameterDescriptorGroup complete, boolean canSubstitute) {
        boolean isCompatible = true;
        HashSet<GeneralParameterDescriptor> included = new HashSet<GeneralParameterDescriptor>(Containers.hashMapCapacity((int)provided.length));
        for (int i = 0; i < provided.length; ++i) {
            GeneralParameterDescriptor p = provided[i];
            try {
                GeneralParameterDescriptor predefined = complete.descriptor(p.getName().getCode());
                if (predefined != null) {
                    provided[i] = CC_GeneralOperationParameter.merge(p, predefined);
                    canSubstitute &= provided[i] == predefined;
                    if (included.add(predefined)) continue;
                    throw new CorruptedObjectException((org.opengis.referencing.IdentifiedObject)predefined);
                }
            }
            catch (ParameterNotFoundException e) {
                Context.warningOccured((Context)Context.current(), caller, (String)(caller == DefaultParameterValueGroup.class ? "setValues" : "setDescriptors"), (Exception)((Object)e), (boolean)canSubstitute);
            }
            isCompatible &= p.getMinimumOccurs() == 0;
            canSubstitute = false;
        }
        if (isCompatible) {
            for (GeneralParameterDescriptor descriptor : complete.descriptors()) {
                if (included.contains(descriptor) || descriptor.getMinimumOccurs() == 0 || CC_OperationMethod.isImplicitParameter(descriptor)) continue;
                canSubstitute = false;
                isCompatible = false;
                break;
            }
        }
        if (canSubstitute) {
            return complete;
        }
        return new DefaultParameterDescriptorGroup(isCompatible ? merged : properties, minimumOccurs, maximumOccurs, provided);
    }

    private static <T> ParameterDescriptor<T> create(Map<String, ?> merged, ParameterDescriptor<?> provided, ParameterDescriptor<T> complete) {
        Class valueClass = complete.getValueClass();
        return new DefaultParameterDescriptor<Object>(merged, provided.getMinimumOccurs(), provided.getMaximumOccurs(), valueClass, Parameters.getValueDomain(complete), CollectionsExt.toArray((Collection)complete.getValidValues(), (Class)valueClass), complete.getDefaultValue());
    }

    private static <T> boolean containsAll(Collection<T> complete, Collection<T> provided) {
        if (!provided.isEmpty()) {
            int size = complete.size();
            if (size == 0) {
                return false;
            }
            HashSet<NamedIdentifier> c = new HashSet<NamedIdentifier>(Containers.hashMapCapacity((int)size));
            for (T e : complete) {
                c.add(CC_GeneralOperationParameter.toNamedIdentifier(e));
            }
            for (T e : provided) {
                if (c.contains(CC_GeneralOperationParameter.toNamedIdentifier(e))) continue;
                return false;
            }
        }
        return true;
    }

    private static <T> void mergeArrays(String key, Class<T> componentType, Collection<T> provided, Map<String, Object> merged, Identifier remove) {
        if (!provided.isEmpty()) {
            Object[] complete = (Object[])merged.get(key);
            if (complete != null) {
                LinkedHashMap<NamedIdentifier, Object> c = new LinkedHashMap<NamedIdentifier, Object>();
                for (T e : provided) {
                    c.put(CC_GeneralOperationParameter.toNamedIdentifier(e), e);
                }
                for (Object e : complete) {
                    c.put(CC_GeneralOperationParameter.toNamedIdentifier(e), e);
                }
                c.remove(CC_GeneralOperationParameter.toNamedIdentifier(remove));
                provided = c.values();
            }
            complete = CollectionsExt.toArray(provided, componentType);
            merged.put(key, complete);
        }
    }

    private static NamedIdentifier toNamedIdentifier(Object name) {
        if (name == null || name.getClass() == NamedIdentifier.class) {
            return (NamedIdentifier)name;
        }
        if (name instanceof ReferenceIdentifier) {
            return new NamedIdentifier((ReferenceIdentifier)name);
        }
        return new NamedIdentifier((GenericName)name);
    }
}

