/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist.agent;

import com.google.common.collect.Sets;
import com.google.common.hash.Funnel;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.basecluster.agent.proto.AgentEndpoint;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberAddr;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberMetadata;
import org.apache.bifromq.basecluster.memberlist.agent.AgentMember;
import org.apache.bifromq.basecluster.memberlist.agent.CRDTUtil;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentAddressProvider;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMember;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMessenger;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent
implements IAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    private final ReadWriteLock quitLock = new ReentrantReadWriteLock();
    private final String agentId;
    private final AgentEndpoint localEndpoint;
    private final AtomicReference<State> state = new AtomicReference<State>(State.JOINED);
    private final IAgentMessenger messenger;
    private final Scheduler scheduler;
    private final ICRDTStore store;
    private final IORMap agentCRDT;
    private final Map<AgentMemberAddr, AgentMember> localMemberRegistry = new ConcurrentHashMap<AgentMemberAddr, AgentMember>();
    private final BehaviorSubject<Map<AgentMemberAddr, AgentMemberMetadata>> agentMembersSubject = BehaviorSubject.createDefault(Collections.emptyMap());
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final Gauge memberNumGauge;

    public Agent(String agentId, AgentEndpoint endpoint, IAgentMessenger messenger, Scheduler scheduler, ICRDTStore store, IAgentAddressProvider hostProvider, String ... tags) {
        this.agentId = agentId;
        this.localEndpoint = endpoint;
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.store = store;
        this.agentCRDT = (IORMap)store.host(Replica.newBuilder().setUri(CRDTUtil.toAgentURI(agentId)).setId(this.localEndpoint.toByteString()).build(), this.localEndpoint.toByteString());
        this.disposables.add(this.agentCRDT.inflation().observeOn(scheduler).subscribe(this::sync));
        this.disposables.add(hostProvider.agentAddress().observeOn(scheduler).subscribe(this::handleAgentEndpointsUpdate));
        this.memberNumGauge = Gauge.builder((String)"basecluster.agent.members", () -> ((Map)this.agentMembersSubject.getValue()).size()).tags(tags).tags(new String[]{"id", agentId}).register((MeterRegistry)Metrics.globalRegistry);
    }

    @Override
    public String id() {
        return this.agentId;
    }

    @Override
    public AgentEndpoint local() {
        return this.localEndpoint;
    }

    @Override
    public Observable<Map<AgentMemberAddr, AgentMemberMetadata>> membership() {
        return this.agentMembersSubject;
    }

    @Override
    public IAgentMember register(String memberName) {
        return this.runIfJoined(() -> {
            AgentMemberAddr memberAddr = AgentMemberAddr.newBuilder().setName(memberName).setEndpoint(this.localEndpoint.getEndpoint()).setIncarnation(this.localEndpoint.getIncarnation()).build();
            return this.localMemberRegistry.computeIfAbsent(memberAddr, k -> new AgentMember(memberAddr, this.agentCRDT, this.messenger, this.scheduler, () -> ((Map)this.agentMembersSubject.getValue()).keySet()));
        });
    }

    @Override
    public CompletableFuture<Void> deregister(IAgentMember member) {
        return this.runIfJoined(() -> {
            if (this.localMemberRegistry.remove(member.address(), member)) {
                return ((AgentMember)member).destroy();
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public void refreshRegistration() {
        this.localMemberRegistry.values().forEach(AgentMember::refresh);
    }

    public CompletableFuture<Void> quit() {
        Lock writeLock = this.quitLock.writeLock();
        try {
            writeLock.lock();
            if (this.state.compareAndSet(State.JOINED, State.QUITTING)) {
                CompletionStage completionStage = ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])this.localMemberRegistry.values().stream().map(AgentMember::destroy).toArray(CompletableFuture[]::new)).thenCompose(v -> {
                    this.disposables.dispose();
                    this.agentMembersSubject.onComplete();
                    return this.store.stopHosting(this.agentCRDT.id());
                })).whenComplete((v, e) -> this.state.set(State.QUITED));
                return completionStage;
            }
            if (this.state.get() == State.QUITTING) {
                CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("quit has started"));
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            writeLock.unlock();
            Metrics.globalRegistry.remove((Meter)this.memberNumGauge);
        }
    }

    private void sync(long ts) {
        this.skipRunIfNotJoined(() -> {
            Map<AgentMemberAddr, AgentMemberMetadata> agentMembersCRDT = CRDTUtil.toAgentMemberMap(this.agentCRDT);
            HashMap agentMembersLocal = new HashMap();
            this.localMemberRegistry.values().forEach(member -> agentMembersLocal.put(member.address(), member.metadata()));
            for (AgentMemberAddr memberAddr : Sets.difference(agentMembersCRDT.keySet(), agentMembersLocal.keySet())) {
                if (!memberAddr.getEndpoint().equals(this.localEndpoint.getEndpoint())) continue;
                this.agentCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{memberAddr.toByteString()}).of(CausalCRDTType.mvreg));
            }
            agentMembersCRDT.putAll(agentMembersLocal);
            this.agentMembersSubject.onNext(agentMembersCRDT);
        });
    }

    private void handleAgentEndpointsUpdate(Set<AgentEndpoint> agentEndpoints) {
        this.skipRunIfNotJoined(() -> {
            HashSet aliveAgentEndpoints = Sets.newHashSet((Iterable)agentEndpoints);
            aliveAgentEndpoints.add(this.localEndpoint);
            Set aliveAgentHostEndpoints = aliveAgentEndpoints.stream().map(AgentEndpoint::getEndpoint).collect(Collectors.toSet());
            Map<AgentMemberAddr, AgentMemberMetadata> agentMemberMap = CRDTUtil.toAgentMemberMap(this.agentCRDT);
            for (AgentMemberAddr memberAddr : agentMemberMap.keySet()) {
                if (aliveAgentHostEndpoints.contains(memberAddr.getEndpoint()) || !this.shouldClean(aliveAgentEndpoints, memberAddr.getEndpoint())) continue;
                this.agentCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{memberAddr.toByteString()}).of(CausalCRDTType.mvreg));
            }
            this.store.join(this.agentCRDT.id(), aliveAgentEndpoints.stream().map(AbstractMessageLite::toByteString).collect(Collectors.toSet()));
        });
    }

    private boolean shouldClean(Set<AgentEndpoint> allEndpoints, HostEndpoint failedMemberEndpoint) {
        RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.getId().asReadOnlyByteBuffer())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.getEndpoint().getId().asReadOnlyByteBuffer())).nodes(allEndpoints).build();
        AgentEndpoint cleaner = (AgentEndpoint)hash.get((Object)failedMemberEndpoint);
        return cleaner.getEndpoint().getId().equals((Object)this.localEndpoint.getEndpoint().getId());
    }

    private void skipRunIfNotJoined(Runnable runnable) {
        Lock readLock = this.quitLock.readLock();
        try {
            readLock.lock();
            if (this.state.get() != State.JOINED) {
                return;
            }
            runnable.run();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runIfJoined(Supplier<T> supplier) {
        Lock readLock = this.quitLock.readLock();
        try {
            readLock.lock();
            if (this.state.get() != State.JOINED) {
                throw new IllegalArgumentException("Agent has quit");
            }
            T t = supplier.get();
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    private static enum State {
        JOINED,
        QUITTING,
        QUITED;

    }
}

