/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.AbstractBalancerStateProposerHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposer;

abstract class SetBalancerStateHandler
extends AbstractBalancerStateProposerHandler
implements IHTTPRequestHandler {
    SetBalancerStateHandler(IBaseKVMetaService metaService) {
        super(metaService);
    }

    protected CompletableFuture<FullHttpResponse> handle(long reqId, FullHttpRequest req, boolean disable) {
        String storeName = HeaderUtils.getHeader(Headers.HEADER_STORE_NAME, (HttpRequest)req, true);
        String balancerFactoryClass = HeaderUtils.getHeader(Headers.HEADER_BALANCER_FACTORY_CLASS, (HttpRequest)req, true);
        IBaseKVStoreBalancerStatesProposer statesProposer = (IBaseKVStoreBalancerStatesProposer)this.balancerStateProposers.get(storeName);
        if (statesProposer == null) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Store not found: " + storeName).getBytes())));
        }
        try {
            return statesProposer.proposeRunState(balancerFactoryClass, disable).handle(CompletableFutureUtil.unwrap((v, e) -> {
                if (e != null) {
                    if (e instanceof TimeoutException) {
                        return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER);
                    }
                    return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])e.getMessage().getBytes()));
                }
                switch (v) {
                    case ACCEPTED: {
                        return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
                    }
                }
                return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.CONFLICT, Unpooled.EMPTY_BUFFER);
            }));
        }
        catch (Throwable e2) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])e2.getMessage().getBytes())));
        }
    }
}

