/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.ibatis.annotations.Param;

public class FilesetVersionBaseSQLProvider {
    public String insertFilesetVersion(@Param(value="filesetVersion") FilesetVersionPO filesetVersionPO) {
        return "INSERT INTO fileset_version_info(metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location, deleted_at) VALUES( #{filesetVersion.metalakeId}, #{filesetVersion.catalogId}, #{filesetVersion.schemaId}, #{filesetVersion.filesetId}, #{filesetVersion.version}, #{filesetVersion.filesetComment}, #{filesetVersion.properties}, #{filesetVersion.storageLocation}, #{filesetVersion.deletedAt} )";
    }

    public String insertFilesetVersionOnDuplicateKeyUpdate(@Param(value="filesetVersion") FilesetVersionPO filesetVersionPO) {
        return "INSERT INTO fileset_version_info(metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location, deleted_at) VALUES( #{filesetVersion.metalakeId}, #{filesetVersion.catalogId}, #{filesetVersion.schemaId}, #{filesetVersion.filesetId}, #{filesetVersion.version}, #{filesetVersion.filesetComment}, #{filesetVersion.properties}, #{filesetVersion.storageLocation}, #{filesetVersion.deletedAt} ) ON DUPLICATE KEY UPDATE metalake_id = #{filesetVersion.metalakeId}, catalog_id = #{filesetVersion.catalogId}, schema_id = #{filesetVersion.schemaId}, fileset_id = #{filesetVersion.filesetId}, version = #{filesetVersion.version}, fileset_comment = #{filesetVersion.filesetComment}, properties = #{filesetVersion.properties}, storage_location = #{filesetVersion.storageLocation}, deleted_at = #{filesetVersion.deletedAt}";
    }

    public String softDeleteFilesetVersionsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsByFilesetId(@Param(value="filesetId") Long filesetId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND deleted_at = 0";
    }

    public String deleteFilesetVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM fileset_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String selectFilesetVersionsByRetentionCount(@Param(value="versionRetentionCount") Long versionRetentionCount) {
        return "SELECT fileset_id as filesetId, Max(version) as version FROM fileset_version_info WHERE version > #{versionRetentionCount} AND deleted_at = 0 GROUP BY fileset_id";
    }

    public String softDeleteFilesetVersionsByRetentionLine(@Param(value="filesetId") Long filesetId, @Param(value="versionRetentionLine") long versionRetentionLine, @Param(value="limit") int limit) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND version <= #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit}";
    }
}

