/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.holders.TimeStampMilliHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.util.DateUtility;

public class TimeStampMilliHolderReaderImpl
extends AbstractFieldReader {
    private TimeStampMilliHolder holder;

    public TimeStampMilliHolderReaderImpl(TimeStampMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMILLI;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeStampMilliHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampMilliHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(TimeStampMilliWriter writer) {
        writer.write(this.holder);
    }
}

