/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.ql.exec.tez.TriggerValidatorRunnable;
import org.apache.hadoop.hive.ql.wm.SessionTriggerProvider;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerPoolTriggerValidatorRunnable
implements Runnable {
    protected static transient Logger LOG = LoggerFactory.getLogger(PerPoolTriggerValidatorRunnable.class);
    private final Map<String, SessionTriggerProvider> sessionTriggerProviders;
    private final TriggerActionHandler triggerActionHandler;
    private final Map<String, TriggerValidatorRunnable> poolValidators;
    private final long triggerValidationIntervalMs;

    PerPoolTriggerValidatorRunnable(Map<String, SessionTriggerProvider> sessionTriggerProviders, TriggerActionHandler triggerActionHandler, long triggerValidationIntervalMs) {
        this.sessionTriggerProviders = sessionTriggerProviders;
        this.triggerActionHandler = triggerActionHandler;
        this.poolValidators = new HashMap<String, TriggerValidatorRunnable>();
        this.triggerValidationIntervalMs = triggerValidationIntervalMs;
    }

    @Override
    public void run() {
        try {
            ScheduledExecutorService validatorExecutorService = Executors.newScheduledThreadPool(this.sessionTriggerProviders.size());
            for (Map.Entry<String, SessionTriggerProvider> entry : this.sessionTriggerProviders.entrySet()) {
                String poolName = entry.getKey();
                if (this.poolValidators.containsKey(poolName)) continue;
                LOG.info("Creating trigger validator for pool: {}", (Object)poolName);
                TriggerValidatorRunnable poolValidator = new TriggerValidatorRunnable(entry.getValue(), this.triggerActionHandler);
                validatorExecutorService.scheduleWithFixedDelay(poolValidator, this.triggerValidationIntervalMs, this.triggerValidationIntervalMs, TimeUnit.MILLISECONDS);
                this.poolValidators.put(poolName, poolValidator);
            }
        }
        catch (Throwable t) {
            LOG.warn(PerPoolTriggerValidatorRunnable.class.getSimpleName() + " caught exception.", t);
        }
    }
}

