/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package workflowproj

// camelSchema version 3.20.5. We can update this schema as we go, or add support to more than one in the future.
// See https://github.com/apache/camel/blob/camel-3.20.5/dsl/camel-yaml-dsl/camel-yaml-dsl/src/generated/resources/schema/camel-yaml-dsl.json
const camelSchema = "{ \"$schema\" : \"http://json-schema.org/draft-04/schema#\", \"type\" : \"array\", \"items\" : { \"maxProperties\" : 1, \"definitions\" : { \"org.apache.camel.model.ProcessorDefinition\" : { \"type\" : \"object\", \"maxProperties\" : 1, \"properties\" : { \"aggregate\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.AggregateDefinition\" }, \"bean\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.BeanDefinition\" }, \"do-catch\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.CatchDefinition\" }, \"doCatch\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.CatchDefinition\" }, \"choice\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ChoiceDefinition\" }, \"circuit-breaker\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.CircuitBreakerDefinition\" }, \"circuitBreaker\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.CircuitBreakerDefinition\" }, \"claim-check\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ClaimCheckDefinition\" }, \"claimCheck\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ClaimCheckDefinition\" }, \"convert-body-to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ConvertBodyDefinition\" }, \"convertBodyTo\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ConvertBodyDefinition\" }, \"delay\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.DelayDefinition\" }, \"dynamic-router\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.DynamicRouterDefinition\" }, \"dynamicRouter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.DynamicRouterDefinition\" }, \"enrich\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.EnrichDefinition\" }, \"filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FilterDefinition\" }, \"do-finally\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FinallyDefinition\" }, \"doFinally\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FinallyDefinition\" }, \"idempotent-consumer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.IdempotentConsumerDefinition\" }, \"idempotentConsumer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.IdempotentConsumerDefinition\" }, \"in-only\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InOnlyDefinition\" }, \"inOnly\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InOnlyDefinition\" }, \"in-out\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InOutDefinition\" }, \"inOut\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InOutDefinition\" }, \"intercept\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptDefinition\" }, \"intercept-from\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptFromDefinition\" }, \"interceptFrom\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptFromDefinition\" }, \"intercept-send-to-endpoint\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptSendToEndpointDefinition\" }, \"interceptSendToEndpoint\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptSendToEndpointDefinition\" }, \"kamelet\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.KameletDefinition\" }, \"load-balance\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.LoadBalanceDefinition\" }, \"loadBalance\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.LoadBalanceDefinition\" }, \"log\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.LogDefinition\" }, \"loop\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.LoopDefinition\" }, \"marshal\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.MarshalDefinition\" }, \"multicast\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.MulticastDefinition\" }, \"on-completion\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnCompletionDefinition\" }, \"onCompletion\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnCompletionDefinition\" }, \"on-fallback\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnFallbackDefinition\" }, \"onFallback\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnFallbackDefinition\" }, \"otherwise\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OtherwiseDefinition\" }, \"pausable\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PausableDefinition\" }, \"pipeline\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PipelineDefinition\" }, \"policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PolicyDefinition\" }, \"poll-enrich\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PollEnrichDefinition\" }, \"pollEnrich\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PollEnrichDefinition\" }, \"process\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessDefinition\" }, \"recipient-list\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RecipientListDefinition\" }, \"recipientList\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RecipientListDefinition\" }, \"remove-header\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemoveHeaderDefinition\" }, \"removeHeader\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemoveHeaderDefinition\" }, \"remove-headers\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemoveHeadersDefinition\" }, \"removeHeaders\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemoveHeadersDefinition\" }, \"remove-properties\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemovePropertiesDefinition\" }, \"removeProperties\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemovePropertiesDefinition\" }, \"remove-property\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemovePropertyDefinition\" }, \"removeProperty\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RemovePropertyDefinition\" }, \"resequence\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ResequenceDefinition\" }, \"resumable\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ResumableDefinition\" }, \"rollback\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RollbackDefinition\" }, \"routing-slip\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RoutingSlipDefinition\" }, \"routingSlip\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RoutingSlipDefinition\" }, \"saga\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SagaDefinition\" }, \"sample\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SamplingDefinition\" }, \"script\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ScriptDefinition\" }, \"set-body\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetBodyDefinition\" }, \"setBody\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetBodyDefinition\" }, \"set-exchange-pattern\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetExchangePatternDefinition\" }, \"setExchangePattern\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetExchangePatternDefinition\" }, \"set-header\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetHeaderDefinition\" }, \"setHeader\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetHeaderDefinition\" }, \"set-property\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetPropertyDefinition\" }, \"setProperty\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SetPropertyDefinition\" }, \"sort\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SortDefinition\" }, \"split\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SplitDefinition\" }, \"step\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.StepDefinition\" }, \"stop\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.StopDefinition\" }, \"threads\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ThreadsDefinition\" }, \"throttle\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ThrottleDefinition\" }, \"throw-exception\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ThrowExceptionDefinition\" }, \"throwException\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ThrowExceptionDefinition\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"to-d\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDynamicDefinition\" }, \"toD\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDynamicDefinition\" }, \"transacted\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TransactedDefinition\" }, \"transform\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TransformDefinition\" }, \"do-try\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TryDefinition\" }, \"doTry\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TryDefinition\" }, \"unmarshal\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.UnmarshalDefinition\" }, \"validate\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ValidateDefinition\" }, \"when\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenDefinition\" }, \"when-skip-send-to-endpoint\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenSkipSendToEndpointDefinition\" }, \"whenSkipSendToEndpoint\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenSkipSendToEndpointDefinition\" }, \"wire-tap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WireTapDefinition\" }, \"wireTap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WireTapDefinition\" }, \"service-call\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ServiceCallDefinition\" }, \"serviceCall\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ServiceCallDefinition\" } } }, \"org.apache.camel.dsl.yaml.deserializers.BeansDeserializer\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition\" } }, \"org.apache.camel.dsl.yaml.deserializers.ErrorHandlerBuilderDeserializer\" : { \"type\" : \"object\", \"properties\" : { \"dead-letter-channel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.DeadLetterChannelDefinition\" }, \"default-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition\" }, \"jta-transaction-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition\" }, \"no-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.NoErrorHandlerDefinition\" }, \"ref-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.RefErrorHandlerDefinition\" }, \"spring-transaction-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition\" } } }, \"org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition\" : { \"type\" : \"object\", \"properties\" : { \"name\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"object\" }, \"type\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\", \"type\" ] }, \"org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"object\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"uri\" : { \"type\" : \"string\" } }, \"required\" : [ \"steps\", \"uri\" ] }, \"org.apache.camel.dsl.yaml.deserializers.RouteFromDefinitionDeserializer\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"object\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"uri\" : { \"type\" : \"string\" } }, \"required\" : [ \"steps\", \"uri\" ] }, \"org.apache.camel.model.AggregateDefinition\" : { \"type\" : \"object\", \"properties\" : { \"aggregate-controller\" : { \"type\" : \"string\" }, \"aggregation-repository\" : { \"type\" : \"string\" }, \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"boolean\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"close-correlation-key-on-completion\" : { \"type\" : \"number\" }, \"complete-all-on-stop\" : { \"type\" : \"boolean\" }, \"completion-from-batch-consumer\" : { \"type\" : \"boolean\" }, \"completion-interval\" : { \"type\" : \"string\" }, \"completion-on-new-correlation-group\" : { \"type\" : \"boolean\" }, \"completion-predicate\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"completion-size\" : { \"type\" : \"number\" }, \"completion-size-expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"completion-timeout\" : { \"type\" : \"string\" }, \"completion-timeout-checker-interval\" : { \"type\" : \"string\" }, \"completion-timeout-expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"correlation-expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"discard-on-aggregation-failure\" : { \"type\" : \"boolean\" }, \"discard-on-completion-timeout\" : { \"type\" : \"boolean\" }, \"eager-check-completion\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"force-completion-on-stop\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-correlation-keys\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"optimistic-lock-retry-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OptimisticLockRetryPolicyDefinition\" }, \"optimistic-locking\" : { \"type\" : \"boolean\" }, \"parallel-processing\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"timeout-checker-executor-service\" : { \"type\" : \"string\" } }, \"required\" : [ \"aggregation-strategy\" ] }, \"org.apache.camel.model.BeanDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"bean-type\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"method\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" }, \"scope\" : { \"type\" : \"string\", \"enum\" : [ \"Singleton\", \"Request\", \"Prototype\" ] } } } ] }, \"org.apache.camel.model.CatchDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"exception\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-when\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenDefinition\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.ChoiceDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"otherwise\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OtherwiseDefinition\" }, \"precondition\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"when\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenDefinition\" } } } }, \"org.apache.camel.model.CircuitBreakerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"configuration\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"fault-tolerance-configuration\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FaultToleranceConfigurationDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-fallback\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnFallbackDefinition\" }, \"resilience4j-configuration\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.Resilience4jConfigurationDefinition\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.ClaimCheckDefinition\" : { \"type\" : \"object\", \"properties\" : { \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"filter\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"key\" : { \"type\" : \"string\" }, \"operation\" : { \"type\" : \"string\", \"enum\" : [ \"Get\", \"GetAndRemove\", \"Set\", \"Push\", \"Pop\" ] } }, \"required\" : [ \"operation\" ] }, \"org.apache.camel.model.ContextScanDefinition\" : { \"type\" : \"object\", \"properties\" : { \"excludes\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"include-non-singletons\" : { \"type\" : \"boolean\" }, \"includes\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } } } }, \"org.apache.camel.model.ConvertBodyDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"charset\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"mandatory\" : { \"type\" : \"boolean\" }, \"type\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"type\" ] }, \"org.apache.camel.model.DataFormatDefinition\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.DelayDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"async-delayed\" : { \"type\" : \"boolean\" }, \"caller-runs-when-rejected\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.DescriptionDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"lang\" : { \"type\" : \"string\" }, \"text\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.DynamicRouterDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"cache-size\" : { \"type\" : \"number\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoints\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"uri-delimiter\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.EnrichDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"aggregate-on-exception\" : { \"type\" : \"boolean\" }, \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"allow-optimised-components\" : { \"type\" : \"boolean\" }, \"cache-size\" : { \"type\" : \"number\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoint\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"share-unit-of-work\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.ErrorHandlerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"dead-letter-channel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.DeadLetterChannelDefinition\" }, \"default-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"jta-transaction-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition\" }, \"no-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.NoErrorHandlerDefinition\" }, \"spring-transaction-error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition\" } } }, \"org.apache.camel.model.ExpressionSubElementDefinition\" : { \"type\" : \"object\", \"properties\" : { \"constant\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ConstantExpression\" }, \"csimple\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.CSimpleExpression\" }, \"datasonnet\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.DatasonnetExpression\" }, \"exchange-property\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExchangePropertyExpression\" }, \"exchangeProperty\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExchangePropertyExpression\" }, \"groovy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.GroovyExpression\" }, \"header\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.HeaderExpression\" }, \"hl7terser\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.Hl7TerserExpression\" }, \"joor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JoorExpression\" }, \"jq\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JqExpression\" }, \"js\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JavaScriptExpression\" }, \"jsonpath\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JsonPathExpression\" }, \"language\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.LanguageExpression\" }, \"method\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.MethodCallExpression\" }, \"mvel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.MvelExpression\" }, \"ognl\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.OgnlExpression\" }, \"python\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.PythonExpression\" }, \"ref\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.RefExpression\" }, \"simple\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.SimpleExpression\" }, \"spel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.SpELExpression\" }, \"tokenize\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.TokenizerExpression\" }, \"xpath\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XPathExpression\" }, \"xquery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XQueryExpression\" }, \"xtokenize\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XMLTokenizerExpression\" } } }, \"org.apache.camel.model.FaultToleranceConfigurationDefinition\" : { \"type\" : \"object\", \"properties\" : { \"bulkhead-enabled\" : { \"type\" : \"boolean\" }, \"bulkhead-executor-service\" : { \"type\" : \"string\" }, \"bulkhead-max-concurrent-calls\" : { \"type\" : \"number\" }, \"bulkhead-waiting-task-queue\" : { \"type\" : \"number\" }, \"circuit-breaker\" : { \"type\" : \"string\" }, \"delay\" : { \"type\" : \"string\" }, \"failure-ratio\" : { \"type\" : \"number\" }, \"id\" : { \"type\" : \"string\" }, \"request-volume-threshold\" : { \"type\" : \"number\" }, \"success-threshold\" : { \"type\" : \"number\" }, \"timeout-duration\" : { \"type\" : \"string\" }, \"timeout-enabled\" : { \"type\" : \"boolean\" }, \"timeout-pool-size\" : { \"type\" : \"number\" }, \"timeout-scheduled-executor-service\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.FilterDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"status-property-name\" : { \"type\" : \"string\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.FinallyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.FromDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"object\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"uri\" : { \"type\" : \"string\" } }, \"required\" : [ \"steps\", \"uri\" ] }, \"org.apache.camel.model.GlobalOptionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"key\" : { \"type\" : \"string\" }, \"value\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\", \"value\" ] }, \"org.apache.camel.model.GlobalOptionsDefinition\" : { \"type\" : \"object\", \"properties\" : { \"global-option\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.GlobalOptionDefinition\" } } } }, \"org.apache.camel.model.IdempotentConsumerDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"completion-eager\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"eager\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"idempotent-repository\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"remove-on-failure\" : { \"type\" : \"boolean\" }, \"skip-duplicate\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } }, \"required\" : [ \"idempotent-repository\" ] }, \"org.apache.camel.model.InOnlyDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"parameters\" : { \"type\" : \"object\" }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.InOutDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"parameters\" : { \"type\" : \"object\" }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.InputTypeDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"urn\" : { \"type\" : \"string\" }, \"validate\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"urn\" ] }, \"org.apache.camel.model.InterceptDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.InterceptFromDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"uri\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.InterceptSendToEndpointDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"after-uri\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"skip-send-to-original-endpoint\" : { \"type\" : \"string\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.KameletDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"name\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"object\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } } ], \"required\" : [ \"name\" ] }, \"org.apache.camel.model.LoadBalanceDefinition\" : { \"type\" : \"object\", \"properties\" : { \"custom-load-balancer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"failover\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"random\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition\" }, \"round-robin\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"sticky\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition\" }, \"topic\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition\" }, \"weighted\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition\" } } }, \"org.apache.camel.model.LogDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"log-name\" : { \"type\" : \"string\" }, \"logger\" : { \"type\" : \"string\" }, \"logging-level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"marker\" : { \"type\" : \"string\" }, \"message\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"message\" ] }, \"org.apache.camel.model.LoopDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"break-on-shutdown\" : { \"type\" : \"boolean\" }, \"copy\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"do-while\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.MarshalDefinition\" : { \"type\" : \"object\", \"properties\" : { \"any23\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Any23DataFormat\" }, \"asn1\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ASN1DataFormat\" }, \"avro\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.AvroDataFormat\" }, \"barcode\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BarcodeDataFormat\" }, \"base64\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Base64DataFormat\" }, \"bindy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BindyDataFormat\" }, \"cbor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CBORDataFormat\" }, \"crypto\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CryptoDataFormat\" }, \"csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CsvDataFormat\" }, \"custom\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CustomDataFormat\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"fhir-json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirJsonDataFormat\" }, \"fhir-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirXmlDataFormat\" }, \"flatpack\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FlatpackDataFormat\" }, \"grok\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GrokDataFormat\" }, \"gzip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GzipDeflaterDataFormat\" }, \"hl7\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.HL7DataFormat\" }, \"ical\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.IcalDataFormat\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"jackson-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JacksonXMLDataFormat\" }, \"jaxb\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JaxbDataFormat\" }, \"json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonDataFormat\" }, \"json-api\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonApiDataFormat\" }, \"lzf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.LZFDataFormat\" }, \"mime-multipart\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.MimeMultipartDataFormat\" }, \"pgp\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.PGPDataFormat\" }, \"protobuf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ProtobufDataFormat\" }, \"rss\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.RssDataFormat\" }, \"soap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SoapDataFormat\" }, \"swift-mt\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMtDataFormat\" }, \"swift-mx\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMxDataFormat\" }, \"syslog\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SyslogDataFormat\" }, \"tar-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TarFileDataFormat\" }, \"thrift\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ThriftDataFormat\" }, \"tidy-markup\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TidyMarkupDataFormat\" }, \"univocity-csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityCsvDataFormat\" }, \"univocity-fixed\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityFixedDataFormat\" }, \"univocity-tsv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityTsvDataFormat\" }, \"xml-security\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XMLSecurityDataFormat\" }, \"xstream\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XStreamDataFormat\" }, \"yaml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.YAMLDataFormat\" }, \"zip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipDeflaterDataFormat\" }, \"zip-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipFileDataFormat\" } } }, \"org.apache.camel.model.MulticastDefinition\" : { \"type\" : \"object\", \"properties\" : { \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"boolean\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-prepare\" : { \"type\" : \"string\" }, \"parallel-aggregate\" : { \"type\" : \"boolean\" }, \"parallel-processing\" : { \"type\" : \"boolean\" }, \"share-unit-of-work\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"stop-on-exception\" : { \"type\" : \"boolean\" }, \"streaming\" : { \"type\" : \"boolean\" }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.OnCompletionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"mode\" : { \"type\" : \"string\", \"enum\" : [ \"AfterConsumer\", \"BeforeConsumer\" ] }, \"on-complete-only\" : { \"type\" : \"boolean\" }, \"on-failure-only\" : { \"type\" : \"boolean\" }, \"on-when\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenDefinition\" }, \"parallel-processing\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"use-original-message\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.OnExceptionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"continued\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"exception\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"handled\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-exception-occurred-ref\" : { \"type\" : \"string\" }, \"on-redelivery-ref\" : { \"type\" : \"string\" }, \"on-when\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.WhenDefinition\" }, \"redelivery-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RedeliveryPolicyDefinition\" }, \"redelivery-policy-ref\" : { \"type\" : \"string\" }, \"retry-while\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"use-original-body\" : { \"type\" : \"boolean\" }, \"use-original-message\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.OnFallbackDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"fallback-via-network\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.OptimisticLockRetryPolicyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"exponential-back-off\" : { \"type\" : \"boolean\" }, \"maximum-retries\" : { \"type\" : \"number\" }, \"maximum-retry-delay\" : { \"type\" : \"string\" }, \"random-back-off\" : { \"type\" : \"boolean\" }, \"retry-delay\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.OtherwiseDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.OutputDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.OutputTypeDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"urn\" : { \"type\" : \"string\" }, \"validate\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"urn\" ] }, \"org.apache.camel.model.PackageScanDefinition\" : { \"type\" : \"object\", \"properties\" : { \"excludes\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"includes\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"package\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } } } }, \"org.apache.camel.model.PausableDefinition\" : { \"type\" : \"object\", \"properties\" : { \"consumer-listener\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"until-check\" : { \"type\" : \"string\" } }, \"required\" : [ \"consumer-listener\", \"until-check\" ] }, \"org.apache.camel.model.PipelineDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.PolicyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"ref\" : { \"type\" : \"string\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } }, \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.PollEnrichDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"aggregate-on-exception\" : { \"type\" : \"boolean\" }, \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"cache-size\" : { \"type\" : \"number\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoint\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.ProcessDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"ref\" : { \"type\" : \"string\" } }, \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.PropertyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"key\" : { \"type\" : \"string\" }, \"value\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\", \"value\" ] }, \"org.apache.camel.model.PropertyExpressionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"key\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.RecipientListDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"boolean\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"cache-size\" : { \"type\" : \"number\" }, \"delimiter\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoints\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-prepare\" : { \"type\" : \"string\" }, \"parallel-aggregate\" : { \"type\" : \"boolean\" }, \"parallel-processing\" : { \"type\" : \"boolean\" }, \"share-unit-of-work\" : { \"type\" : \"boolean\" }, \"stop-on-exception\" : { \"type\" : \"boolean\" }, \"streaming\" : { \"type\" : \"boolean\" }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.RedeliveryPolicyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allow-redelivery-while-stopping\" : { \"type\" : \"boolean\" }, \"async-delayed-redelivery\" : { \"type\" : \"boolean\" }, \"back-off-multiplier\" : { \"type\" : \"number\" }, \"collision-avoidance-factor\" : { \"type\" : \"number\" }, \"delay-pattern\" : { \"type\" : \"string\" }, \"disable-redelivery\" : { \"type\" : \"boolean\" }, \"exchange-formatter-ref\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"log-continued\" : { \"type\" : \"boolean\" }, \"log-exhausted\" : { \"type\" : \"boolean\" }, \"log-exhausted-message-body\" : { \"type\" : \"boolean\" }, \"log-exhausted-message-history\" : { \"type\" : \"boolean\" }, \"log-handled\" : { \"type\" : \"boolean\" }, \"log-new-exception\" : { \"type\" : \"boolean\" }, \"log-retry-attempted\" : { \"type\" : \"boolean\" }, \"log-retry-stack-trace\" : { \"type\" : \"boolean\" }, \"log-stack-trace\" : { \"type\" : \"boolean\" }, \"maximum-redeliveries\" : { \"type\" : \"number\" }, \"maximum-redelivery-delay\" : { \"type\" : \"string\" }, \"redelivery-delay\" : { \"type\" : \"string\" }, \"retries-exhausted-log-level\" : { \"type\" : \"string\" }, \"retry-attempted-log-interval\" : { \"type\" : \"number\" }, \"retry-attempted-log-level\" : { \"type\" : \"string\" }, \"use-collision-avoidance\" : { \"type\" : \"boolean\" }, \"use-exponential-back-off\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.RemoveHeaderDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"name\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"name\" ] }, \"org.apache.camel.model.RemoveHeadersDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"exclude-pattern\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"pattern\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"pattern\" ] }, \"org.apache.camel.model.RemovePropertiesDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"exclude-pattern\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"pattern\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"pattern\" ] }, \"org.apache.camel.model.RemovePropertyDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"name\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"name\" ] }, \"org.apache.camel.model.ResequenceDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"batch-config\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.config.BatchResequencerConfig\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"stream-config\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.config.StreamResequencerConfig\" } }, \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.Resilience4jConfigurationDefinition\" : { \"type\" : \"object\", \"properties\" : { \"automatic-transition-from-open-to-half-open-enabled\" : { \"type\" : \"boolean\" }, \"circuit-breaker\" : { \"type\" : \"string\" }, \"config\" : { \"type\" : \"string\" }, \"failure-rate-threshold\" : { \"type\" : \"number\" }, \"id\" : { \"type\" : \"string\" }, \"minimum-number-of-calls\" : { \"type\" : \"number\" }, \"permitted-number-of-calls-in-half-open-state\" : { \"type\" : \"number\" }, \"sliding-window-size\" : { \"type\" : \"number\" }, \"sliding-window-type\" : { \"type\" : \"string\", \"enum\" : [ \"TIME_BASED\", \"COUNT_BASED\" ] }, \"slow-call-duration-threshold\" : { \"type\" : \"number\" }, \"slow-call-rate-threshold\" : { \"type\" : \"number\" }, \"throw-exception-when-half-open-or-open-state\" : { \"type\" : \"boolean\" }, \"wait-duration-in-open-state\" : { \"type\" : \"number\" }, \"writable-stack-trace-enabled\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.RestContextRefDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.ResumableDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"intermittent\" : { \"type\" : \"boolean\" }, \"resume-strategy\" : { \"type\" : \"string\" } }, \"required\" : [ \"resume-strategy\" ] }, \"org.apache.camel.model.RollbackDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"mark-rollback-only\" : { \"type\" : \"boolean\" }, \"mark-rollback-only-last\" : { \"type\" : \"boolean\" }, \"message\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.RouteBuilderDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.RouteConfigurationContextRefDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.RouteConfigurationDefinition\" : { \"type\" : \"object\", \"properties\" : { \"error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ErrorHandlerDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"intercept\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptDefinition\" } }, \"intercept-from\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptFromDefinition\" } }, \"intercept-send-to-endpoint\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.InterceptSendToEndpointDefinition\" } }, \"on-completion\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnCompletionDefinition\" } }, \"on-exception\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnExceptionDefinition\" } }, \"precondition\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.RouteContextRefDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.RouteDefinition\" : { \"type\" : \"object\", \"properties\" : { \"auto-startup\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"from\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FromDefinition\" }, \"group\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"log-mask\" : { \"type\" : \"boolean\" }, \"message-history\" : { \"type\" : \"boolean\" }, \"node-prefix-id\" : { \"type\" : \"string\" }, \"precondition\" : { \"type\" : \"string\" }, \"route-configuration-id\" : { \"type\" : \"string\" }, \"route-policy\" : { \"type\" : \"string\" }, \"startup-order\" : { \"type\" : \"number\" }, \"stream-caching\" : { \"type\" : \"boolean\" }, \"trace\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"from\" ] }, \"org.apache.camel.model.RouteTemplateBeanDefinition\" : { \"type\" : \"object\", \"properties\" : { \"bean-type\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"object\" }, \"property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"script\" : { \"type\" : \"string\" }, \"type\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\", \"type\" ] }, \"org.apache.camel.model.RouteTemplateDefinition\" : { \"type\" : \"object\", \"properties\" : { \"beans\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition\" } }, \"from\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FromDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteTemplateParameterDefinition\" } }, \"route\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteDefinition\" } }, \"required\" : [ \"id\" ] }, \"org.apache.camel.model.RouteTemplateParameterDefinition\" : { \"type\" : \"object\", \"properties\" : { \"default-value\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" }, \"required\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"name\" ] }, \"org.apache.camel.model.RoutingSlipDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"cache-size\" : { \"type\" : \"number\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoints\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"uri-delimiter\" : { \"type\" : \"string\" } } } ], \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ] }, \"org.apache.camel.model.SagaActionUriDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"parameters\" : { \"type\" : \"object\" }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.SagaDefinition\" : { \"type\" : \"object\", \"properties\" : { \"compensation\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SagaActionUriDefinition\" }, \"completion\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.SagaActionUriDefinition\" }, \"completion-mode\" : { \"type\" : \"string\", \"enum\" : [ \"AUTO\", \"MANUAL\" ] }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"option\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyExpressionDefinition\" } }, \"propagation\" : { \"type\" : \"string\", \"enum\" : [ \"REQUIRED\", \"REQUIRES_NEW\", \"MANDATORY\", \"SUPPORTS\", \"NOT_SUPPORTED\", \"NEVER\" ] }, \"saga-service\" : { \"type\" : \"string\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.SamplingDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"message-frequency\" : { \"type\" : \"number\" }, \"sample-period\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.ScriptDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.SetBodyDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.SetExchangePatternDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] } } } ], \"required\" : [ \"pattern\" ] }, \"org.apache.camel.model.SetHeaderDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"name\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\" ] }, \"org.apache.camel.model.SetPropertyDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"name\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\" ] }, \"org.apache.camel.model.SortDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"comparator\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.SplitDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"aggregation-strategy\" : { \"type\" : \"string\" }, \"aggregation-strategy-method-allow-null\" : { \"type\" : \"boolean\" }, \"aggregation-strategy-method-name\" : { \"type\" : \"string\" }, \"delimiter\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-prepare\" : { \"type\" : \"string\" }, \"parallel-aggregate\" : { \"type\" : \"boolean\" }, \"parallel-processing\" : { \"type\" : \"boolean\" }, \"share-unit-of-work\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } }, \"stop-on-exception\" : { \"type\" : \"boolean\" }, \"streaming\" : { \"type\" : \"boolean\" }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.StepDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.StopDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.TemplatedRouteBeanDefinition\" : { \"type\" : \"object\", \"properties\" : { \"bean-type\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"object\" }, \"property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"script\" : { \"type\" : \"string\" }, \"type\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\", \"type\" ] }, \"org.apache.camel.model.TemplatedRouteDefinition\" : { \"type\" : \"object\", \"properties\" : { \"beans\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition\" } }, \"parameters\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TemplatedRouteParameterDefinition\" } }, \"prefix-id\" : { \"type\" : \"string\" }, \"route-id\" : { \"type\" : \"string\" }, \"route-template-ref\" : { \"type\" : \"string\" } }, \"required\" : [ \"route-template-ref\" ] }, \"org.apache.camel.model.TemplatedRouteParameterDefinition\" : { \"type\" : \"object\", \"properties\" : { \"name\" : { \"type\" : \"string\" }, \"value\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\", \"value\" ] }, \"org.apache.camel.model.ThreadPoolProfileDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allow-core-thread-time-out\" : { \"type\" : \"boolean\" }, \"default-profile\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"keep-alive-time\" : { \"type\" : \"number\" }, \"max-pool-size\" : { \"type\" : \"number\" }, \"max-queue-size\" : { \"type\" : \"number\" }, \"pool-size\" : { \"type\" : \"number\" }, \"rejected-policy\" : { \"type\" : \"string\", \"enum\" : [ \"Abort\", \"CallerRuns\", \"DiscardOldest\", \"Discard\" ] }, \"time-unit\" : { \"type\" : \"string\", \"enum\" : [ \"NANOSECONDS\", \"MICROSECONDS\", \"MILLISECONDS\", \"SECONDS\", \"MINUTES\", \"HOURS\", \"DAYS\" ] } } }, \"org.apache.camel.model.ThreadsDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allow-core-thread-time-out\" : { \"type\" : \"boolean\" }, \"caller-runs-when-rejected\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"keep-alive-time\" : { \"type\" : \"number\" }, \"max-pool-size\" : { \"type\" : \"number\" }, \"max-queue-size\" : { \"type\" : \"number\" }, \"pool-size\" : { \"type\" : \"number\" }, \"rejected-policy\" : { \"type\" : \"string\", \"enum\" : [ \"Abort\", \"CallerRuns\", \"DiscardOldest\", \"Discard\" ] }, \"thread-name\" : { \"type\" : \"string\" }, \"time-unit\" : { \"type\" : \"string\", \"enum\" : [ \"NANOSECONDS\", \"MICROSECONDS\", \"MILLISECONDS\", \"SECONDS\", \"MINUTES\", \"HOURS\", \"DAYS\" ] } } }, \"org.apache.camel.model.ThrottleDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"async-delayed\" : { \"type\" : \"boolean\" }, \"caller-runs-when-rejected\" : { \"type\" : \"boolean\" }, \"correlation-expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"reject-execution\" : { \"type\" : \"boolean\" }, \"time-period-millis\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.ThrowExceptionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"exception-type\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"message\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.ToDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"parameters\" : { \"type\" : \"object\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.ToDynamicDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"allow-optimised-components\" : { \"type\" : \"boolean\" }, \"auto-start-components\" : { \"type\" : \"boolean\" }, \"cache-size\" : { \"type\" : \"number\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoint\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"parameters\" : { \"type\" : \"object\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] }, \"uri\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.TransactedDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"ref\" : { \"type\" : \"string\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.TransformDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.TryDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"do-catch\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.CatchDefinition\" } }, \"do-finally\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.FinallyDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.UnmarshalDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allow-null-body\" : { \"type\" : \"boolean\" }, \"any23\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Any23DataFormat\" }, \"asn1\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ASN1DataFormat\" }, \"avro\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.AvroDataFormat\" }, \"barcode\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BarcodeDataFormat\" }, \"base64\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Base64DataFormat\" }, \"bindy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BindyDataFormat\" }, \"cbor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CBORDataFormat\" }, \"crypto\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CryptoDataFormat\" }, \"csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CsvDataFormat\" }, \"custom\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CustomDataFormat\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"fhir-json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirJsonDataFormat\" }, \"fhir-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirXmlDataFormat\" }, \"flatpack\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FlatpackDataFormat\" }, \"grok\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GrokDataFormat\" }, \"gzip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GzipDeflaterDataFormat\" }, \"hl7\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.HL7DataFormat\" }, \"ical\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.IcalDataFormat\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"jackson-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JacksonXMLDataFormat\" }, \"jaxb\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JaxbDataFormat\" }, \"json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonDataFormat\" }, \"json-api\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonApiDataFormat\" }, \"lzf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.LZFDataFormat\" }, \"mime-multipart\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.MimeMultipartDataFormat\" }, \"pgp\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.PGPDataFormat\" }, \"protobuf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ProtobufDataFormat\" }, \"rss\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.RssDataFormat\" }, \"soap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SoapDataFormat\" }, \"swift-mt\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMtDataFormat\" }, \"swift-mx\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMxDataFormat\" }, \"syslog\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SyslogDataFormat\" }, \"tar-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TarFileDataFormat\" }, \"thrift\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ThriftDataFormat\" }, \"tidy-markup\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TidyMarkupDataFormat\" }, \"univocity-csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityCsvDataFormat\" }, \"univocity-fixed\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityFixedDataFormat\" }, \"univocity-tsv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityTsvDataFormat\" }, \"xml-security\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XMLSecurityDataFormat\" }, \"xstream\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XStreamDataFormat\" }, \"yaml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.YAMLDataFormat\" }, \"zip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipDeflaterDataFormat\" }, \"zip-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipFileDataFormat\" } } }, \"org.apache.camel.model.ValidateDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"predicate-exception-factory\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.ValueDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"value\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.WhenDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.WhenSkipSendToEndpointDefinition\" : { \"type\" : \"object\", \"anyOf\" : [ { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" } ], \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"steps\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ProcessorDefinition\" } } } }, \"org.apache.camel.model.WireTapDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allow-optimised-components\" : { \"type\" : \"boolean\" }, \"auto-start-components\" : { \"type\" : \"boolean\" }, \"cache-size\" : { \"type\" : \"number\" }, \"copy\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"dynamic-uri\" : { \"type\" : \"boolean\" }, \"executor-service\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-invalid-endpoint\" : { \"type\" : \"boolean\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"on-prepare\" : { \"type\" : \"string\" }, \"parameters\" : { \"type\" : \"object\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] }, \"uri\" : { \"type\" : \"string\" } }, \"required\" : [ \"uri\" ] }, \"org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"servers\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } } } }, \"org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"combined-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration\" }, \"consul-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration\" }, \"dns-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration\" }, \"id\" : { \"type\" : \"string\" }, \"kubernetes-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"static-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration\" }, \"timeout\" : { \"type\" : \"number\" }, \"units\" : { \"type\" : \"string\", \"enum\" : [ \"NANOSECONDS\", \"MICROSECONDS\", \"MILLISECONDS\", \"SECONDS\", \"MINUTES\", \"HOURS\", \"DAYS\" ] } } }, \"org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"caching-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration\" }, \"consul-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration\" }, \"dns-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration\" }, \"id\" : { \"type\" : \"string\" }, \"kubernetes-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"static-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration\" } } }, \"org.apache.camel.model.cloud.CombinedServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"blacklist-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration\" }, \"custom-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration\" }, \"healthy-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration\" }, \"id\" : { \"type\" : \"string\" }, \"pass-through-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"acl-token\" : { \"type\" : \"string\" }, \"block-seconds\" : { \"type\" : \"number\" }, \"connect-timeout-millis\" : { \"type\" : \"number\" }, \"datacenter\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"password\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"read-timeout-millis\" : { \"type\" : \"number\" }, \"url\" : { \"type\" : \"string\" }, \"user-name\" : { \"type\" : \"string\" }, \"write-timeout-millis\" : { \"type\" : \"number\" } } }, \"org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"ref\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"domain\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"proto\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"api-version\" : { \"type\" : \"string\" }, \"ca-cert-data\" : { \"type\" : \"string\" }, \"ca-cert-file\" : { \"type\" : \"string\" }, \"client-cert-data\" : { \"type\" : \"string\" }, \"client-cert-file\" : { \"type\" : \"string\" }, \"client-key-algo\" : { \"type\" : \"string\" }, \"client-key-data\" : { \"type\" : \"string\" }, \"client-key-file\" : { \"type\" : \"string\" }, \"client-key-passphrase\" : { \"type\" : \"string\" }, \"dns-domain\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"lookup\" : { \"type\" : \"string\", \"enum\" : [ \"environment\", \"dns\", \"client\" ] }, \"master-url\" : { \"type\" : \"string\" }, \"namespace\" : { \"type\" : \"string\" }, \"oauth-token\" : { \"type\" : \"string\" }, \"password\" : { \"type\" : \"string\" }, \"port-name\" : { \"type\" : \"string\" }, \"port-protocol\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"trust-certs\" : { \"type\" : \"boolean\" }, \"username\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ServiceCallConfigurationDefinition\" : { \"type\" : \"object\", \"properties\" : { \"blacklist-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration\" }, \"caching-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration\" }, \"combined-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration\" }, \"combined-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CombinedServiceCallServiceFilterConfiguration\" }, \"component\" : { \"type\" : \"string\" }, \"consul-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration\" }, \"custom-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration\" }, \"default-load-balancer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration\" }, \"dns-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ServiceCallExpressionConfiguration\" }, \"expression-ref\" : { \"type\" : \"string\" }, \"healthy-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration\" }, \"id\" : { \"type\" : \"string\" }, \"kubernetes-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration\" }, \"load-balancer-ref\" : { \"type\" : \"string\" }, \"pass-through-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] }, \"service-chooser-ref\" : { \"type\" : \"string\" }, \"service-discovery-ref\" : { \"type\" : \"string\" }, \"service-filter-ref\" : { \"type\" : \"string\" }, \"static-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration\" }, \"uri\" : { \"type\" : \"string\" }, \"zookeeper-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration\" } } }, \"org.apache.camel.model.cloud.ServiceCallDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"blacklist-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration\" }, \"caching-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration\" }, \"combined-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration\" }, \"combined-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CombinedServiceCallServiceFilterConfiguration\" }, \"component\" : { \"type\" : \"string\" }, \"configuration-ref\" : { \"type\" : \"string\" }, \"consul-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration\" }, \"custom-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration\" }, \"default-load-balancer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"dns-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration\" }, \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ServiceCallExpressionConfiguration\" }, \"expression-ref\" : { \"type\" : \"string\" }, \"healthy-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration\" }, \"id\" : { \"type\" : \"string\" }, \"inherit-error-handler\" : { \"type\" : \"boolean\" }, \"kubernetes-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration\" }, \"load-balancer-ref\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" }, \"pass-through-service-filter\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration\" }, \"pattern\" : { \"type\" : \"string\", \"enum\" : [ \"InOnly\", \"InOut\", \"InOptionalOut\" ] }, \"service-chooser-ref\" : { \"type\" : \"string\" }, \"service-discovery-ref\" : { \"type\" : \"string\" }, \"service-filter-ref\" : { \"type\" : \"string\" }, \"static-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration\" }, \"uri\" : { \"type\" : \"string\" }, \"zookeeper-service-discovery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration\" } } } ], \"required\" : [ \"name\" ] }, \"org.apache.camel.model.cloud.ServiceCallExpressionConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"expression-type\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"host-header\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"port-header\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ServiceCallServiceChooserConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.ServiceCallServiceLoadBalancerConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } } } }, \"org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"servers\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } } } }, \"org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration\" : { \"type\" : \"object\", \"properties\" : { \"base-path\" : { \"type\" : \"string\" }, \"connection-timeout\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"namespace\" : { \"type\" : \"string\" }, \"nodes\" : { \"type\" : \"string\" }, \"properties\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"reconnect-base-sleep-time\" : { \"type\" : \"string\" }, \"reconnect-max-retries\" : { \"type\" : \"string\" }, \"reconnect-max-sleep-time\" : { \"type\" : \"string\" }, \"session-timeout\" : { \"type\" : \"string\" } }, \"required\" : [ \"base-path\", \"nodes\" ] }, \"org.apache.camel.model.config.BatchResequencerConfig\" : { \"type\" : \"object\", \"properties\" : { \"allow-duplicates\" : { \"type\" : \"boolean\" }, \"batch-size\" : { \"type\" : \"number\" }, \"batch-timeout\" : { \"type\" : \"string\" }, \"ignore-invalid-exchanges\" : { \"type\" : \"boolean\" }, \"reverse\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.config.StreamResequencerConfig\" : { \"type\" : \"object\", \"properties\" : { \"capacity\" : { \"type\" : \"number\" }, \"comparator\" : { \"type\" : \"string\" }, \"delivery-attempt-interval\" : { \"type\" : \"string\" }, \"ignore-invalid-exchanges\" : { \"type\" : \"boolean\" }, \"reject-old\" : { \"type\" : \"boolean\" }, \"timeout\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.ASN1DataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"using-iterator\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.dataformat.Any23DataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"base-uri\" : { \"type\" : \"string\" }, \"configuration\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"extractors\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"id\" : { \"type\" : \"string\" }, \"output-format\" : { \"type\" : \"string\", \"enum\" : [ \"NTRIPLES\", \"TURTLE\", \"NQUADS\", \"RDFXML\", \"JSONLD\", \"RDFJSON\", \"RDF4JMODEL\" ] } } } ] }, \"org.apache.camel.model.dataformat.AvroDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"allow-jms-type\" : { \"type\" : \"boolean\" }, \"allow-unmarshall-type\" : { \"type\" : \"boolean\" }, \"auto-discover-object-mapper\" : { \"type\" : \"boolean\" }, \"auto-discover-schema-resolver\" : { \"type\" : \"boolean\" }, \"collection-type\" : { \"type\" : \"string\" }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"disable-features\" : { \"type\" : \"string\" }, \"enable-features\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"include\" : { \"type\" : \"string\" }, \"instance-class-name\" : { \"type\" : \"string\" }, \"json-view\" : { \"type\" : \"string\" }, \"library\" : { \"type\" : \"string\", \"enum\" : [ \"ApacheAvro\", \"Jackson\" ] }, \"module-class-names\" : { \"type\" : \"string\" }, \"module-refs\" : { \"type\" : \"string\" }, \"object-mapper\" : { \"type\" : \"string\" }, \"schema-resolver\" : { \"type\" : \"string\" }, \"timezone\" : { \"type\" : \"string\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-default-object-mapper\" : { \"type\" : \"boolean\" }, \"use-list\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.dataformat.BarcodeDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"barcode-format\" : { \"type\" : \"string\" }, \"height\" : { \"type\" : \"number\" }, \"id\" : { \"type\" : \"string\" }, \"image-type\" : { \"type\" : \"string\" }, \"width\" : { \"type\" : \"number\" } } }, \"org.apache.camel.model.dataformat.Base64DataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"line-length\" : { \"type\" : \"number\" }, \"line-separator\" : { \"type\" : \"string\" }, \"url-safe\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.BindyDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-empty-stream\" : { \"type\" : \"boolean\" }, \"class-type\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"locale\" : { \"type\" : \"string\" }, \"type\" : { \"type\" : \"string\", \"enum\" : [ \"Csv\", \"Fixed\", \"KeyValue\" ] }, \"unwrap-single-instance\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"type\" ] }, \"org.apache.camel.model.dataformat.CBORDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-jms-type\" : { \"type\" : \"boolean\" }, \"allow-unmarshall-type\" : { \"type\" : \"boolean\" }, \"collection-type\" : { \"type\" : \"string\" }, \"disable-features\" : { \"type\" : \"string\" }, \"enable-features\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"object-mapper\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-default-object-mapper\" : { \"type\" : \"boolean\" }, \"use-list\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.CryptoDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"algorithm\" : { \"type\" : \"string\" }, \"algorithm-parameter-ref\" : { \"type\" : \"string\" }, \"buffer-size\" : { \"type\" : \"number\" }, \"crypto-provider\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"init-vector-ref\" : { \"type\" : \"string\" }, \"inline\" : { \"type\" : \"boolean\" }, \"key-ref\" : { \"type\" : \"string\" }, \"mac-algorithm\" : { \"type\" : \"string\" }, \"should-append-hmac\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.CsvDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"allow-missing-column-names\" : { \"type\" : \"boolean\" }, \"capture-header-record\" : { \"type\" : \"boolean\" }, \"comment-marker\" : { \"type\" : \"string\" }, \"comment-marker-disabled\" : { \"type\" : \"boolean\" }, \"delimiter\" : { \"type\" : \"string\" }, \"escape\" : { \"type\" : \"string\" }, \"escape-disabled\" : { \"type\" : \"boolean\" }, \"format-name\" : { \"type\" : \"string\", \"enum\" : [ \"DEFAULT\", \"EXCEL\", \"INFORMIX_UNLOAD\", \"INFORMIX_UNLOAD_CSV\", \"MYSQL\", \"RFC4180\" ] }, \"format-ref\" : { \"type\" : \"string\" }, \"header\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"header-disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-empty-lines\" : { \"type\" : \"boolean\" }, \"ignore-header-case\" : { \"type\" : \"boolean\" }, \"ignore-surrounding-spaces\" : { \"type\" : \"boolean\" }, \"lazy-load\" : { \"type\" : \"boolean\" }, \"marshaller-factory-ref\" : { \"type\" : \"string\" }, \"null-string\" : { \"type\" : \"string\" }, \"null-string-disabled\" : { \"type\" : \"boolean\" }, \"quote\" : { \"type\" : \"string\" }, \"quote-disabled\" : { \"type\" : \"boolean\" }, \"quote-mode\" : { \"type\" : \"string\", \"enum\" : [ \"ALL\", \"ALL_NON_NULL\", \"MINIMAL\", \"NON_NUMERIC\", \"NONE\" ] }, \"record-converter-ref\" : { \"type\" : \"string\" }, \"record-separator\" : { \"type\" : \"string\" }, \"record-separator-disabled\" : { \"type\" : \"string\" }, \"skip-header-record\" : { \"type\" : \"boolean\" }, \"trailing-delimiter\" : { \"type\" : \"boolean\" }, \"trim\" : { \"type\" : \"boolean\" }, \"use-maps\" : { \"type\" : \"boolean\" }, \"use-ordered-maps\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.dataformat.CustomDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.dataformat.DataFormatsDefinition\" : { \"type\" : \"object\", \"properties\" : { \"any23\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Any23DataFormat\" }, \"asn1\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ASN1DataFormat\" }, \"avro\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.AvroDataFormat\" }, \"barcode\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BarcodeDataFormat\" }, \"base64\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Base64DataFormat\" }, \"bindy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BindyDataFormat\" }, \"cbor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CBORDataFormat\" }, \"crypto\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CryptoDataFormat\" }, \"csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CsvDataFormat\" }, \"custom\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CustomDataFormat\" }, \"fhir-json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirJsonDataFormat\" }, \"fhir-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirXmlDataFormat\" }, \"flatpack\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FlatpackDataFormat\" }, \"grok\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GrokDataFormat\" }, \"gzip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GzipDeflaterDataFormat\" }, \"hl7\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.HL7DataFormat\" }, \"ical\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.IcalDataFormat\" }, \"jackson-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JacksonXMLDataFormat\" }, \"jaxb\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JaxbDataFormat\" }, \"json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonDataFormat\" }, \"json-api\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonApiDataFormat\" }, \"lzf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.LZFDataFormat\" }, \"mime-multipart\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.MimeMultipartDataFormat\" }, \"pgp\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.PGPDataFormat\" }, \"protobuf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ProtobufDataFormat\" }, \"rss\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.RssDataFormat\" }, \"soap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SoapDataFormat\" }, \"swift-mt\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMtDataFormat\" }, \"swift-mx\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMxDataFormat\" }, \"syslog\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SyslogDataFormat\" }, \"tar-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TarFileDataFormat\" }, \"thrift\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ThriftDataFormat\" }, \"tidy-markup\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TidyMarkupDataFormat\" }, \"univocity-csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityCsvDataFormat\" }, \"univocity-fixed\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityFixedDataFormat\" }, \"univocity-tsv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityTsvDataFormat\" }, \"xml-security\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XMLSecurityDataFormat\" }, \"xstream\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XStreamDataFormat\" }, \"yaml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.YAMLDataFormat\" }, \"zip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipDeflaterDataFormat\" }, \"zip-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipFileDataFormat\" } } }, \"org.apache.camel.model.dataformat.FhirJsonDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"content-type-header\" : { \"type\" : \"boolean\" }, \"dont-encode-elements\" : { \"type\" : \"string\" }, \"dont-strip-versions-from-references-at-paths\" : { \"type\" : \"string\" }, \"encode-elements\" : { \"type\" : \"string\" }, \"encode-elements-applies-to-child-resources-only\" : { \"type\" : \"boolean\" }, \"fhir-context\" : { \"type\" : \"string\" }, \"fhir-version\" : { \"type\" : \"string\", \"enum\" : [ \"DSTU2\", \"DSTU2_HL7ORG\", \"DSTU2_1\", \"DSTU3\", \"R4\", \"R5\" ] }, \"force-resource-id\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"omit-resource-id\" : { \"type\" : \"boolean\" }, \"override-resource-id-with-bundle-entry-full-url\" : { \"type\" : \"boolean\" }, \"parser-error-handler\" : { \"type\" : \"string\" }, \"parser-options\" : { \"type\" : \"string\" }, \"prefer-types\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"server-base-url\" : { \"type\" : \"string\" }, \"strip-versions-from-references\" : { \"type\" : \"boolean\" }, \"summary-mode\" : { \"type\" : \"boolean\" }, \"suppress-narratives\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.FhirXmlDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"content-type-header\" : { \"type\" : \"boolean\" }, \"dont-encode-elements\" : { \"type\" : \"string\" }, \"dont-strip-versions-from-references-at-paths\" : { \"type\" : \"string\" }, \"encode-elements\" : { \"type\" : \"string\" }, \"encode-elements-applies-to-child-resources-only\" : { \"type\" : \"boolean\" }, \"fhir-context\" : { \"type\" : \"string\" }, \"fhir-version\" : { \"type\" : \"string\", \"enum\" : [ \"DSTU2\", \"DSTU2_HL7ORG\", \"DSTU2_1\", \"DSTU3\", \"R4\", \"R5\" ] }, \"force-resource-id\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"omit-resource-id\" : { \"type\" : \"boolean\" }, \"override-resource-id-with-bundle-entry-full-url\" : { \"type\" : \"boolean\" }, \"parser-error-handler\" : { \"type\" : \"string\" }, \"parser-options\" : { \"type\" : \"string\" }, \"prefer-types\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"server-base-url\" : { \"type\" : \"string\" }, \"strip-versions-from-references\" : { \"type\" : \"boolean\" }, \"summary-mode\" : { \"type\" : \"boolean\" }, \"suppress-narratives\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.FlatpackDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-short-lines\" : { \"type\" : \"boolean\" }, \"definition\" : { \"type\" : \"string\" }, \"delimiter\" : { \"type\" : \"string\" }, \"fixed\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-extra-columns\" : { \"type\" : \"boolean\" }, \"ignore-first-record\" : { \"type\" : \"boolean\" }, \"parser-factory-ref\" : { \"type\" : \"string\" }, \"text-qualifier\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.GrokDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-multiple-matches-per-line\" : { \"type\" : \"boolean\" }, \"flattened\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"named-only\" : { \"type\" : \"boolean\" }, \"pattern\" : { \"type\" : \"string\" } }, \"required\" : [ \"pattern\" ] }, \"org.apache.camel.model.dataformat.GzipDeflaterDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.HL7DataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"validate\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.IcalDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"validating\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.JacksonXMLDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-jms-type\" : { \"type\" : \"boolean\" }, \"allow-unmarshall-type\" : { \"type\" : \"boolean\" }, \"collection-type\" : { \"type\" : \"string\" }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"disable-features\" : { \"type\" : \"string\" }, \"enable-features\" : { \"type\" : \"string\" }, \"enable-jaxb-annotation-module\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"include\" : { \"type\" : \"string\" }, \"json-view\" : { \"type\" : \"string\" }, \"module-class-names\" : { \"type\" : \"string\" }, \"module-refs\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"timezone\" : { \"type\" : \"string\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-list\" : { \"type\" : \"boolean\" }, \"xml-mapper\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.JaxbDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"content-type-header\" : { \"type\" : \"boolean\" }, \"context-path\" : { \"type\" : \"string\" }, \"context-path-is-class-name\" : { \"type\" : \"boolean\" }, \"encoding\" : { \"type\" : \"string\" }, \"filter-non-xml-chars\" : { \"type\" : \"boolean\" }, \"fragment\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-jaxb-element\" : { \"type\" : \"boolean\" }, \"jaxb-provider-properties\" : { \"type\" : \"string\" }, \"must-be-jaxb-element\" : { \"type\" : \"boolean\" }, \"namespace-prefix-ref\" : { \"type\" : \"string\" }, \"no-namespace-schema-location\" : { \"type\" : \"string\" }, \"object-factory\" : { \"type\" : \"boolean\" }, \"part-class\" : { \"type\" : \"string\" }, \"part-namespace\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"schema\" : { \"type\" : \"string\" }, \"schema-location\" : { \"type\" : \"string\" }, \"schema-severity-level\" : { \"type\" : \"string\", \"enum\" : [ \"0\", \"1\", \"2\" ] }, \"xml-stream-writer-wrapper\" : { \"type\" : \"string\" } }, \"required\" : [ \"context-path\" ] }, \"org.apache.camel.model.dataformat.JsonApiDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"data-format-types\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"main-format-type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.JsonDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-jms-type\" : { \"type\" : \"boolean\" }, \"allow-unmarshall-type\" : { \"type\" : \"boolean\" }, \"auto-discover-object-mapper\" : { \"type\" : \"boolean\" }, \"auto-discover-schema-resolver\" : { \"type\" : \"boolean\" }, \"collection-type\" : { \"type\" : \"string\" }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"disable-features\" : { \"type\" : \"string\" }, \"drop-root-node\" : { \"type\" : \"boolean\" }, \"enable-features\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"include\" : { \"type\" : \"string\" }, \"json-view\" : { \"type\" : \"string\" }, \"library\" : { \"type\" : \"string\", \"enum\" : [ \"Fastjson\", \"Gson\", \"Jackson\", \"Johnzon\", \"Jsonb\", \"XStream\" ] }, \"module-class-names\" : { \"type\" : \"string\" }, \"module-refs\" : { \"type\" : \"string\" }, \"naming-strategy\" : { \"type\" : \"string\" }, \"object-mapper\" : { \"type\" : \"string\" }, \"permissions\" : { \"type\" : \"string\" }, \"pretty-print\" : { \"type\" : \"boolean\" }, \"schema-resolver\" : { \"type\" : \"string\" }, \"timezone\" : { \"type\" : \"string\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-default-object-mapper\" : { \"type\" : \"boolean\" }, \"use-list\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.LZFDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"using-parallel-compression\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.MimeMultipartDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"binary-content\" : { \"type\" : \"boolean\" }, \"headers-inline\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"include-headers\" : { \"type\" : \"string\" }, \"multipart-sub-type\" : { \"type\" : \"string\" }, \"multipart-without-attachment\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.PGPDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"algorithm\" : { \"type\" : \"number\" }, \"armored\" : { \"type\" : \"boolean\" }, \"compression-algorithm\" : { \"type\" : \"number\" }, \"hash-algorithm\" : { \"type\" : \"number\" }, \"id\" : { \"type\" : \"string\" }, \"integrity\" : { \"type\" : \"boolean\" }, \"key-file-name\" : { \"type\" : \"string\" }, \"key-userid\" : { \"type\" : \"string\" }, \"password\" : { \"type\" : \"string\" }, \"provider\" : { \"type\" : \"string\" }, \"signature-key-file-name\" : { \"type\" : \"string\" }, \"signature-key-ring\" : { \"type\" : \"string\" }, \"signature-key-userid\" : { \"type\" : \"string\" }, \"signature-password\" : { \"type\" : \"string\" }, \"signature-verification-option\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.ProtobufDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"allow-jms-type\" : { \"type\" : \"boolean\" }, \"allow-unmarshall-type\" : { \"type\" : \"boolean\" }, \"auto-discover-object-mapper\" : { \"type\" : \"boolean\" }, \"auto-discover-schema-resolver\" : { \"type\" : \"boolean\" }, \"collection-type\" : { \"type\" : \"string\" }, \"content-type-format\" : { \"type\" : \"string\", \"enum\" : [ \"native\", \"json\" ] }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"disable-features\" : { \"type\" : \"string\" }, \"enable-features\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"include\" : { \"type\" : \"string\" }, \"instance-class\" : { \"type\" : \"string\" }, \"json-view\" : { \"type\" : \"string\" }, \"library\" : { \"type\" : \"string\", \"enum\" : [ \"GoogleProtobuf\", \"Jackson\" ] }, \"module-class-names\" : { \"type\" : \"string\" }, \"module-refs\" : { \"type\" : \"string\" }, \"object-mapper\" : { \"type\" : \"string\" }, \"schema-resolver\" : { \"type\" : \"string\" }, \"timezone\" : { \"type\" : \"string\" }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-default-object-mapper\" : { \"type\" : \"boolean\" }, \"use-list\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.dataformat.RssDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.SoapDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"context-path\" : { \"type\" : \"string\" }, \"element-name-strategy-ref\" : { \"type\" : \"string\" }, \"encoding\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"namespace-prefix-ref\" : { \"type\" : \"string\" }, \"schema\" : { \"type\" : \"string\" }, \"version\" : { \"type\" : \"string\", \"enum\" : [ \"1.1\", \"1.2\" ] } } } ], \"required\" : [ \"context-path\" ] }, \"org.apache.camel.model.dataformat.SwiftMtDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"write-in-json\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.dataformat.SwiftMxDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"read-config-ref\" : { \"type\" : \"string\" }, \"read-message-id\" : { \"type\" : \"string\" }, \"write-config-ref\" : { \"type\" : \"string\" }, \"write-in-json\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.SyslogDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.TarFileDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-empty-directory\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"max-decompressed-size\" : { \"type\" : \"number\" }, \"preserve-path-elements\" : { \"type\" : \"boolean\" }, \"using-iterator\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.ThriftDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"content-type-format\" : { \"type\" : \"string\", \"enum\" : [ \"binary\", \"json\", \"sjson\" ] }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"instance-class\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.dataformat.TidyMarkupDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"data-object-type\" : { \"type\" : \"string\", \"enum\" : [ \"org.w3c.dom.Node\", \"java.lang.String\" ] }, \"id\" : { \"type\" : \"string\" }, \"omit-xml-declaration\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.UniVocityCsvDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"as-map\" : { \"type\" : \"boolean\" }, \"comment\" : { \"type\" : \"string\" }, \"delimiter\" : { \"type\" : \"string\" }, \"empty-value\" : { \"type\" : \"string\" }, \"header-extraction-enabled\" : { \"type\" : \"boolean\" }, \"headers-disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-leading-whitespaces\" : { \"type\" : \"boolean\" }, \"ignore-trailing-whitespaces\" : { \"type\" : \"boolean\" }, \"lazy-load\" : { \"type\" : \"boolean\" }, \"line-separator\" : { \"type\" : \"string\" }, \"normalized-line-separator\" : { \"type\" : \"string\" }, \"null-value\" : { \"type\" : \"string\" }, \"number-of-records-to-read\" : { \"type\" : \"number\" }, \"quote\" : { \"type\" : \"string\" }, \"quote-all-fields\" : { \"type\" : \"boolean\" }, \"quote-escape\" : { \"type\" : \"string\" }, \"skip-empty-lines\" : { \"type\" : \"boolean\" }, \"univocity-header\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityHeader\" } } } }, \"org.apache.camel.model.dataformat.UniVocityFixedDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"as-map\" : { \"type\" : \"boolean\" }, \"comment\" : { \"type\" : \"string\" }, \"empty-value\" : { \"type\" : \"string\" }, \"header-extraction-enabled\" : { \"type\" : \"boolean\" }, \"headers-disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-leading-whitespaces\" : { \"type\" : \"boolean\" }, \"ignore-trailing-whitespaces\" : { \"type\" : \"boolean\" }, \"lazy-load\" : { \"type\" : \"boolean\" }, \"line-separator\" : { \"type\" : \"string\" }, \"normalized-line-separator\" : { \"type\" : \"string\" }, \"null-value\" : { \"type\" : \"string\" }, \"number-of-records-to-read\" : { \"type\" : \"number\" }, \"padding\" : { \"type\" : \"string\" }, \"record-ends-on-newline\" : { \"type\" : \"boolean\" }, \"skip-empty-lines\" : { \"type\" : \"boolean\" }, \"skip-trailing-chars-until-newline\" : { \"type\" : \"boolean\" }, \"univocity-header\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityHeader\" } } } }, \"org.apache.camel.model.dataformat.UniVocityHeader\" : { \"type\" : \"object\", \"properties\" : { \"length\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.UniVocityTsvDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"as-map\" : { \"type\" : \"boolean\" }, \"comment\" : { \"type\" : \"string\" }, \"empty-value\" : { \"type\" : \"string\" }, \"escape-char\" : { \"type\" : \"string\" }, \"header-extraction-enabled\" : { \"type\" : \"boolean\" }, \"headers-disabled\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"ignore-leading-whitespaces\" : { \"type\" : \"boolean\" }, \"ignore-trailing-whitespaces\" : { \"type\" : \"boolean\" }, \"lazy-load\" : { \"type\" : \"boolean\" }, \"line-separator\" : { \"type\" : \"string\" }, \"normalized-line-separator\" : { \"type\" : \"string\" }, \"null-value\" : { \"type\" : \"string\" }, \"number-of-records-to-read\" : { \"type\" : \"number\" }, \"skip-empty-lines\" : { \"type\" : \"boolean\" }, \"univocity-header\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityHeader\" } } } }, \"org.apache.camel.model.dataformat.XMLSecurityDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"add-key-value-for-encrypted-key\" : { \"type\" : \"boolean\" }, \"digest-algorithm\" : { \"type\" : \"string\", \"enum\" : [ \"SHA1\", \"SHA256\", \"SHA512\" ] }, \"id\" : { \"type\" : \"string\" }, \"key-cipher-algorithm\" : { \"type\" : \"string\", \"enum\" : [ \"RSA_v1dot5\", \"RSA_OAEP\", \"RSA_OAEP_11\" ] }, \"key-or-trust-store-parameters-ref\" : { \"type\" : \"string\" }, \"key-password\" : { \"type\" : \"string\" }, \"mgf-algorithm\" : { \"type\" : \"string\", \"enum\" : [ \"MGF1_SHA1\", \"MGF1_SHA256\", \"MGF1_SHA512\" ] }, \"pass-phrase\" : { \"type\" : \"string\" }, \"pass-phrase-byte\" : { \"type\" : \"string\" }, \"recipient-key-alias\" : { \"type\" : \"string\" }, \"secure-tag\" : { \"type\" : \"string\" }, \"secure-tag-contents\" : { \"type\" : \"boolean\" }, \"xml-cipher-algorithm\" : { \"type\" : \"string\", \"enum\" : [ \"TRIPLEDES\", \"AES_128\", \"AES_128_GCM\", \"AES_192\", \"AES_192_GCM\", \"AES_256\", \"AES_256_GCM\", \"SEED_128\", \"CAMELLIA_128\", \"CAMELLIA_192\", \"CAMELLIA_256\" ] } } }, \"org.apache.camel.model.dataformat.XStreamDataFormat\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"aliases\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"content-type-header\" : { \"type\" : \"boolean\" }, \"converters\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"driver\" : { \"type\" : \"string\" }, \"driver-ref\" : { \"type\" : \"string\" }, \"encoding\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"implicit-collections\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"mode\" : { \"type\" : \"string\", \"enum\" : [ \"NO_REFERENCES\", \"ID_REFERENCES\", \"XPATH_RELATIVE_REFERENCES\", \"XPATH_ABSOLUTE_REFERENCES\", \"SINGLE_NODE_XPATH_RELATIVE_REFERENCES\", \"SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES\" ] }, \"omit-fields\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"permissions\" : { \"type\" : \"string\" } } } ] }, \"org.apache.camel.model.dataformat.YAMLDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-any-type\" : { \"type\" : \"boolean\" }, \"allow-recursive-keys\" : { \"type\" : \"boolean\" }, \"constructor\" : { \"type\" : \"string\" }, \"dumper-options\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"library\" : { \"type\" : \"string\", \"enum\" : [ \"SnakeYAML\" ] }, \"max-aliases-for-collections\" : { \"type\" : \"number\" }, \"pretty-flow\" : { \"type\" : \"boolean\" }, \"representer\" : { \"type\" : \"string\" }, \"resolver\" : { \"type\" : \"string\" }, \"type-filter\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.YAMLTypeFilterDefinition\" } }, \"unmarshal-type\" : { \"type\" : \"string\" }, \"use-application-context-class-loader\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.dataformat.YAMLTypeFilterDefinition\" : { \"type\" : \"object\", \"properties\" : { \"type\" : { \"type\" : \"string\" }, \"value\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.ZipDeflaterDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"compression-level\" : { \"type\" : \"string\", \"enum\" : [ \"-1\", \"0\", \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\" ] }, \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.dataformat.ZipFileDataFormat\" : { \"type\" : \"object\", \"properties\" : { \"allow-empty-directory\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"max-decompressed-size\" : { \"type\" : \"number\" }, \"preserve-path-elements\" : { \"type\" : \"boolean\" }, \"using-iterator\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.errorhandler.DeadLetterChannelDefinition\" : { \"type\" : \"object\", \"properties\" : { \"dead-letter-handle-new-exception\" : { \"type\" : \"boolean\" }, \"dead-letter-uri\" : { \"type\" : \"string\" }, \"executor-service-ref\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"log-name\" : { \"type\" : \"string\" }, \"logger-ref\" : { \"type\" : \"string\" }, \"on-exception-occurred-ref\" : { \"type\" : \"string\" }, \"on-prepare-failure-ref\" : { \"type\" : \"string\" }, \"on-redelivery-ref\" : { \"type\" : \"string\" }, \"redelivery-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RedeliveryPolicyDefinition\" }, \"redelivery-policy-ref\" : { \"type\" : \"string\" }, \"retry-while-ref\" : { \"type\" : \"string\" }, \"use-original-body\" : { \"type\" : \"boolean\" }, \"use-original-message\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"dead-letter-uri\" ] }, \"org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"executor-service-ref\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"log-name\" : { \"type\" : \"string\" }, \"logger-ref\" : { \"type\" : \"string\" }, \"on-exception-occurred-ref\" : { \"type\" : \"string\" }, \"on-prepare-failure-ref\" : { \"type\" : \"string\" }, \"on-redelivery-ref\" : { \"type\" : \"string\" }, \"redelivery-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RedeliveryPolicyDefinition\" }, \"redelivery-policy-ref\" : { \"type\" : \"string\" }, \"retry-while-ref\" : { \"type\" : \"string\" }, \"use-original-body\" : { \"type\" : \"boolean\" }, \"use-original-message\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"executor-service-ref\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"log-name\" : { \"type\" : \"string\" }, \"logger-ref\" : { \"type\" : \"string\" }, \"on-exception-occurred-ref\" : { \"type\" : \"string\" }, \"on-prepare-failure-ref\" : { \"type\" : \"string\" }, \"on-redelivery-ref\" : { \"type\" : \"string\" }, \"redelivery-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RedeliveryPolicyDefinition\" }, \"redelivery-policy-ref\" : { \"type\" : \"string\" }, \"retry-while-ref\" : { \"type\" : \"string\" }, \"rollback-logging-level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"transacted-policy-ref\" : { \"type\" : \"string\" }, \"use-original-body\" : { \"type\" : \"boolean\" }, \"use-original-message\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.errorhandler.NoErrorHandlerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.errorhandler.RefErrorHandlerDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"executor-service-ref\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"log-name\" : { \"type\" : \"string\" }, \"logger-ref\" : { \"type\" : \"string\" }, \"on-exception-occurred-ref\" : { \"type\" : \"string\" }, \"on-prepare-failure-ref\" : { \"type\" : \"string\" }, \"on-redelivery-ref\" : { \"type\" : \"string\" }, \"redelivery-policy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RedeliveryPolicyDefinition\" }, \"redelivery-policy-ref\" : { \"type\" : \"string\" }, \"retry-while-ref\" : { \"type\" : \"string\" }, \"rollback-logging-level\" : { \"type\" : \"string\", \"enum\" : [ \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" ] }, \"transacted-policy-ref\" : { \"type\" : \"string\" }, \"use-original-body\" : { \"type\" : \"boolean\" }, \"use-original-message\" : { \"type\" : \"boolean\" } } }, \"org.apache.camel.model.language.CSimpleExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.ConstantExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.DatasonnetExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"body-media-type\" : { \"type\" : \"string\" }, \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"output-media-type\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.ExchangePropertyExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.ExpressionDefinition\" : { \"type\" : \"object\", \"properties\" : { \"constant\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ConstantExpression\" }, \"csimple\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.CSimpleExpression\" }, \"datasonnet\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.DatasonnetExpression\" }, \"exchange-property\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExchangePropertyExpression\" }, \"exchangeProperty\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExchangePropertyExpression\" }, \"groovy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.GroovyExpression\" }, \"header\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.HeaderExpression\" }, \"hl7terser\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.Hl7TerserExpression\" }, \"joor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JoorExpression\" }, \"jq\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JqExpression\" }, \"js\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JavaScriptExpression\" }, \"jsonpath\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.JsonPathExpression\" }, \"language\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.LanguageExpression\" }, \"method\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.MethodCallExpression\" }, \"mvel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.MvelExpression\" }, \"ognl\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.OgnlExpression\" }, \"python\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.PythonExpression\" }, \"ref\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.RefExpression\" }, \"simple\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.SimpleExpression\" }, \"spel\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.SpELExpression\" }, \"tokenize\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.TokenizerExpression\" }, \"xpath\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XPathExpression\" }, \"xquery\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XQueryExpression\" }, \"xtokenize\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.XMLTokenizerExpression\" } } }, \"org.apache.camel.model.language.GroovyExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.HeaderExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.Hl7TerserExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"property-name\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.JavaScriptExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.JoorExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"pre-compile\" : { \"type\" : \"boolean\" }, \"result-type\" : { \"type\" : \"string\" }, \"single-quotes\" : { \"type\" : \"boolean\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.JqExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"property-name\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.JsonPathExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"allow-easy-predicate\" : { \"type\" : \"boolean\" }, \"allow-simple\" : { \"type\" : \"boolean\" }, \"expression\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"option\" : { \"type\" : \"string\", \"enum\" : [ \"DEFAULT_PATH_LEAF_TO_NULL\", \"ALWAYS_RETURN_LIST\", \"AS_PATH_LIST\", \"SUPPRESS_EXCEPTIONS\", \"REQUIRE_PROPERTIES\" ] }, \"property-name\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"suppress-exceptions\" : { \"type\" : \"boolean\" }, \"trim\" : { \"type\" : \"boolean\" }, \"unpack-array\" : { \"type\" : \"boolean\" }, \"write-as-string\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.LanguageExpression\" : { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"language\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"expression\", \"language\" ] }, \"org.apache.camel.model.language.MethodCallExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"bean-type\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"method\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"scope\" : { \"type\" : \"string\", \"enum\" : [ \"Singleton\", \"Request\", \"Prototype\" ] }, \"trim\" : { \"type\" : \"boolean\" } } } ] }, \"org.apache.camel.model.language.MvelExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.OgnlExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.PythonExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.RefExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.SimpleExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.SpELExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.TokenizerExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"end-token\" : { \"type\" : \"string\" }, \"group\" : { \"type\" : \"string\" }, \"group-delimiter\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"include-tokens\" : { \"type\" : \"boolean\" }, \"inherit-namespace-tag-name\" : { \"type\" : \"string\" }, \"property-name\" : { \"type\" : \"string\" }, \"regex\" : { \"type\" : \"boolean\" }, \"skip-first\" : { \"type\" : \"boolean\" }, \"token\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" }, \"xml\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"token\" ] }, \"org.apache.camel.model.language.XMLTokenizerExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"type\" : \"string\" }, \"group\" : { \"type\" : \"number\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"mode\" : { \"type\" : \"string\", \"enum\" : [ \"i\", \"w\", \"u\", \"t\" ] }, \"namespace\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"property-name\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.XPathExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"document-type\" : { \"type\" : \"string\" }, \"expression\" : { \"type\" : \"string\" }, \"factory-ref\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"log-namespaces\" : { \"type\" : \"boolean\" }, \"namespace\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"object-model\" : { \"type\" : \"string\" }, \"pre-compile\" : { \"type\" : \"boolean\" }, \"property-name\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\", \"enum\" : [ \"NUMBER\", \"STRING\", \"BOOLEAN\", \"NODESET\", \"NODE\" ] }, \"saxon\" : { \"type\" : \"boolean\" }, \"thread-safety\" : { \"type\" : \"boolean\" }, \"trim\" : { \"type\" : \"boolean\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.language.XQueryExpression\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"configuration-ref\" : { \"type\" : \"string\" }, \"expression\" : { \"type\" : \"string\" }, \"header-name\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"namespace\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.PropertyDefinition\" } }, \"property-name\" : { \"type\" : \"string\" }, \"result-type\" : { \"type\" : \"string\" }, \"trim\" : { \"type\" : \"boolean\" }, \"type\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"expression\" ] }, \"org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition\" : { \"oneOf\" : [ { \"type\" : \"string\" }, { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" } } } ], \"required\" : [ \"ref\" ] }, \"org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"exception\" : { \"type\" : \"array\", \"items\" : { \"type\" : \"string\" } }, \"id\" : { \"type\" : \"string\" }, \"maximum-failover-attempts\" : { \"type\" : \"string\" }, \"round-robin\" : { \"type\" : \"string\" }, \"sticky\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"correlation-expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ExpressionSubElementDefinition\" }, \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"id\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"distribution-ratio\" : { \"type\" : \"string\" }, \"distribution-ratio-delimiter\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"round-robin\" : { \"type\" : \"boolean\" } }, \"required\" : [ \"distribution-ratio\" ] }, \"org.apache.camel.model.rest.ApiKeyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"in-cookie\" : { \"type\" : \"boolean\" }, \"in-header\" : { \"type\" : \"boolean\" }, \"in-query\" : { \"type\" : \"boolean\" }, \"key\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\", \"name\" ] }, \"org.apache.camel.model.rest.BasicAuthDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"key\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.rest.BearerTokenDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"format\" : { \"type\" : \"string\" }, \"key\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.rest.DeleteDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.GetDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.HeadDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.MutualTLSDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"key\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.rest.OAuth2Definition\" : { \"type\" : \"object\", \"properties\" : { \"authorization-url\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"flow\" : { \"type\" : \"string\", \"enum\" : [ \"implicit\", \"password\", \"application\", \"clientCredentials\", \"accessCode\", \"authorizationCode\" ] }, \"key\" : { \"type\" : \"string\" }, \"refresh-url\" : { \"type\" : \"string\" }, \"scopes\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"token-url\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.rest.OpenIdConnectDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"key\" : { \"type\" : \"string\" }, \"url\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\", \"url\" ] }, \"org.apache.camel.model.rest.ParamDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allowable-values\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ValueDefinition\" } }, \"array-type\" : { \"type\" : \"string\" }, \"collection-format\" : { \"type\" : \"string\", \"enum\" : [ \"csv\", \"multi\", \"pipes\", \"ssv\", \"tsv\" ] }, \"data-format\" : { \"type\" : \"string\" }, \"data-type\" : { \"type\" : \"string\" }, \"default-value\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"examples\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"name\" : { \"type\" : \"string\" }, \"required\" : { \"type\" : \"boolean\" }, \"type\" : { \"type\" : \"string\", \"enum\" : [ \"body\", \"formData\", \"header\", \"path\", \"query\" ] } }, \"required\" : [ \"name\", \"type\" ] }, \"org.apache.camel.model.rest.PatchDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.PostDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.PutDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"deprecated\" : { \"type\" : \"boolean\" }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"param\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ParamDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"response-message\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseMessageDefinition\" } }, \"route-id\" : { \"type\" : \"string\" }, \"security\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"to\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ToDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.ResponseHeaderDefinition\" : { \"type\" : \"object\", \"properties\" : { \"allowable-values\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.ValueDefinition\" } }, \"array-type\" : { \"type\" : \"string\" }, \"collection-format\" : { \"type\" : \"string\", \"enum\" : [ \"csv\", \"multi\", \"pipes\", \"ssv\", \"tsv\" ] }, \"data-format\" : { \"type\" : \"string\" }, \"data-type\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"example\" : { \"type\" : \"string\" }, \"name\" : { \"type\" : \"string\" } }, \"required\" : [ \"name\" ] }, \"org.apache.camel.model.rest.ResponseMessageDefinition\" : { \"type\" : \"object\", \"properties\" : { \"code\" : { \"type\" : \"string\" }, \"examples\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"header\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ResponseHeaderDefinition\" } }, \"message\" : { \"type\" : \"string\" }, \"response-model\" : { \"type\" : \"string\" } }, \"required\" : [ \"message\" ] }, \"org.apache.camel.model.rest.RestBindingDefinition\" : { \"type\" : \"object\", \"properties\" : { \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"component\" : { \"type\" : \"string\" }, \"consumes\" : { \"type\" : \"string\" }, \"description\" : { \"type\" : \"string\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"id\" : { \"type\" : \"string\" }, \"out-type\" : { \"type\" : \"string\" }, \"produces\" : { \"type\" : \"string\" }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.RestConfigurationDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-component\" : { \"type\" : \"string\", \"enum\" : [ \"openapi\", \"swagger\" ] }, \"api-context-path\" : { \"type\" : \"string\" }, \"api-context-route-id\" : { \"type\" : \"string\" }, \"api-host\" : { \"type\" : \"string\" }, \"api-property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"api-vendor-extension\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"auto\", \"json\", \"json_xml\", \"off\", \"xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"component\" : { \"type\" : \"string\", \"enum\" : [ \"platform-http\", \"servlet\", \"jetty\", \"undertow\", \"netty-http\", \"coap\" ] }, \"component-property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"consumer-property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"context-path\" : { \"type\" : \"string\" }, \"cors-headers\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"data-format-property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"endpoint-property\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestPropertyDefinition\" } }, \"host\" : { \"type\" : \"string\" }, \"host-name-resolver\" : { \"type\" : \"string\", \"enum\" : [ \"allLocalIp\", \"localHostName\", \"localIp\" ] }, \"inline-routes\" : { \"type\" : \"boolean\" }, \"json-data-format\" : { \"type\" : \"string\" }, \"port\" : { \"type\" : \"string\" }, \"producer-api-doc\" : { \"type\" : \"string\" }, \"producer-component\" : { \"type\" : \"string\", \"enum\" : [ \"vertx-http\", \"http\", \"undertow\", \"netty-http\" ] }, \"scheme\" : { \"type\" : \"string\" }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"use-x-forward-headers\" : { \"type\" : \"boolean\" }, \"xml-data-format\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.RestDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-docs\" : { \"type\" : \"boolean\" }, \"binding-mode\" : { \"type\" : \"string\", \"enum\" : [ \"off\", \"auto\", \"json\", \"xml\", \"json_xml\" ] }, \"client-request-validation\" : { \"type\" : \"boolean\" }, \"consumes\" : { \"type\" : \"string\" }, \"delete\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.DeleteDefinition\" } }, \"description\" : { \"type\" : \"string\" }, \"disabled\" : { \"type\" : \"boolean\" }, \"enable-cors\" : { \"type\" : \"boolean\" }, \"get\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.GetDefinition\" } }, \"head\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.HeadDefinition\" } }, \"id\" : { \"type\" : \"string\" }, \"patch\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.PatchDefinition\" } }, \"path\" : { \"type\" : \"string\" }, \"post\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.PostDefinition\" } }, \"produces\" : { \"type\" : \"string\" }, \"put\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.PutDefinition\" } }, \"security-definitions\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestSecuritiesDefinition\" }, \"security-requirements\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.SecurityDefinition\" } }, \"skip-binding-on-error-code\" : { \"type\" : \"boolean\" }, \"tag\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.rest.RestPropertyDefinition\" : { \"type\" : \"object\", \"properties\" : { \"key\" : { \"type\" : \"string\" }, \"value\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\", \"value\" ] }, \"org.apache.camel.model.rest.RestSecuritiesDefinition\" : { \"type\" : \"object\", \"properties\" : { \"api-key\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.ApiKeyDefinition\" }, \"basic-auth\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.BasicAuthDefinition\" }, \"bearer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.BearerTokenDefinition\" }, \"mutual-tls\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.MutualTLSDefinition\" }, \"oauth2\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.OAuth2Definition\" }, \"open-id-connect\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.OpenIdConnectDefinition\" } } }, \"org.apache.camel.model.rest.RestsDefinition\" : { \"type\" : \"object\", \"properties\" : { \"description\" : { \"type\" : \"string\" }, \"id\" : { \"type\" : \"string\" }, \"rest\" : { \"type\" : \"array\", \"items\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestDefinition\" } } } }, \"org.apache.camel.model.rest.SecurityDefinition\" : { \"type\" : \"object\", \"properties\" : { \"key\" : { \"type\" : \"string\" }, \"scopes\" : { \"type\" : \"string\" } }, \"required\" : [ \"key\" ] }, \"org.apache.camel.model.transformer.CustomTransformerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"class-name\" : { \"type\" : \"string\" }, \"from-type\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" }, \"scheme\" : { \"type\" : \"string\" }, \"to-type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.transformer.DataFormatTransformerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"any23\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Any23DataFormat\" }, \"asn1\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ASN1DataFormat\" }, \"avro\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.AvroDataFormat\" }, \"barcode\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BarcodeDataFormat\" }, \"base64\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.Base64DataFormat\" }, \"bindy\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.BindyDataFormat\" }, \"cbor\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CBORDataFormat\" }, \"crypto\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CryptoDataFormat\" }, \"csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CsvDataFormat\" }, \"custom\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.CustomDataFormat\" }, \"fhir-json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirJsonDataFormat\" }, \"fhir-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FhirXmlDataFormat\" }, \"flatpack\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.FlatpackDataFormat\" }, \"from-type\" : { \"type\" : \"string\" }, \"grok\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GrokDataFormat\" }, \"gzip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.GzipDeflaterDataFormat\" }, \"hl7\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.HL7DataFormat\" }, \"ical\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.IcalDataFormat\" }, \"jackson-xml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JacksonXMLDataFormat\" }, \"jaxb\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JaxbDataFormat\" }, \"json\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonDataFormat\" }, \"json-api\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.JsonApiDataFormat\" }, \"lzf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.LZFDataFormat\" }, \"mime-multipart\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.MimeMultipartDataFormat\" }, \"pgp\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.PGPDataFormat\" }, \"protobuf\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ProtobufDataFormat\" }, \"rss\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.RssDataFormat\" }, \"scheme\" : { \"type\" : \"string\" }, \"soap\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SoapDataFormat\" }, \"swift-mt\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMtDataFormat\" }, \"swift-mx\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SwiftMxDataFormat\" }, \"syslog\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.SyslogDataFormat\" }, \"tar-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TarFileDataFormat\" }, \"thrift\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ThriftDataFormat\" }, \"tidy-markup\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.TidyMarkupDataFormat\" }, \"to-type\" : { \"type\" : \"string\" }, \"univocity-csv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityCsvDataFormat\" }, \"univocity-fixed\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityFixedDataFormat\" }, \"univocity-tsv\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.UniVocityTsvDataFormat\" }, \"xml-security\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XMLSecurityDataFormat\" }, \"xstream\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.XStreamDataFormat\" }, \"yaml\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.YAMLDataFormat\" }, \"zip-deflater\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipDeflaterDataFormat\" }, \"zip-file\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.dataformat.ZipFileDataFormat\" } } }, \"org.apache.camel.model.transformer.EndpointTransformerDefinition\" : { \"type\" : \"object\", \"properties\" : { \"from-type\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" }, \"scheme\" : { \"type\" : \"string\" }, \"to-type\" : { \"type\" : \"string\" }, \"uri\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.transformer.TransformersDefinition\" : { \"type\" : \"object\", \"properties\" : { \"custom-transformer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.transformer.CustomTransformerDefinition\" }, \"data-format-transformer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.transformer.DataFormatTransformerDefinition\" }, \"endpoint-transformer\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.transformer.EndpointTransformerDefinition\" } } }, \"org.apache.camel.model.validator.CustomValidatorDefinition\" : { \"type\" : \"object\", \"properties\" : { \"class-name\" : { \"type\" : \"string\" }, \"ref\" : { \"type\" : \"string\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.validator.EndpointValidatorDefinition\" : { \"type\" : \"object\", \"properties\" : { \"ref\" : { \"type\" : \"string\" }, \"type\" : { \"type\" : \"string\" }, \"uri\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.validator.PredicateValidatorDefinition\" : { \"type\" : \"object\", \"properties\" : { \"expression\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.language.ExpressionDefinition\" }, \"type\" : { \"type\" : \"string\" } } }, \"org.apache.camel.model.validator.ValidatorsDefinition\" : { \"type\" : \"object\", \"properties\" : { \"custom-validator\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.validator.CustomValidatorDefinition\" }, \"endpoint-validator\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.validator.EndpointValidatorDefinition\" }, \"predicate-validator\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.validator.PredicateValidatorDefinition\" } } } }, \"properties\" : { \"beans\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.BeansDeserializer\" }, \"error-handler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.ErrorHandlerBuilderDeserializer\" }, \"errorHandler\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.ErrorHandlerBuilderDeserializer\" }, \"from\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.dsl.yaml.deserializers.RouteFromDefinitionDeserializer\" }, \"on-exception\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnExceptionDefinition\" }, \"onException\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.OnExceptionDefinition\" }, \"route-configuration\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteConfigurationDefinition\" }, \"routeConfiguration\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteConfigurationDefinition\" }, \"route\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteDefinition\" }, \"route-template\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteTemplateDefinition\" }, \"routeTemplate\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.RouteTemplateDefinition\" }, \"templated-route\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TemplatedRouteDefinition\" }, \"templatedRoute\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.TemplatedRouteDefinition\" }, \"rest\" : { \"$ref\" : \"#/items/definitions/org.apache.camel.model.rest.RestDefinition\" } } } }"
