import ErrorProcessor from "../utils/tools/ErrorProcessor";
export default class Element {
    constructor(webElement) {
        this.webElement = webElement;
    }
    async dragAndDrop(x, y) {
        return await ErrorProcessor.run(async () => {
            await this.click();
            const actions = this.webElement.getDriver().actions();
            await actions.move({ origin: this.webElement, x, y }).perform();
            return await actions.click().perform();
        }, "Error while drag and drop element to: x=" + x + " y=" + y);
    }
    async sendKeys(keys) {
        return await ErrorProcessor.run(async () => await this.webElement.sendKeys(keys), "Error while sending keys " + keys);
    }
    async getText() {
        return await ErrorProcessor.run(async () => await this.webElement.getText(), "Error while getting text from element.");
    }
    async clickJs() {
        return await ErrorProcessor.run(async () => await this.webElement.getDriver().executeScript("arguments[0].click();", this.webElement), "Error while clicking by JavaScript on element.");
    }
    async click() {
        return await ErrorProcessor.run(async () => await this.webElement.click(), "Error while clicking on element.");
    }
    async offsetClick(x, y) {
        return await ErrorProcessor.run(async () => {
            const actions = this.webElement.getDriver().actions();
            await actions.move({ origin: this.webElement, x, y }).perform();
            return await actions.click().perform();
        }, "Error while clicking on element by offset: x=" + x + " ,y=" + y);
    }
    async offsetMove(x, y) {
        return await ErrorProcessor.run(async () => {
            const actions = this.webElement.getDriver().actions();
            return await actions.move({ origin: this.webElement, x, y }).perform();
        }, "Error while moving from element by offset: x=" + x + " ,y=" + y);
    }
    async scroll() {
        return await ErrorProcessor.run(async () => await this.webElement.getDriver().executeScript("arguments[0].scrollIntoView(true);", this.webElement), "Error while scrolling to element.");
    }
    async getAttribute(attributeName) {
        return await ErrorProcessor.run(async () => await this.webElement.getAttribute(attributeName), "Error while getting attribute: " + attributeName);
    }
    async findElement(by) {
        return await ErrorProcessor.run(async () => new Element(await this.webElement.findElement(by)), "Error while finding element: " + by);
    }
    async findElements(by) {
        return await ErrorProcessor.run(async () => {
            const webElements = await this.webElement.findElements(by);
            return webElements.map((webElement) => new Element(webElement));
        }, "Error while finding elements: " + by);
    }
    async enterFrame() {
        return await ErrorProcessor.run(async () => await this.webElement.getDriver().switchTo().frame(this.webElement), "Error while entering element frame.");
    }
    async markWithRedColor() {
        return await ErrorProcessor.run(async () => await this.webElement
            .getDriver()
            .executeScript("arguments[0].style.backgroundColor = '#ff0000';", this.webElement), "Error while coloring element.");
    }
}
//# sourceMappingURL=Element.js.map