import { jsx as _jsx } from "react/jsx-runtime";
import * as ReactDOM from "react-dom";
import { Main } from "../common/Main";
import { createAndGetMainContainer, openRepoInExternalEditorContainer, openRepoInExternalEditorContainerFromRepositoryHome, removeAllChildren, } from "../../utils";
import { OpenInExternalEditorButton } from "./OpenInExternalEditorButton";
import { GitHubPageType } from "../../github/GitHubPageType";
import { KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS } from "../../constants";
export function renderOpenRepoInExternalEditorApp(args) {
    cleanup(args.id);
    ReactDOM.render(_jsx(Main, { id: args.id, editorEnvelopeLocator: args.editorEnvelopeLocator, dependencies: args.dependencies, logger: args.logger, githubAuthTokenCookieName: args.githubAuthTokenCookieName, extensionIconUrl: args.extensionIconUrl, resourceContentServiceFactory: args.resourceContentServiceFactory, externalEditorManager: args.externalEditorManager, children: ReactDOM.createPortal(_jsx(OpenInExternalEditorButton, { className: args.className, pageType: args.pageType }), GitHubPageType.REPO_HOME === args.pageType || GitHubPageType.CAN_NOT_BE_DETERMINED_FROM_URL === args.pageType
            ? openRepoInExternalEditorContainerFromRepositoryHome(args.id, args.container())
            : openRepoInExternalEditorContainer(args.id, args.container())) }), createAndGetMainContainer(args.id, args.dependencies.all.body()), () => args.logger.log("Mounted."));
}
function cleanup(id) {
    Array.from(document.querySelectorAll(`.${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS}.${id}`)).forEach((e) => {
        removeAllChildren(e);
        e.remove();
    });
}
//# sourceMappingURL=openRepoInExternalEditorApp.js.map