import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState } from "react";
import { Dropdown, DropdownItem, DropdownSeparator, DropdownToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Toolbar, ToolbarGroup, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Avatar } from "@patternfly/react-core/dist/js/components/Avatar";
import accessibleStyles from "@patternfly/react-styles/css/utilities/Accessibility/accessibility";
import { css } from "@patternfly/react-styles";
import AboutModalBox from "../AboutModalBox/AboutModalBox";
import userImage from "../../static/avatar.svg";
import { ANONYMOUS_USER, supportsLogout, useKogitoAppContext, } from "../../contexts/KogitoAppContext";
import { componentOuiaProps } from "../../ouiaTools";
const PageToolbar = ({ ouiaId, ouiaSafe }) => {
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    const [modalToggle, setmodalToggle] = useState(false);
    const context = useKogitoAppContext();
    const handleAboutModalToggle = () => {
        setmodalToggle(!modalToggle);
    };
    const onDropdownToggle = (_isDropdownOpen) => {
        setDropdownOpen(_isDropdownOpen);
    };
    const onDropdownSelect = () => {
        setDropdownOpen(!isDropdownOpen);
    };
    const getUserName = () => {
        if (context) {
            if (context.getCurrentUser() === ANONYMOUS_USER) {
                return "Anonymous";
            }
            return context.getCurrentUser().id;
        }
        return "Anonymous";
    };
    const handleLogout = () => {
        if (supportsLogout(context.userContext)) {
            const logout = context.userContext;
            logout.logout();
        }
    };
    const userDropdownItems = [];
    userDropdownItems.push(_jsx(DropdownItem, { onClick: handleAboutModalToggle, children: "About" }, userDropdownItems.length));
    if (supportsLogout(context.userContext)) {
        userDropdownItems.push(_jsx(DropdownSeparator, {}, userDropdownItems.length));
        userDropdownItems.push(_jsx(DropdownItem, { onClick: handleLogout, children: "Log out" }, userDropdownItems.length));
    }
    return (_jsxs(React.Fragment, { children: [_jsx(AboutModalBox, { isOpenProp: modalToggle, handleModalToggleProp: handleAboutModalToggle }), _jsx(Toolbar, { ...componentOuiaProps(ouiaId, "page-toolbar", ouiaSafe), children: _jsx(ToolbarGroup, { alignment: { default: "alignRight" }, children: _jsx(ToolbarItem, { className: css(accessibleStyles.screenReader, accessibleStyles.visibleOnMd), children: _jsx(Dropdown, { isPlain: true, position: "right", onSelect: onDropdownSelect, isOpen: isDropdownOpen, toggle: _jsx(DropdownToggle, { onToggle: onDropdownToggle, icon: _jsx(Avatar, { src: userImage, alt: "User Avatar" }), children: getUserName() }), dropdownItems: userDropdownItems, "data-testid": "pageToolbar-dropdown" }) }) }) })] }));
};
export default PageToolbar;
//# sourceMappingURL=PageToolbar.js.map