import { Wrapped } from "@kie-tools-core/i18n/dist/core";
import { FormI18n } from "@kie-tools/form/dist/i18n/FormI18n";
export interface FormDmnI18n extends FormI18n {
    validation: {
        xDmnAllowedValues: string;
        xDmnTypeConstraint: string;
        daysAndTimeError: string;
        yearsAndMonthsError: string;
    };
    dmnSchema: {
        daysAndTimePlaceholder: string;
        yearsAndMonthsPlaceholder: string;
    };
    result: {
        evaluation: {
            succeeded: string;
            skipped: string;
            failed: string;
        };
        error: {
            title: string;
            explanation: string;
            message: Array<string | Wrapped<"jira">>;
        };
        dateTooltip: Array<string | Wrapped<"date">>;
        withoutResponse: {
            title: string;
            explanation: string;
        };
    };
}
//# sourceMappingURL=FormDmnI18n.d.ts.map