import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { ModelTitle } from "../atoms";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import DataDictionaryHandler from "../../DataDictionary/DataDictionaryHandler/DataDictionaryHandler";
import { OutputsHandler } from "../../Outputs/organisms";
import MiningSchemaHandler from "../../MiningSchema/MiningSchemaHandler/MiningSchemaHandler";
import "./EditorHeader.scss";
const isEditor = (props) => {
    return props.modelIndex !== undefined;
};
export const EditorHeader = (props) => {
    const { modelName, modelIndex } = props;
    if (isEditor(props)) {
        const { miningSchema, output, validateOutputFieldName, deleteOutputField, commitOutputField, commitModelName } = props;
        return (_jsxs(Split, { hasGutter: true, className: "editorHeader", children: [_jsx(SplitItem, { className: "editorHeader__modelName", children: _jsx(ModelTitle, { modelName: modelName, commitModelName: commitModelName }) }), _jsx(SplitItem, { isFilled: true, "data-ouia-component-type": "filler" }), _jsx(SplitItem, { children: _jsx(DataDictionaryHandler, {}) }), _jsx(SplitItem, { children: _jsx(MiningSchemaHandler, { miningSchema: miningSchema, modelIndex: modelIndex }) }), _jsx(SplitItem, { children: _jsx(OutputsHandler, { modelIndex: modelIndex, output: output, miningSchema: miningSchema, validateOutputFieldName: validateOutputFieldName, deleteOutputField: deleteOutputField, commitOutputField: commitOutputField }) })] }));
    }
    else {
        return (_jsx(Split, { hasGutter: true, className: "editorHeader", children: _jsx(SplitItem, { isFilled: true, className: "editorHeader--modelName", children: _jsx(ModelTitle, { modelName: modelName }) }) }));
    }
};
//# sourceMappingURL=EditorHeader.js.map