import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { OutputFieldRowAction, OutputLabels } from "../atoms";
import "./OutputFieldRow.scss";
import { ValidationIndicator } from "../../EditorCore/atoms";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
const OutputFieldRow = (props) => {
    const { modelIndex, outputFieldIndex, outputField, onEditOutputField, onDeleteOutputField } = props;
    const { name, dataType, optype, targetField, feature, value, rank, rankOrder, segmentId, isFinalResult } = useMemo(() => {
        return {
            name: outputField === null || outputField === void 0 ? void 0 : outputField.name,
            dataType: outputField === null || outputField === void 0 ? void 0 : outputField.dataType,
            optype: outputField === null || outputField === void 0 ? void 0 : outputField.optype,
            targetField: outputField === null || outputField === void 0 ? void 0 : outputField.targetField,
            feature: outputField === null || outputField === void 0 ? void 0 : outputField.feature,
            value: outputField === null || outputField === void 0 ? void 0 : outputField.value,
            rank: outputField === null || outputField === void 0 ? void 0 : outputField.rank,
            rankOrder: outputField === null || outputField === void 0 ? void 0 : outputField.rankOrder,
            segmentId: outputField === null || outputField === void 0 ? void 0 : outputField.segmentId,
            isFinalResult: outputField === null || outputField === void 0 ? void 0 : outputField.isFinalResult,
        };
    }, [outputField]);
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).build()), [outputFieldIndex, modelIndex, outputField]);
    const targetFieldValidation = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build()), [outputFieldIndex, modelIndex, outputField]);
    const handleEdit = (event) => {
        event.preventDefault();
        event.stopPropagation();
        onEditOutputField();
    };
    return (_jsx("section", { id: `output-field-n${outputFieldIndex}`, "data-testid": `output-field-n${outputFieldIndex}`, className: "editable-item__inner", onClick: (event) => handleEdit(event), onKeyDown: (event) => {
            if (event.key === "Enter") {
                handleEdit(event);
            }
        }, "data-ouia-component-type": "output-field", tabIndex: 0, children: _jsxs(Split, { hasGutter: true, style: { height: "100%" }, children: [_jsx(SplitItem, { children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" }, children: _jsx(FlexItem, { children: _jsx(ValidationIndicator, { validations: validations }) }) }) }), _jsx(SplitItem, { "data-ouia-component-type": "output-field-name", children: _jsx("strong", { children: name }) }), _jsxs(SplitItem, { isFilled: true, children: [_jsx(Label, { color: "blue", className: "output-item__type-label", children: dataType }), _jsx(OutputLabels, { optype: optype, targetField: targetField, targetFieldValidation: targetFieldValidation, feature: feature, value: value, rank: rank, rankOrder: rankOrder, segmentId: segmentId, isFinalResult: isFinalResult })] }), _jsx(SplitItem, { children: _jsx(OutputFieldRowAction, { index: outputFieldIndex, onDelete: onDeleteOutputField, "data-ouia-component-type": "output-field-delete" }) })] }) }));
};
export default OutputFieldRow;
//# sourceMappingURL=OutputFieldRow.js.map