import { ValidationLevel } from "./ValidationLevel";
export const toNotifications = (normalizedPosixPathRelativeToTheWorkspaceRoot, validationEntries) => {
    const mapValidationLevel = (level) => {
        switch (level) {
            case ValidationLevel.ERROR:
                return "ERROR";
            case ValidationLevel.WARNING:
                return "WARNING";
        }
    };
    return validationEntries.map((validationEntry) => {
        var _a;
        return {
            normalizedPosixPathRelativeToTheWorkspaceRoot,
            message: (_a = validationEntry.message) !== null && _a !== void 0 ? _a : "",
            type: "PROBLEM",
            severity: mapValidationLevel(validationEntry.level),
        };
    });
};
//# sourceMappingURL=NotificationsFactory.js.map