import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import CustomDashboardListToolbar from "../CustomDashboardListToolbar/CustomDashboardListToolbar";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import CustomDashboardsTable from "../CustomDashboardsTable/CustomDashboardsTable";
import CustomDashboardsGallery from "../CustomDashboardsGallery/CustomDashboardsGallery";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
const CustomDashboardList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [filterNames, setFilterNames] = useState([]);
    const [dashboardData, setDashboardData] = useState([]);
    const [isSelected] = useState({
        tableView: true,
        cardsView: false,
    });
    const [isLoading, setIsLoading] = useState(true);
    const [error, setError] = useState(null);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
    }, [isEnvelopeConnectedToChannel]);
    const init = async () => {
        try {
            const namesFilter = await driver.getCustomDashboardFilter();
            setFilterNames(namesFilter.customDashboardNames);
            setIsLoading(true);
            const response = await driver.getCustomDashboardsQuery();
            setDashboardData(response);
            setIsLoading(false);
        }
        catch (errorResponse) {
            setError(errorResponse);
        }
    };
    const applyFilter = (filters) => {
        driver.applyFilter(filters);
        init();
    };
    if (error) {
        return _jsx(ServerErrors, { error: error.message, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "custom-dashboard-list", ouiaSafe), children: [_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(CustomDashboardListToolbar, { applyFilter: applyFilter, setFilterDashboardNames: setFilterNames, filterDashboardNames: filterNames }) }), _jsx(SplitItem, { isFilled: true })] }), _jsx(Divider, {}), isSelected.tableView ? (_jsx(CustomDashboardsTable, { driver: driver, customDashboardData: dashboardData, setDashboardsData: setDashboardData, isLoading: isLoading })) : (_jsx(CustomDashboardsGallery, { customDashboardsDatas: dashboardData, driver: driver, isLoading: isLoading }))] }));
};
export default CustomDashboardList;
//# sourceMappingURL=CustomDashboardList.js.map