import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { WorkflowFormContext } from "./WorkflowFormContext";
import { WorkflowFormGatewayApiImpl } from "./WorkflowFormGatewayApi";
export function WorkflowFormContextProvider(props) {
    const { proxyEndpoint } = props;
    const gatewayApiImpl = useMemo(() => {
        return new WorkflowFormGatewayApiImpl("q/openapi.json", proxyEndpoint);
    }, [proxyEndpoint]);
    return _jsx(WorkflowFormContext.Provider, { value: gatewayApiImpl, children: props.children });
}
export default WorkflowFormContextProvider;
//# sourceMappingURL=WorkflowFormContextProvider.js.map