import "@patternfly/react-core/dist/styles/base.css";
import * as React from "react";
import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { SceSimModel } from "@kie-tools/scesim-marshaller";
import { SceSim__FactMappingType } from "@kie-tools/scesim-marshaller/dist/schemas/scesim-1_8/ts-gen/types";
import { Commands } from "./commands/CommandsContextProvider";
import "./TestScenarioEditor.css";
export type OnRequestExternalModelsAvailableToInclude = () => Promise<string[]>;
export type OnRequestToJumpToPath = (normalizedPosixPathRelativeToTheOpenFile: string) => void;
export type OnRequestToResolvePath = (normalizedPosixPathRelativeToTheOpenFile: string) => string;
export type OnSceSimModelChange = (model: SceSimModel) => void;
export type OnRequestExternalModelByPath = (normalizedPosixPathRelativeToTheOpenFile: string) => Promise<ExternalDmn | null>;
export type ExternalDmnsIndex = Map<string, ExternalDmn | undefined>;
export type ExternalDmn = {
    model: Normalized<DmnLatestModel>;
    normalizedPosixPathRelativeToTheOpenFile: string;
    svg: string;
};
export type TestScenarioEditorProps = {
    externalModelsByNamespace?: ExternalDmnsIndex;
    issueTrackerHref?: string;
    model: SceSimModel;
    onModelChange?: OnSceSimModelChange;
    onModelDebounceStateChanged?: (changed: boolean) => void;
    onRequestExternalModelByPath?: OnRequestExternalModelByPath;
    onRequestExternalModelsAvailableToInclude?: OnRequestExternalModelsAvailableToInclude;
    onRequestToJumpToPath?: OnRequestToJumpToPath;
    onRequestToResolvePath?: OnRequestToResolvePath;
    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: string | undefined;
};
export type TestScenarioEditorRef = {
    reset: (mode: SceSimModel) => void;
    getCommands: () => Commands;
    getDiagramSvg: () => Promise<string | undefined>;
};
export type TestScenarioSelectedColumnMetaData = {
    factMapping: SceSim__FactMappingType;
    index: number;
    isBackground: boolean;
};
export declare const TestScenarioEditorInternal: ({ forwardRef, model, onModelChange, onModelDebounceStateChanged, }: TestScenarioEditorProps & {
    forwardRef?: React.Ref<TestScenarioEditorRef>;
}) => JSX.Element;
export declare const TestScenarioEditor: React.ForwardRefExoticComponent<TestScenarioEditorProps & React.RefAttributes<TestScenarioEditorRef>>;
//# sourceMappingURL=TestScenarioEditor.d.ts.map