import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import "./styles.css";
import { CloudEventFormEnvelopeView } from "./CloudEventFormEnvelopeView";
import { CloudEventFormEnvelopeApiImpl } from "./CloudEventFormEnvelopeApiImpl";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-cloud-event-form-container";
            ReactDOM.render(_jsx(CloudEventFormEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    return envelope.start(envelopeViewDelegate, undefined, {
        create: (apiFactoryArgs) => new CloudEventFormEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=CloudEventFormEnvelope.js.map