import { ContentTypes, HeaderKeys } from "./FetchConstants";
export class ResourceFetcher {
    constructor(args) {
        this.args = args;
    }
    async execute(args) {
        var _a;
        const targetUrl = `${this.args.connection.host}${args.target.endpoint()}`;
        const urlToFetch = (_a = this.args.proxyUrl) !== null && _a !== void 0 ? _a : targetUrl;
        const headers = {
            [HeaderKeys.AUTHORIZATION]: `Bearer ${this.args.connection.token}`,
            [HeaderKeys.ACCEPT]: ContentTypes.APPLICATION_JSON,
            [HeaderKeys.CONTENT_TYPE]: args.target.contentType(),
        };
        if (this.args.proxyUrl) {
            headers[HeaderKeys.TARGET_URL] = targetUrl;
            if (this.args.connection.insecurelyDisableTlsCertificateValidation) {
                headers[HeaderKeys.INSECURELY_DISABLE_TLS_CERTIFICATE_VALIDATION] = "true";
            }
        }
        let error;
        try {
            const response = await fetch(urlToFetch, {
                method: args.target.method(),
                body: args.target.body(),
                headers,
            });
            if (response.ok) {
                return (await response.json());
            }
            else {
                error = {
                    status: response.status,
                    statusText: response.statusText,
                };
            }
        }
        catch (e) {
        }
        if (args.rollbacks && args.rollbacks.length > 0) {
            for (const resource of args.rollbacks) {
                await this.execute({ target: resource });
            }
        }
        throw new Error(`Error fetching ${args.target.name()}`, { cause: error });
    }
}
//# sourceMappingURL=ResourceFetcher.js.map