/*
 * Decompiled with CFR 0.152.
 */
package run.mone.docean.plugin.k8s;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.common.Pair;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mone.docean.plugin.k8s.Crd;

@DOceanPlugin
public class K8sPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(K8sPlugin.class);
    private KubernetesClient client;
    private static final KubernetesClient DEFAULT_CLIENT = new DefaultKubernetesClient();
    private List<Crd> crdList = new ArrayList<Crd>();
    private Map<String, Class> rdMap = new HashMap<String, Class>();
    private Map<String, Pair<Class, Class>> clientMap = new HashMap<String, Pair<Class, Class>>();

    public K8sPlugin() {
        this.clientMap.put("podClient", (Pair<Class, Class>)new Pair(Pod.class, PodList.class));
        this.clientMap.put("nodeClient", (Pair<Class, Class>)new Pair(Node.class, NodeList.class));
        this.clientMap.put("deploymentClient", (Pair<Class, Class>)new Pair(Deployment.class, DeploymentList.class));
        this.clientMap.put("serviceClient", (Pair<Class, Class>)new Pair(Service.class, ServiceList.class));
        this.clientMap.put("configMapClient", (Pair<Class, Class>)new Pair(ConfigMap.class, ConfigMapList.class));
        this.clientMap.put("jobClient", (Pair<Class, Class>)new Pair(Job.class, JobList.class));
        this.clientMap.put("nsClient", (Pair<Class, Class>)new Pair(Namespace.class, NamespaceList.class));
        this.clientMap.put("pvClient", (Pair<Class, Class>)new Pair(PersistentVolume.class, PersistentVolumeList.class));
        this.clientMap.put("HPAClient", (Pair<Class, Class>)new Pair(HorizontalPodAutoscaler.class, HorizontalPodAutoscalerList.class));
        this.clientMap.put("replicasetClient", (Pair<Class, Class>)new Pair(ReplicaSet.class, ReplicaSetList.class));
        this.rdMap.put("nodeResourceEventHandler", Node.class);
        this.rdMap.put("deploymentResourceEventHandler", Deployment.class);
        this.rdMap.put("serviceResourceEventHandler", Service.class);
        this.rdMap.put("podResourceEventHandler", Pod.class);
        this.rdMap.put("nsResourceEventHandler", Namespace.class);
        this.rdMap.put("jobResourceEventHandler", Job.class);
        this.rdMap.put("HPAResourceEventHandler", HorizontalPodAutoscaler.class);
        this.rdMap.put("replicasetResourceEventHandler", ReplicaSet.class);
    }

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init k8s plugin");
        this.client = new DefaultKubernetesClient();
        ioc.putBean(KubernetesClient.class.getName(), (Object)this.client);
        Config config = (Config)ioc.getBean(Config.class);
        String customResourceStr = config.get("crd", "");
        if (StringUtils.isNotEmpty((String)customResourceStr)) {
            this.crdList = Arrays.stream(customResourceStr.split(";")).map(it -> {
                String[] array = it.split(":");
                Crd crd = new Crd();
                crd.setCrdName(array[0]);
                crd.setResourceType(array[1]);
                crd.setListClass(array[2]);
                crd.setClientName(array[3]);
                crd.setHandlerName(array[4]);
                return crd;
            }).collect(Collectors.toList());
            this.crdList.stream().forEach(it -> {
                MixedOperation moneClient = this.client.resources(ReflectUtils.classForName((String)it.getResourceType()), ReflectUtils.classForName((String)it.getListClass()));
                ioc.putBean(it.getClientName(), (Object)moneClient);
            });
        }
        this.clientMap.entrySet().forEach(entry -> {
            MixedOperation c = this.client.resources((Class)((Pair)entry.getValue()).getKey(), (Class)((Pair)entry.getValue()).getValue());
            ioc.putBean((String)entry.getKey(), (Object)c);
        });
    }

    public boolean start(Ioc ioc) {
        SharedInformerFactory informerFactory = this.client.informers();
        this.rdMap.entrySet().forEach(entry -> {
            ResourceEventHandler nodeResourceEventHandler = (ResourceEventHandler)ioc.getBean((String)entry.getKey(), null);
            Optional.ofNullable(nodeResourceEventHandler).ifPresent(it -> {
                SharedIndexInformer sharedIndexInformer = informerFactory.sharedIndexInformerFor((Class)entry.getValue(), TimeUnit.MINUTES.toMillis(10L));
                sharedIndexInformer.addEventHandler(it);
            });
        });
        this.crdList.stream().forEach(crd -> {
            ResourceEventHandler handler = (ResourceEventHandler)ioc.getBean(crd.getHandlerName(), null);
            Optional.ofNullable(handler).ifPresent(it -> {
                SharedIndexInformer sharedIndexInformer = informerFactory.sharedIndexInformerFor(ReflectUtils.classForName((String)crd.getResourceType()), TimeUnit.MINUTES.toMillis(10L));
                sharedIndexInformer.addEventHandler(it);
            });
        });
        Future startedInformersFuture = informerFactory.startAllRegisteredInformers();
        startedInformersFuture.get();
        informerFactory.addSharedInformerEventListener(exception -> log.info("Exception occurred, but caught", (Throwable)exception));
        return true;
    }

    private static Pair<Integer, String> execContainer(KubernetesClient client, String ns, String name, String container, String[] command) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try (ExecWatch execWatch = (ExecWatch)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(ns)).withName(name)).inContainer((Object)container)).writingOutput((Object)out)).writingError((Object)error)).exec((Object[])command);){
            execWatch.close();
        }
        String result = out.toString();
        System.out.println("result:" + result);
        return Pair.of((Object)0, (Object)result);
    }

    public static Pair<Integer, String> KillContainer(String ns, String name, String container) {
        String[] shs = new String[]{"bash", "ash", "sh"};
        Pair<Integer, String> end = null;
        for (String sh : shs) {
            end = K8sPlugin.execContainer(DEFAULT_CLIENT, ns, name, container, new String[]{sh, "-c", "trap \"exit\" SIGINT SIGTERM ; kill -s SIGINT 1"});
            if (((Integer)end.getKey()).equals(0)) break;
        }
        return end;
    }
}

