/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.project.group;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupAppRequest;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupDataRequest;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupModel;
import org.apache.ozhera.app.api.model.project.group.ProjectGroupTreeNode;
import org.apache.ozhera.app.api.service.HeraAuthorizationApi;
import org.apache.ozhera.app.api.service.HeraProjectGroupServiceApi;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.model.AppMonitorModel;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.project.group.ProjectGroupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProjectGroupService {
    private static final Logger log = LoggerFactory.getLogger(ProjectGroupService.class);
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=HeraProjectGroupServiceApi.class, group="${dubbo.group.heraapp}", timeout=3000)
    HeraProjectGroupServiceApi projectGroupServiceApi;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=HeraAuthorizationApi.class, group="${dubbo.group.heraapp}", timeout=3000)
    HeraAuthorizationApi heraAuthorizationApi;
    @Autowired
    AppMonitorService appMonitorService;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;

    public Result checkAuthorization(HttpServletRequest request) {
        String heraToken = request.getHeader("hera-token");
        log.info("checkAuthorization header hera-token:{}", (Object)heraToken);
        return this.heraAuthorizationApi.checkAuthorization(heraToken);
    }

    public Result<ProjectGroupTreeNode> getFullTree(Integer type) {
        return this.projectGroupServiceApi.getFullTree(type);
    }

    public Result<ProjectGroupTreeNode> getTreeByUser(ProjectGroupRequest request) {
        return this.projectGroupServiceApi.getTreeByUser(request.getUser(), request.getGroupType(), request.getProjectGroupName(), request.getLevel());
    }

    public Result<List<HeraAppBaseInfoModel>> searchGroupApps(ProjectGroupRequest request) {
        return this.projectGroupServiceApi.searchGroupApps(request.getUser(), request.getGroupType(), request.getProjectGroupId(), request.getAppName(), request.getPage(), request.getPageSize());
    }

    public Result<List<HeraProjectGroupModel>> searchChildGroups(ProjectGroupRequest request) {
        return this.projectGroupServiceApi.searchChildGroups(request.getUser(), request.getGroupType(), request.getProjectGroupId(), request.getPage(), request.getPageSize());
    }

    public Result searchMyApps(ProjectGroupRequest request) {
        Result listResult = this.projectGroupServiceApi.searchGroupApps(request.getUser(), request.getGroupType(), request.getProjectGroupId(), request.getAppName(), request.getPage(), request.getPageSize());
        if (!listResult.isSuccess()) {
            return listResult;
        }
        PageData<List<AppMonitor>> pd = new PageData<List<AppMonitor>>();
        if (CollectionUtils.isEmpty((Collection)((Collection)listResult.getData()))) {
            pd.setTotal(0L);
            pd.setList(null);
            return Result.success(pd);
        }
        List data = (List)listResult.getData();
        List<Integer> baseIds = data.stream().map(t -> t.getId()).collect(Collectors.toList());
        log.info("baseIds : {}", (Object)new Gson().toJson(baseIds));
        Long aLong = this.appMonitorService.countByBaseInfoId(baseIds, request.getUser());
        pd.setTotal(aLong);
        if (aLong.intValue() > 0) {
            List<AppMonitor> appMonitors = this.appMonitorService.searchByBaseInfoId(baseIds, request.getUser(), 1, 1000);
            pd.setList(appMonitors);
            pd.setPage(1);
            pd.setPageSize(1000);
        }
        return Result.success(pd);
    }

    public Result<Integer> create(HeraProjectGroupDataRequest request) {
        Result result = this.projectGroupServiceApi.create(request);
        if (result.isSuccess()) {
            this.appData(request.getUsers(), request.getApps());
        }
        return result;
    }

    public Result<Integer> update(HeraProjectGroupDataRequest request) {
        Result update = this.projectGroupServiceApi.update(request);
        if (update.isSuccess()) {
            this.appData(request.getUsers(), request.getApps());
        }
        return update;
    }

    public Result<Integer> delete(Integer id) {
        return this.projectGroupServiceApi.delete(id);
    }

    private void appData(List<String> users, List<HeraProjectGroupAppRequest> apps) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        if (CollectionUtils.isEmpty(apps)) {
            return;
        }
        for (HeraProjectGroupAppRequest app : apps) {
            HeraAppBaseInfoModel appBaseInfo = this.heraBaseInfoService.getByBindIdAndPlat(String.valueOf(app.getAppId()), app.getPlatFormType());
            if (appBaseInfo == null) {
                log.info("create or update appData no Data found! appId:{}, plat:{}", (Object)app.getAppId(), (Object)app.getPlatFormType());
                continue;
            }
            for (String user : users) {
                AppMonitorModel appMonitorModel = new AppMonitorModel();
                appMonitorModel.setProjectId(Integer.valueOf(appBaseInfo.getBindId()));
                appMonitorModel.setProjectName(appBaseInfo.getAppName());
                appMonitorModel.setProjectCName(appBaseInfo.getAppCname());
                appMonitorModel.setOwner("yes");
                appMonitorModel.setIamTreeId(appBaseInfo.getIamTreeId());
                appMonitorModel.setAppSource(appBaseInfo.getPlatformType());
                appMonitorModel.setBindType(appBaseInfo.getBindType());
                appMonitorModel.setAppLanguage(appBaseInfo.getAppLanguage());
                appMonitorModel.setAppType(appBaseInfo.getAppType());
                appMonitorModel.setEnvMapping(appBaseInfo.getEnvsMap());
                org.apache.ozhera.monitor.result.Result<String> result = this.appMonitorService.createWithBaseInfo(appMonitorModel, user);
                log.info("appData.addApp param : {} ,user : {} , result : {}", new Object[]{appMonitorModel, user, result});
            }
        }
    }
}

