/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

abstract class FieldWriterInt64<T>
extends FieldWriter<T> {
    volatile byte[][] utf8ValueCache;
    volatile char[][] utf16ValueCache;
    final boolean browserCompatible;

    FieldWriterInt64(String name, int ordinal, long features, String format, String label, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldClass, fieldClass, field, method);
        this.browserCompatible = (features & JSONWriter.Feature.BrowserCompatible.mask) != 0L;
    }

    @Override
    public final void writeInt64(JSONWriter jsonWriter, long value) {
        boolean writeAsString;
        long features = jsonWriter.getFeatures() | this.features;
        boolean bl = writeAsString = (features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L;
        if (jsonWriter.utf8 && !writeAsString) {
            if (value >= -1L && value < 1039L) {
                byte[] bytes = null;
                if (this.utf8ValueCache == null) {
                    this.utf8ValueCache = new byte[1040][];
                } else {
                    bytes = this.utf8ValueCache[(int)value + 1];
                }
                if (bytes == null) {
                    int size = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                    byte[] original = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(value, bytes.length, bytes);
                    this.utf8ValueCache[(int)value + 1] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
        } else if (jsonWriter.utf16 && !writeAsString && value >= -1L && value < 1039L) {
            char[] chars = null;
            if (this.utf16ValueCache == null) {
                this.utf16ValueCache = new char[1040][];
            } else {
                chars = this.utf16ValueCache[(int)value + 1];
            }
            if (chars == null) {
                int size = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                char[] original = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + size);
                chars = Arrays.copyOf(original, original.length);
                IOUtils.getChars(value, chars.length, chars);
                this.utf16ValueCache[(int)value + 1] = chars;
            }
            jsonWriter.writeNameRaw(chars);
            return;
        }
        this.writeFieldName(jsonWriter);
        if (!writeAsString) {
            boolean bl2 = writeAsString = this.browserCompatible && !jsonWriter.jsonb && (value > 0x1FFFFFFFFFFFFFL || value < -9007199254740991L);
        }
        if (writeAsString) {
            jsonWriter.writeString(Long.toString(value));
        } else {
            jsonWriter.writeInt64(value);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Long value;
        try {
            value = (Long)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNumberNull();
            return true;
        }
        this.writeInt64(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Long value = (Long)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeInt64(value);
    }
}

