/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.function.ToByteFunction;
import com.alibaba.fastjson2.function.ToCharFunction;
import com.alibaba.fastjson2.function.ToFloatFunction;
import com.alibaba.fastjson2.function.ToShortFunction;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterBigDecimalField;
import com.alibaba.fastjson2.writer.FieldWriterBigDecimalFunc;
import com.alibaba.fastjson2.writer.FieldWriterBigDecimalMethod;
import com.alibaba.fastjson2.writer.FieldWriterBigIntField;
import com.alibaba.fastjson2.writer.FieldWriterBigIntFunc;
import com.alibaba.fastjson2.writer.FieldWriterBoolMethod;
import com.alibaba.fastjson2.writer.FieldWriterBoolValField;
import com.alibaba.fastjson2.writer.FieldWriterBoolValFunc;
import com.alibaba.fastjson2.writer.FieldWriterBooleanFunc;
import com.alibaba.fastjson2.writer.FieldWriterCalendarFunc;
import com.alibaba.fastjson2.writer.FieldWriterCharMethod;
import com.alibaba.fastjson2.writer.FieldWriterCharValField;
import com.alibaba.fastjson2.writer.FieldWriterCharValFunc;
import com.alibaba.fastjson2.writer.FieldWriterDateField;
import com.alibaba.fastjson2.writer.FieldWriterDateFunc;
import com.alibaba.fastjson2.writer.FieldWriterDateMethod;
import com.alibaba.fastjson2.writer.FieldWriterDoubleField;
import com.alibaba.fastjson2.writer.FieldWriterDoubleFunc;
import com.alibaba.fastjson2.writer.FieldWriterDoubleMethod;
import com.alibaba.fastjson2.writer.FieldWriterDoubleValField;
import com.alibaba.fastjson2.writer.FieldWriterDoubleValueFunc;
import com.alibaba.fastjson2.writer.FieldWriterEnum;
import com.alibaba.fastjson2.writer.FieldWriterEnumFunc;
import com.alibaba.fastjson2.writer.FieldWriterEnumMethod;
import com.alibaba.fastjson2.writer.FieldWriterFloatField;
import com.alibaba.fastjson2.writer.FieldWriterFloatFunc;
import com.alibaba.fastjson2.writer.FieldWriterFloatMethod;
import com.alibaba.fastjson2.writer.FieldWriterFloatValField;
import com.alibaba.fastjson2.writer.FieldWriterFloatValueFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt16Func;
import com.alibaba.fastjson2.writer.FieldWriterInt16Method;
import com.alibaba.fastjson2.writer.FieldWriterInt16ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt16ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt32Func;
import com.alibaba.fastjson2.writer.FieldWriterInt32Method;
import com.alibaba.fastjson2.writer.FieldWriterInt32Val;
import com.alibaba.fastjson2.writer.FieldWriterInt32ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt64Func;
import com.alibaba.fastjson2.writer.FieldWriterInt64Method;
import com.alibaba.fastjson2.writer.FieldWriterInt64ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt64ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt8Func;
import com.alibaba.fastjson2.writer.FieldWriterInt8Method;
import com.alibaba.fastjson2.writer.FieldWriterInt8ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt8ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterListField;
import com.alibaba.fastjson2.writer.FieldWriterListFunc;
import com.alibaba.fastjson2.writer.FieldWriterListMethod;
import com.alibaba.fastjson2.writer.FieldWriterListStrFunc;
import com.alibaba.fastjson2.writer.FieldWriterMillisField;
import com.alibaba.fastjson2.writer.FieldWriterMillisFunc;
import com.alibaba.fastjson2.writer.FieldWriterMillisMethod;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayField;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayMethod;
import com.alibaba.fastjson2.writer.FieldWriterObjectFunc;
import com.alibaba.fastjson2.writer.FieldWriterObjectFuncFinal;
import com.alibaba.fastjson2.writer.FieldWriterObjectMethod;
import com.alibaba.fastjson2.writer.FieldWriterStringField;
import com.alibaba.fastjson2.writer.FieldWriterStringFunc;
import com.alibaba.fastjson2.writer.FieldWriterStringMethod;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriter1;
import com.alibaba.fastjson2.writer.ObjectWriter10;
import com.alibaba.fastjson2.writer.ObjectWriter11;
import com.alibaba.fastjson2.writer.ObjectWriter12;
import com.alibaba.fastjson2.writer.ObjectWriter2;
import com.alibaba.fastjson2.writer.ObjectWriter3;
import com.alibaba.fastjson2.writer.ObjectWriter4;
import com.alibaba.fastjson2.writer.ObjectWriter5;
import com.alibaba.fastjson2.writer.ObjectWriter6;
import com.alibaba.fastjson2.writer.ObjectWriter7;
import com.alibaba.fastjson2.writer.ObjectWriter8;
import com.alibaba.fastjson2.writer.ObjectWriter9;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterException;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.alibaba.fastjson2.writer.ObjectWriters;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class ObjectWriterCreator {
    public static final ObjectWriterCreator INSTANCE = new ObjectWriterCreator();
    static Map<Class, LambdaInfo> lambdaMapping = new HashMap<Class, LambdaInfo>();
    protected AtomicInteger jitErrorCount = new AtomicInteger();
    protected volatile Throwable jitErrorLast;

    public ObjectWriter createObjectWriter(List<FieldWriter> fieldWriters) {
        return new ObjectWriterAdapter(null, null, null, 0L, fieldWriters);
    }

    public ObjectWriter createObjectWriter(FieldWriter ... fieldWriters) {
        return new ObjectWriterAdapter(null, null, null, 0L, Arrays.asList(fieldWriters));
    }

    public ObjectWriter createObjectWriter(Class objectType) {
        return this.createObjectWriter(objectType, 0L, JSONFactory.getDefaultObjectWriterProvider());
    }

    public ObjectWriter createObjectWriter(Class objectType, FieldWriter ... fieldWriters) {
        return this.createObjectWriter(objectType, 0L, fieldWriters);
    }

    public ObjectWriter createObjectWriter(Class objectClass, long features, FieldWriter ... fieldWriters) {
        if (fieldWriters.length == 0) {
            return this.createObjectWriter(objectClass, features, JSONFactory.getDefaultObjectWriterProvider());
        }
        boolean googleCollection = false;
        if (objectClass != null) {
            String typeName = objectClass.getName();
            boolean bl = googleCollection = "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList".equals(typeName) || "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet".equals(typeName);
        }
        if (!googleCollection) {
            switch (fieldWriters.length) {
                case 1: {
                    if ((fieldWriters[0].features & 0x1000000000000L) == 0L) {
                        return new ObjectWriter1(objectClass, null, null, features, Arrays.asList(fieldWriters));
                    }
                    return new ObjectWriterAdapter(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 2: {
                    return new ObjectWriter2(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 3: {
                    return new ObjectWriter3(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 4: {
                    return new ObjectWriter4(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 5: {
                    return new ObjectWriter5(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 6: {
                    return new ObjectWriter6(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 7: {
                    return new ObjectWriter7(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 8: {
                    return new ObjectWriter8(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 9: {
                    return new ObjectWriter9(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 10: {
                    return new ObjectWriter10(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 11: {
                    return new ObjectWriter11(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
                case 12: {
                    return new ObjectWriter12(objectClass, null, null, features, Arrays.asList(fieldWriters));
                }
            }
            return new ObjectWriterAdapter(objectClass, null, null, features, Arrays.asList(fieldWriters));
        }
        return new ObjectWriterAdapter(objectClass, null, null, features, Arrays.asList(fieldWriters));
    }

    protected FieldWriter creteFieldWriter(Class objectClass, long writerFeatures, ObjectWriterProvider provider, BeanInfo beanInfo, FieldInfo fieldInfo, Field field) {
        String format;
        boolean match;
        String fieldName;
        fieldInfo.features = writerFeatures;
        provider.getFieldInfo(beanInfo, fieldInfo, objectClass, field);
        if (fieldInfo.ignore) {
            return null;
        }
        if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
            fieldName = field.getName();
            if (beanInfo.namingStrategy != null) {
                fieldName = BeanUtils.fieldName(fieldName, beanInfo.namingStrategy);
            }
        } else {
            fieldName = fieldInfo.fieldName;
        }
        if (beanInfo.orders != null) {
            match = false;
            for (int i = 0; i < beanInfo.orders.length; ++i) {
                if (!fieldName.equals(beanInfo.orders[i])) continue;
                fieldInfo.ordinal = i;
                match = true;
            }
            if (!match && fieldInfo.ordinal == 0) {
                fieldInfo.ordinal = beanInfo.orders.length;
            }
        }
        if (beanInfo.includes != null && beanInfo.includes.length > 0) {
            match = false;
            for (String include : beanInfo.includes) {
                if (!include.equals(fieldName)) continue;
                match = true;
                break;
            }
            if (!match) {
                return null;
            }
        }
        ObjectWriter writeUsingWriter = null;
        if (fieldInfo.writeUsing != null) {
            try {
                Constructor<?> constructor = fieldInfo.writeUsing.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                writeUsingWriter = (ObjectWriter)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create writeUsing Writer error", e);
            }
        }
        try {
            field.setAccessible(true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (writeUsingWriter == null && fieldInfo.fieldClassMixIn) {
            writeUsingWriter = ObjectWriterBaseModule.VoidObjectWriter.INSTANCE;
        }
        if (writeUsingWriter == null) {
            Class<?> fieldClass = field.getType();
            if (fieldClass == Date.class && provider != null) {
                ObjectWriter objectWriter = (ObjectWriter)provider.cache.get(fieldClass);
                if (objectWriter != ObjectWriterImplDate.INSTANCE) {
                    writeUsingWriter = objectWriter;
                }
            } else if (Map.class.isAssignableFrom(fieldClass) && (fieldInfo.keyUsing != null || fieldInfo.valueUsing != null)) {
                Constructor<?> constructor2;
                ObjectWriter keyWriter = null;
                ObjectWriter valueWriter = null;
                if (fieldInfo.keyUsing != null) {
                    try {
                        constructor2 = fieldInfo.keyUsing.getDeclaredConstructor(new Class[0]);
                        constructor2.setAccessible(true);
                        keyWriter = (ObjectWriter)constructor2.newInstance(new Object[0]);
                    }
                    catch (Exception constructor2) {
                        // empty catch block
                    }
                }
                if (fieldInfo.valueUsing != null) {
                    try {
                        constructor2 = fieldInfo.valueUsing.getDeclaredConstructor(new Class[0]);
                        constructor2.setAccessible(true);
                        valueWriter = (ObjectWriter)constructor2.newInstance(new Object[0]);
                    }
                    catch (Exception constructor3) {
                        // empty catch block
                    }
                }
                if (keyWriter != null || valueWriter != null) {
                    ObjectWriterImplMap mapWriter = ObjectWriterImplMap.of(field.getType(), fieldClass);
                    mapWriter.keyWriter = keyWriter;
                    mapWriter.valueWriter = valueWriter;
                    writeUsingWriter = mapWriter;
                }
            }
        }
        if ((format = fieldInfo.format) == null && beanInfo.format != null) {
            format = beanInfo.format;
        }
        return this.createFieldWriter(provider, fieldName, fieldInfo.ordinal, fieldInfo.features, format, fieldInfo.label, field, writeUsingWriter);
    }

    protected ObjectWriter getAnnotatedObjectWriter(ObjectWriterProvider provider, Class objectClass, BeanInfo beanInfo) {
        if ((beanInfo.writerFeatures & 0x20000000000000L) == 0L) {
            return null;
        }
        String fieldName = beanInfo.objectWriterFieldName;
        if (fieldName == null) {
            fieldName = "objectWriter";
        }
        try {
            Class mixinClass;
            Field field = null;
            if (beanInfo.mixIn && (mixinClass = (Class)provider.mixInCache.get(objectClass)) != null) {
                try {
                    field = mixinClass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (field == null) {
                field = objectClass.getDeclaredField(fieldName);
            }
            if (field != null && ObjectWriter.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers())) {
                field.setAccessible(true);
                return (ObjectWriter)field.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public ObjectWriter createObjectWriter(Class objectClass, long features, List<ObjectWriterModule> modules) {
        ObjectWriterProvider provider = null;
        for (ObjectWriterModule module : modules) {
            if (provider != null) continue;
            provider = module.getProvider();
        }
        return this.createObjectWriter(objectClass, features, provider);
    }

    public ObjectWriter createObjectWriter(Class objectClass, long features, ObjectWriterProvider provider) {
        ArrayList<Object> fieldWriters;
        long writerFieldFeatures;
        boolean fieldBased;
        BeanInfo beanInfo = new BeanInfo();
        beanInfo.readerFeatures |= 0x40000000000000L;
        provider.getBeanInfo(beanInfo, objectClass);
        if (beanInfo.serializer != null && ObjectWriter.class.isAssignableFrom(beanInfo.serializer)) {
            try {
                return (ObjectWriter)beanInfo.serializer.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create serializer error", e);
            }
        }
        ObjectWriter annotatedObjectWriter = this.getAnnotatedObjectWriter(provider, objectClass, beanInfo);
        if (annotatedObjectWriter != null) {
            return annotatedObjectWriter;
        }
        boolean record = BeanUtils.isRecord(objectClass);
        long beanFeatures = beanInfo.writerFeatures;
        if (beanInfo.seeAlso != null) {
            beanFeatures &= JSONWriter.Feature.WriteClassName.mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        boolean bl = fieldBased = ((writerFieldFeatures = features | beanFeatures) & JSONWriter.Feature.FieldBased.mask) != 0L;
        if (fieldBased && (record || objectClass.isInterface() || objectClass.isInterface())) {
            fieldBased = false;
        }
        FieldInfo fieldInfo = new FieldInfo();
        if (fieldBased) {
            TreeMap fieldWriterMap = new TreeMap();
            BeanUtils.declaredFields(objectClass, field -> {
                fieldInfo.init();
                FieldWriter fieldWriter = this.creteFieldWriter(objectClass, writerFieldFeatures, provider, beanInfo, fieldInfo, (Field)field);
                if (fieldWriter != null) {
                    fieldWriterMap.put(fieldWriter.fieldName, fieldWriter);
                }
            });
            fieldWriters = new ArrayList(fieldWriterMap.values());
        } else {
            boolean fieldWritersCreated = false;
            fieldWriters = new ArrayList();
            for (ObjectWriterModule module : provider.modules) {
                if (!module.createFieldWriters(this, objectClass, fieldWriters)) continue;
                fieldWritersCreated = true;
                break;
            }
            if (!fieldWritersCreated) {
                TreeMap fieldWriterMap = new TreeMap();
                if (!record) {
                    BeanUtils.declaredFields(objectClass, field -> {
                        FieldWriter origin;
                        fieldInfo.init();
                        fieldInfo.ignore = (field.getModifiers() & 1) == 0;
                        FieldWriter fieldWriter = this.creteFieldWriter(objectClass, writerFieldFeatures, provider, beanInfo, fieldInfo, (Field)field);
                        if (fieldWriter != null && (origin = fieldWriterMap.putIfAbsent(fieldWriter.fieldName, fieldWriter)) != null && origin.compareTo(fieldWriter) > 0) {
                            fieldWriterMap.put(fieldWriter.fieldName, fieldWriter);
                        }
                    });
                }
                BeanUtils.getters(objectClass, method -> {
                    FieldWriter origin;
                    boolean match;
                    String fieldName;
                    fieldInfo.init();
                    fieldInfo.features = writerFieldFeatures;
                    fieldInfo.format = beanInfo.format;
                    provider.getFieldInfo(beanInfo, fieldInfo, objectClass, (Method)method);
                    if (fieldInfo.ignore) {
                        return;
                    }
                    if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
                        char c1;
                        fieldName = BeanUtils.getterName(method, beanInfo.namingStrategy);
                        char c0 = '\u0000';
                        int len = fieldName.length();
                        if (len > 0) {
                            c0 = fieldName.charAt(0);
                        }
                        if (len == 1 && c0 >= 'a' && c0 <= 'z' || len > 2 && c0 >= 'A' && c0 <= 'Z' && (c1 = fieldName.charAt(1)) >= 'A' && c1 <= 'Z') {
                            char[] chars = fieldName.toCharArray();
                            chars[0] = c0 >= 'a' && c0 <= 'z' ? (char)(chars[0] - 32) : (char)(chars[0] + 32);
                            String fieldName1 = new String(chars);
                            Field field = BeanUtils.getDeclaredField(objectClass, fieldName1);
                            if (field != null && (len == 1 || Modifier.isPublic(field.getModifiers()))) {
                                fieldName = field.getName();
                            }
                        }
                    } else {
                        fieldName = fieldInfo.fieldName;
                    }
                    if (beanInfo.includes != null && beanInfo.includes.length > 0) {
                        match = false;
                        for (String include : beanInfo.includes) {
                            if (!include.equals(fieldName)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            return;
                        }
                    }
                    if ((beanInfo.writerFeatures & JSONWriter.Feature.WriteClassName.mask) != 0L && fieldName.equals(beanInfo.typeKey)) {
                        return;
                    }
                    if (beanInfo.orders != null) {
                        match = false;
                        for (int i = 0; i < beanInfo.orders.length; ++i) {
                            if (!fieldName.equals(beanInfo.orders[i])) continue;
                            fieldInfo.ordinal = i;
                            match = true;
                        }
                        if (!match && fieldInfo.ordinal == 0) {
                            fieldInfo.ordinal = beanInfo.orders.length;
                        }
                    }
                    ObjectWriter writeUsingWriter = null;
                    if (fieldInfo.writeUsing != null) {
                        try {
                            Constructor<?> constructor = fieldInfo.writeUsing.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            writeUsingWriter = (ObjectWriter)constructor.newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new JSONException("create writeUsing Writer error", e);
                        }
                    }
                    if (writeUsingWriter == null && fieldInfo.fieldClassMixIn) {
                        writeUsingWriter = ObjectWriterBaseModule.VoidObjectWriter.INSTANCE;
                    }
                    FieldWriter fieldWriter = null;
                    if ((beanInfo.readerFeatures & 0x40000000000000L) != 0L) {
                        try {
                            fieldWriter = this.createFieldWriterLambda(provider, objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.label, (Method)method, writeUsingWriter);
                        }
                        catch (Throwable ignored) {
                            this.jitErrorCount.incrementAndGet();
                            this.jitErrorLast = ignored;
                        }
                    }
                    if (fieldWriter == null) {
                        fieldWriter = this.createFieldWriter(provider, objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.label, (Method)method, writeUsingWriter);
                    }
                    if ((origin = (FieldWriter)fieldWriterMap.putIfAbsent(fieldWriter.fieldName, fieldWriter)) != null && origin.compareTo(fieldWriter) > 0) {
                        fieldWriterMap.put(fieldName, fieldWriter);
                    }
                });
                fieldWriters = new ArrayList(fieldWriterMap.values());
            }
        }
        long writerFeatures = features | beanInfo.writerFeatures;
        if (!fieldBased && Throwable.class.isAssignableFrom(objectClass)) {
            return new ObjectWriterException(objectClass, writerFeatures, fieldWriters);
        }
        this.handleIgnores(beanInfo, fieldWriters);
        if (beanInfo.alphabetic) {
            Collections.sort(fieldWriters);
        }
        if (BeanUtils.isExtendedMap(objectClass)) {
            Type superType = objectClass.getGenericSuperclass();
            FieldWriter superWriter = ObjectWriters.fieldWriter("$super$", superType, objectClass.getSuperclass(), o -> o);
            fieldWriters.add(superWriter);
        }
        ObjectWriterAdapter writerAdapter = null;
        boolean googleCollection = false;
        if (objectClass != null) {
            String typeName = objectClass.getName();
            boolean bl2 = googleCollection = "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList".equals(typeName) || "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet".equals(typeName);
        }
        if (!googleCollection) {
            switch (fieldWriters.size()) {
                case 1: {
                    if ((((FieldWriter)fieldWriters.get((int)0)).features & 0x1000000000000L) != 0L) break;
                    writerAdapter = new ObjectWriter1(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 2: {
                    writerAdapter = new ObjectWriter2(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 3: {
                    writerAdapter = new ObjectWriter3(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 4: {
                    writerAdapter = new ObjectWriter4(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 5: {
                    writerAdapter = new ObjectWriter5(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 6: {
                    writerAdapter = new ObjectWriter6(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 7: {
                    writerAdapter = new ObjectWriter7(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 8: {
                    writerAdapter = new ObjectWriter8(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 9: {
                    writerAdapter = new ObjectWriter9(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 10: {
                    writerAdapter = new ObjectWriter10(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 11: {
                    writerAdapter = new ObjectWriter11(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
                case 12: {
                    writerAdapter = new ObjectWriter12(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
                    break;
                }
            }
        }
        if (writerAdapter == null) {
            writerAdapter = new ObjectWriterAdapter(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
        }
        if (beanInfo.serializeFilters != null) {
            ObjectWriterCreator.configSerializeFilters(beanInfo, writerAdapter);
        }
        return writerAdapter;
    }

    protected static void configSerializeFilters(BeanInfo beanInfo, ObjectWriterAdapter writerAdapter) {
        for (Class<? extends Filter> filterClass : beanInfo.serializeFilters) {
            if (!Filter.class.isAssignableFrom(filterClass)) continue;
            try {
                Filter filter = filterClass.newInstance();
                writerAdapter.setFilter(filter);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    protected void handleIgnores(BeanInfo beanInfo, List<FieldWriter> fieldWriters) {
        if (beanInfo.ignores == null || beanInfo.ignores.length == 0) {
            return;
        }
        block0: for (int i = fieldWriters.size() - 1; i >= 0; --i) {
            FieldWriter fieldWriter = fieldWriters.get(i);
            for (String ignore : beanInfo.ignores) {
                if (!ignore.equals(fieldWriter.fieldName)) continue;
                fieldWriters.remove(i);
                continue block0;
            }
        }
    }

    public <T> FieldWriter<T> createFieldWriter(String fieldName, String format, Field field) {
        return this.createFieldWriter(JSONFactory.getDefaultObjectWriterProvider(), fieldName, 0, 0L, format, null, field, null);
    }

    public <T> FieldWriter<T> createFieldWriter(String fieldName, int ordinal, long features, String format, Field field) {
        return this.createFieldWriter(JSONFactory.getDefaultObjectWriterProvider(), fieldName, ordinal, features, format, null, field, null);
    }

    public <T> FieldWriter<T> createFieldWriter(String fieldName, int ordinal, long features, String format, String label, Field field, ObjectWriter initObjectWriter) {
        return this.createFieldWriter(JSONFactory.getDefaultObjectWriterProvider(), fieldName, ordinal, features, format, label, field, initObjectWriter);
    }

    public <T> FieldWriter<T> createFieldWriter(ObjectWriterProvider provider, String fieldName, int ordinal, long features, String format, String label, Field field, ObjectWriter initObjectWriter) {
        Class<?> declaringClass = field.getDeclaringClass();
        Method method = null;
        boolean unsafeFieldWriter = JDKUtils.UNSAFE_SUPPORT;
        if (declaringClass == Throwable.class) {
            switch (field.getName()) {
                case "detailMessage": {
                    if (unsafeFieldWriter) break;
                    method = BeanUtils.getMethod(Throwable.class, "getMessage");
                    fieldName = "message";
                    break;
                }
                case "cause": {
                    if (unsafeFieldWriter) break;
                    method = BeanUtils.getMethod(Throwable.class, "getCause");
                    break;
                }
                case "suppressedExceptions": {
                    if (unsafeFieldWriter) break;
                    fieldName = "suppressed";
                    break;
                }
                case "stackTrace": {
                    method = BeanUtils.getMethod(Throwable.class, "getStackTrace");
                    break;
                }
            }
        } else if (declaringClass == DateTimeParseException.class && !unsafeFieldWriter) {
            switch (field.getName()) {
                case "errorIndex": {
                    method = BeanUtils.getMethod(DateTimeParseException.class, "getErrorIndex");
                    break;
                }
                case "parsedString": {
                    method = BeanUtils.getMethod(DateTimeParseException.class, "getParsedString");
                    break;
                }
            }
        }
        if (method != null) {
            return this.createFieldWriter(provider, Throwable.class, fieldName, ordinal, features, format, label, method, initObjectWriter);
        }
        if (!unsafeFieldWriter) {
            field.setAccessible(true);
        }
        Class<Object> fieldClass = field.getType();
        Class fieldType = field.getGenericType();
        if (initObjectWriter != null) {
            if (fieldClass == Byte.TYPE) {
                fieldClass = Byte.class;
                fieldType = Byte.class;
            } else if (fieldClass == Short.TYPE) {
                fieldClass = Short.class;
                fieldType = Short.class;
            } else if (fieldClass == Integer.TYPE) {
                fieldClass = Integer.class;
                fieldType = Integer.class;
            } else if (fieldClass == Long.TYPE) {
                fieldClass = Long.class;
                fieldType = Long.class;
            } else if (fieldClass == Float.TYPE) {
                fieldClass = Float.class;
                fieldType = Float.class;
            } else if (fieldClass == Double.TYPE) {
                fieldClass = Double.class;
                fieldType = Double.class;
            } else if (fieldClass == Boolean.TYPE) {
                fieldClass = Boolean.class;
                fieldType = Boolean.class;
            }
            FieldWriterObject objImp = new FieldWriterObject(fieldName, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, field, null);
            objImp.initValueClass = fieldClass;
            if (initObjectWriter != ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
                objImp.initObjectWriter = initObjectWriter;
            }
            return objImp;
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldWriterBoolValField(fieldName, ordinal, features, format, label, field, fieldClass);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldWriterInt8ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldWriterInt16ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Integer.TYPE) {
            return new FieldWriterInt32Val(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Long.TYPE) {
            if (format == null || format.isEmpty()) {
                return new FieldWriterInt64ValField(fieldName, ordinal, features, format, label, field);
            }
            return new FieldWriterMillisField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldWriterFloatValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Float.class) {
            return new FieldWriterFloatField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldWriterDoubleValField(fieldName, ordinal, format, label, field);
        }
        if (fieldClass == Double.class) {
            return new FieldWriterDoubleField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldWriterCharValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldWriterBigIntField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldWriterBigDecimalField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Date.class) {
            return new FieldWriterDateField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == String.class) {
            return new FieldWriterStringField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass.isEnum()) {
            String[] enumAnnotationNames;
            Member enumValueField;
            ObjectWriter objectWriter;
            BeanInfo beanInfo = new BeanInfo();
            provider.getBeanInfo(beanInfo, fieldClass);
            boolean writeEnumAsJavaBean = beanInfo.writeEnumAsJavaBean;
            if (!writeEnumAsJavaBean && (objectWriter = (ObjectWriter)provider.cache.get(fieldClass)) != null && !(objectWriter instanceof ObjectWriterImplEnum)) {
                writeEnumAsJavaBean = true;
            }
            if ((enumValueField = BeanUtils.getEnumValueField(fieldClass, provider)) == null && !writeEnumAsJavaBean && (enumAnnotationNames = BeanUtils.getEnumAnnotationNames(fieldClass)) == null) {
                return new FieldWriterEnum(fieldName, ordinal, features, format, label, (Type)((Object)fieldType), (Class<? extends Enum>)fieldClass, field, null);
            }
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            Type itemType = null;
            if (fieldType instanceof ParameterizedType) {
                itemType = ((ParameterizedType)((Object)fieldType)).getActualTypeArguments()[0];
            }
            return new FieldWriterListField(fieldName, itemType, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, field);
        }
        if (fieldClass.isArray() && !fieldClass.getComponentType().isPrimitive()) {
            Class<?> itemClass = fieldClass.getComponentType();
            return new FieldWriterObjectArrayField(fieldName, itemClass, ordinal, features, format, label, itemClass, fieldClass, field);
        }
        return new FieldWriterObject(fieldName, ordinal, features, format, label, field.getGenericType(), fieldClass, field, null);
    }

    public <T> FieldWriter<T> createFieldWriter(Class<T> objectType, String fieldName, String dateFormat, Method method) {
        return this.createFieldWriter(objectType, fieldName, 0, 0L, dateFormat, method);
    }

    public <T> FieldWriter<T> createFieldWriter(Class<T> objectType, String fieldName, int ordinal, long features, String format, Method method) {
        return this.createFieldWriter(null, objectType, fieldName, ordinal, features, format, null, method, null);
    }

    public <T> FieldWriter<T> createFieldWriter(ObjectWriterProvider provider, Class<T> objectType, String fieldName, int ordinal, long features, String format, String label, Method method, ObjectWriter initObjectWriter) {
        String[] enumAnnotationNames;
        method.setAccessible(true);
        Class<?> fieldClass = method.getReturnType();
        Type fieldType = method.getGenericReturnType();
        if (initObjectWriter == null && provider != null) {
            initObjectWriter = this.getInitWriter(provider, fieldClass);
        }
        if (initObjectWriter != null) {
            FieldWriterObjectMethod objMethod = new FieldWriterObjectMethod(fieldName, ordinal, features, format, label, fieldType, fieldClass, method);
            objMethod.initValueClass = fieldClass;
            if (initObjectWriter != ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
                objMethod.initObjectWriter = initObjectWriter;
            }
            return objMethod;
        }
        if (fieldName == null) {
            fieldName = BeanUtils.getterName(method, null);
        }
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new FieldWriterBoolMethod(fieldName, ordinal, features, format, label, method, fieldClass);
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            return new FieldWriterInt32Method(fieldName, ordinal, features, format, label, method, fieldClass);
        }
        if (fieldClass == Float.TYPE || fieldClass == Float.class) {
            return new FieldWriterFloatMethod(fieldName, ordinal, features, format, label, fieldClass, fieldClass, method);
        }
        if (fieldClass == Double.TYPE || fieldClass == Double.class) {
            return new FieldWriterDoubleMethod(fieldName, ordinal, features, format, label, fieldClass, fieldClass, method);
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            if (format == null || format.isEmpty() || "string".equals(format)) {
                return new FieldWriterInt64Method(fieldName, ordinal, features, format, label, method, fieldClass);
            }
            return new FieldWriterMillisMethod(fieldName, ordinal, features, format, label, fieldClass, method);
        }
        if (fieldClass == Short.TYPE || fieldClass == Short.class) {
            return new FieldWriterInt16Method(fieldName, ordinal, features, format, label, method, fieldClass);
        }
        if (fieldClass == Byte.TYPE || fieldClass == Byte.class) {
            return new FieldWriterInt8Method(fieldName, ordinal, features, format, label, method, fieldClass);
        }
        if (fieldClass == Character.TYPE || fieldClass == Character.class) {
            return new FieldWriterCharMethod(fieldName, ordinal, features, format, label, method, fieldClass);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldWriterBigDecimalMethod(fieldName, ordinal, features, format, label, method);
        }
        if (fieldClass.isEnum() && BeanUtils.getEnumValueField(fieldClass, provider) == null && initObjectWriter == null && !BeanUtils.isWriteEnumAsJavaBean(fieldClass) && (enumAnnotationNames = BeanUtils.getEnumAnnotationNames(fieldClass)) == null) {
            return new FieldWriterEnumMethod(fieldName, ordinal, features, format, label, fieldClass, method);
        }
        if (fieldClass == Date.class) {
            if (format != null && (format = format.trim()).isEmpty()) {
                format = null;
            }
            return new FieldWriterDateMethod(fieldName, ordinal, features, format, label, fieldClass, method);
        }
        if (fieldClass == String.class) {
            return new FieldWriterStringMethod(fieldName, ordinal, format, label, features, method);
        }
        if (fieldClass == List.class) {
            Object itemType = null;
            itemType = fieldType instanceof ParameterizedType ? ((ParameterizedType)fieldType).getActualTypeArguments()[0] : Object.class;
            return new FieldWriterListMethod(fieldName, (Type)itemType, ordinal, features, format, label, method, fieldType, fieldClass);
        }
        if (fieldClass == Float[].class) {
            return new FieldWriterObjectArrayMethod(fieldName, (Type)((Object)Float.class), ordinal, features, format, label, fieldType, fieldClass, method);
        }
        if (fieldClass == Double[].class) {
            return new FieldWriterObjectArrayMethod(fieldName, (Type)((Object)Double.class), ordinal, features, format, label, fieldType, fieldClass, method);
        }
        if (fieldClass == BigDecimal[].class) {
            return new FieldWriterObjectArrayMethod(fieldName, (Type)((Object)BigDecimal.class), ordinal, features, format, label, fieldType, fieldClass, method);
        }
        return new FieldWriterObjectMethod(fieldName, ordinal, features, format, label, fieldType, fieldClass, method);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToLongFunction<T> function) {
        return new FieldWriterInt64ValFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToIntFunction<T> function) {
        return new FieldWriterInt32ValFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToShortFunction<T> function) {
        return new FieldWriterInt16ValFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToByteFunction<T> function) {
        return new FieldWriterInt8ValFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToFloatFunction<T> function) {
        return new FieldWriterFloatValueFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, ToDoubleFunction<T> function) {
        return new FieldWriterDoubleValueFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T> FieldWriter createFieldWriter(String fieldName, Predicate<T> function) {
        return new FieldWriterBoolValFunc(fieldName, 0, 0L, null, null, null, function);
    }

    public <T, V> FieldWriter createFieldWriter(String fieldName, Class fieldClass, Function<T, V> function) {
        return this.createFieldWriter(null, null, fieldName, 0, 0L, null, null, fieldClass, fieldClass, null, function);
    }

    public <T, V> FieldWriter createFieldWriter(String fieldName, Type fieldType, Class fieldClass, Function<T, V> function) {
        return this.createFieldWriter(null, null, fieldName, 0, 0L, null, null, fieldType, fieldClass, null, function);
    }

    public <T, V> FieldWriter createFieldWriter(String fieldName, long features, String format, Class fieldClass, Function<T, V> function) {
        return this.createFieldWriter(null, null, fieldName, 0, features, format, null, fieldClass, fieldClass, null, function);
    }

    public <T, V> FieldWriter<T> createFieldWriter(ObjectWriterProvider provider, Class<T> objectClass, String fieldName, int ordinal, long features, String format, String label, Type fieldType, Class<V> fieldClass, Method method, Function<T, V> function) {
        if (fieldClass == Byte.class) {
            return new FieldWriterInt8Func<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == Short.class) {
            return new FieldWriterInt16Func<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == Integer.class) {
            return new FieldWriterInt32Func<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == Long.class) {
            return new FieldWriterInt64Func<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldWriterBigIntFunc<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldWriterBigDecimalFunc<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == String.class) {
            return new FieldWriterStringFunc<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass == Date.class) {
            return new FieldWriterDateFunc<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (Calendar.class.isAssignableFrom(fieldClass)) {
            return new FieldWriterCalendarFunc<T>(fieldName, ordinal, features, format, label, method, function);
        }
        if (fieldClass.isEnum()) {
            String[] enumAnnotationNames;
            ObjectWriter objectWriter;
            BeanInfo beanInfo = new BeanInfo();
            if (provider == null) {
                provider = JSONFactory.getDefaultObjectWriterProvider();
            }
            provider.getBeanInfo(beanInfo, fieldClass);
            boolean writeEnumAsJavaBean = beanInfo.writeEnumAsJavaBean;
            if (!writeEnumAsJavaBean && (objectWriter = (ObjectWriter)provider.cache.get(fieldClass)) != null && !(objectWriter instanceof ObjectWriterImplEnum)) {
                writeEnumAsJavaBean = true;
            }
            if (!writeEnumAsJavaBean && BeanUtils.getEnumValueField(fieldClass, provider) == null && (enumAnnotationNames = BeanUtils.getEnumAnnotationNames(fieldClass)) == null) {
                return new FieldWriterEnumFunc(fieldName, ordinal, features, format, label, fieldType, fieldClass, method, function);
            }
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if ((rawType == List.class || rawType == ArrayList.class) && actualTypeArguments.length == 1) {
                Type itemType = actualTypeArguments[0];
                if (itemType == String.class) {
                    return new FieldWriterListStrFunc<T>(fieldName, ordinal, features, format, label, method, function, fieldType, fieldClass);
                }
                return new FieldWriterListFunc<T>(fieldName, ordinal, features, format, label, itemType, method, function, fieldType, fieldClass);
            }
        }
        if (Modifier.isFinal(fieldClass.getModifiers())) {
            return new FieldWriterObjectFuncFinal(fieldName, ordinal, features, format, label, fieldType, fieldClass, method, function);
        }
        return new FieldWriterObjectFunc(fieldName, ordinal, features, format, label, fieldType, fieldClass, method, function);
    }

    Object lambdaGetter(Class objectClass, Class fieldClass, Method method) {
        MethodType samMethodType;
        String methodName;
        MethodType invokedType;
        MethodType methodType;
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
        LambdaInfo buildInfo = lambdaMapping.get(fieldClass);
        if (buildInfo != null) {
            methodType = buildInfo.methodType;
            invokedType = buildInfo.invokedType;
            methodName = buildInfo.methodName;
            samMethodType = buildInfo.samMethodType;
        } else {
            methodType = MethodType.methodType(fieldClass);
            invokedType = TypeUtils.METHOD_TYPE_FUNCTION;
            methodName = "apply";
            samMethodType = TypeUtils.METHOD_TYPE_OBJECT_OBJECT;
        }
        try {
            MethodHandle target = lookup.findVirtual(objectClass, method.getName(), methodType);
            MethodType instantiatedMethodType = target.type();
            CallSite callSite = LambdaMetafactory.metafactory(lookup, methodName, invokedType, samMethodType, target, instantiatedMethodType);
            return callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new JSONException("create fieldLambdaGetter error, method : " + method, e);
        }
    }

    protected ObjectWriter getInitWriter(ObjectWriterProvider provider, Class fieldClass) {
        ObjectWriter objectWriter;
        if (fieldClass == Date.class) {
            ObjectWriter objectWriter2;
            if ((provider.userDefineMask & 0x10L) != 0L && (objectWriter2 = (ObjectWriter)provider.cache.get(fieldClass)) != ObjectWriterImplDate.INSTANCE) {
                return objectWriter2;
            }
        } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            ObjectWriter objectWriter3;
            if ((provider.userDefineMask & 4L) != 0L && (objectWriter3 = (ObjectWriter)provider.cache.get(Long.class)) != ObjectWriterImplInt64.INSTANCE) {
                return objectWriter3;
            }
        } else if (fieldClass == BigDecimal.class) {
            ObjectWriter objectWriter4;
            if ((provider.userDefineMask & 8L) != 0L && (objectWriter4 = (ObjectWriter)provider.cache.get(fieldClass)) != ObjectWriterImplBigDecimal.INSTANCE) {
                return objectWriter4;
            }
        } else if (Enum.class.isAssignableFrom(fieldClass) && !((objectWriter = (ObjectWriter)provider.cache.get(fieldClass)) instanceof ObjectWriterImplEnum)) {
            return objectWriter;
        }
        return null;
    }

    <T> FieldWriter<T> createFieldWriterLambda(ObjectWriterProvider provider, Class<T> objectClass, String fieldName, int ordinal, long features, String format, String label, Method method, ObjectWriter initObjectWriter) {
        Class<?> fieldClass = method.getReturnType();
        Type fieldType = method.getGenericReturnType();
        if (initObjectWriter == null && provider != null) {
            initObjectWriter = this.getInitWriter(provider, fieldClass);
        }
        if (initObjectWriter != null) {
            return null;
        }
        Object lambda = this.lambdaGetter(objectClass, fieldClass, method);
        if (fieldClass == Integer.TYPE) {
            return new FieldWriterInt32ValFunc(fieldName, ordinal, features, format, label, method, (ToIntFunction)lambda);
        }
        if (fieldClass == Long.TYPE) {
            if (format == null || format.isEmpty() || "string".equals(format)) {
                return new FieldWriterInt64ValFunc(fieldName, ordinal, features, format, label, method, (ToLongFunction)lambda);
            }
            return new FieldWriterMillisFunc(fieldName, ordinal, features, format, label, method, (ToLongFunction)lambda);
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldWriterBoolValFunc(fieldName, ordinal, features, format, label, method, (Predicate)lambda);
        }
        if (fieldClass == Boolean.class) {
            return new FieldWriterBooleanFunc(fieldName, ordinal, features, format, label, method, (Function)lambda);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldWriterInt16ValFunc(fieldName, ordinal, features, format, label, method, (ToShortFunction)lambda);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldWriterInt8ValFunc(fieldName, ordinal, features, format, label, method, (ToByteFunction)lambda);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldWriterFloatValueFunc(fieldName, ordinal, features, format, label, method, (ToFloatFunction)lambda);
        }
        if (fieldClass == Float.class) {
            return new FieldWriterFloatFunc(fieldName, ordinal, features, format, label, method, (Function)lambda);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldWriterDoubleValueFunc(fieldName, ordinal, features, format, label, method, (ToDoubleFunction)lambda);
        }
        if (fieldClass == Double.class) {
            return new FieldWriterDoubleFunc(fieldName, ordinal, features, format, label, method, (Function)lambda);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldWriterCharValFunc(fieldName, ordinal, features, format, label, method, (ToCharFunction)lambda);
        }
        Function function = (Function)lambda;
        return this.createFieldWriter(provider, objectClass, fieldName, ordinal, features, format, label, fieldType, fieldClass, method, function);
    }

    static {
        lambdaMapping.put(Boolean.TYPE, new LambdaInfo(Boolean.TYPE, Predicate.class, "test"));
        lambdaMapping.put(Character.TYPE, new LambdaInfo(Character.TYPE, ToCharFunction.class, "applyAsChar"));
        lambdaMapping.put(Byte.TYPE, new LambdaInfo(Byte.TYPE, ToByteFunction.class, "applyAsByte"));
        lambdaMapping.put(Short.TYPE, new LambdaInfo(Short.TYPE, ToShortFunction.class, "applyAsShort"));
        lambdaMapping.put(Integer.TYPE, new LambdaInfo(Integer.TYPE, ToIntFunction.class, "applyAsInt"));
        lambdaMapping.put(Long.TYPE, new LambdaInfo(Long.TYPE, ToLongFunction.class, "applyAsLong"));
        lambdaMapping.put(Float.TYPE, new LambdaInfo(Float.TYPE, ToFloatFunction.class, "applyAsFloat"));
        lambdaMapping.put(Double.TYPE, new LambdaInfo(Double.TYPE, ToDoubleFunction.class, "applyAsDouble"));
    }

    static class LambdaInfo {
        final Class fieldClass;
        final Class supplierClass;
        final String methodName;
        final MethodType methodType;
        final MethodType invokedType;
        final MethodType samMethodType;

        LambdaInfo(Class fieldClass, Class supplierClass, String methodName) {
            this.fieldClass = fieldClass;
            this.supplierClass = supplierClass;
            this.methodName = methodName;
            this.methodType = MethodType.methodType(fieldClass);
            this.invokedType = MethodType.methodType(supplierClass);
            this.samMethodType = MethodType.methodType(fieldClass, Object.class);
        }
    }
}

