<!--

 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.

-->
# OAuthClientCredentialsParameters

OAuth authentication based on client_id/client_secret

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**token_uri** | **str** | Token server URI | [optional] 
**client_id** | **str** | oauth client id | [optional] 
**client_secret** | **str** | oauth client secret (input-only) | [optional] 
**scopes** | **List[str]** | oauth scopes to specify when exchanging for a short-lived access token | [optional] 

## Example

```python
from polaris.management.models.o_auth_client_credentials_parameters import OAuthClientCredentialsParameters

# TODO update the JSON string below
json = "{}"
# create an instance of OAuthClientCredentialsParameters from a JSON string
o_auth_client_credentials_parameters_instance = OAuthClientCredentialsParameters.from_json(json)
# print the JSON string representation of the object
print(OAuthClientCredentialsParameters.to_json())

# convert the object into a dict
o_auth_client_credentials_parameters_dict = o_auth_client_credentials_parameters_instance.to_dict()
# create an instance of OAuthClientCredentialsParameters from a dict
o_auth_client_credentials_parameters_from_dict = OAuthClientCredentialsParameters.from_dict(o_auth_client_credentials_parameters_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


