#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from polaris.catalog.models.completed_planning_result import CompletedPlanningResult
from polaris.catalog.models.empty_planning_result import EmptyPlanningResult
from polaris.catalog.models.failed_planning_result import FailedPlanningResult
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

FETCHPLANNINGRESULT_ONE_OF_SCHEMAS = ["CompletedPlanningResult", "EmptyPlanningResult", "FailedPlanningResult"]

class FetchPlanningResult(BaseModel):
    """
    Result of server-side scan planning for fetchPlanningResult
    """
    # data type: CompletedPlanningResult
    oneof_schema_1_validator: Optional[CompletedPlanningResult] = None
    # data type: FailedPlanningResult
    oneof_schema_2_validator: Optional[FailedPlanningResult] = None
    # data type: EmptyPlanningResult
    oneof_schema_3_validator: Optional[EmptyPlanningResult] = None
    actual_instance: Optional[Union[CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult]] = None
    one_of_schemas: Set[str] = { "CompletedPlanningResult", "EmptyPlanningResult", "FailedPlanningResult" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = FetchPlanningResult.model_construct()
        error_messages = []
        match = 0
        # validate data type: CompletedPlanningResult
        if not isinstance(v, CompletedPlanningResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CompletedPlanningResult`")
        else:
            match += 1
        # validate data type: FailedPlanningResult
        if not isinstance(v, FailedPlanningResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FailedPlanningResult`")
        else:
            match += 1
        # validate data type: EmptyPlanningResult
        if not isinstance(v, EmptyPlanningResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EmptyPlanningResult`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in FetchPlanningResult with oneOf schemas: CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in FetchPlanningResult with oneOf schemas: CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into CompletedPlanningResult
        try:
            instance.actual_instance = CompletedPlanningResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FailedPlanningResult
        try:
            instance.actual_instance = FailedPlanningResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EmptyPlanningResult
        try:
            instance.actual_instance = EmptyPlanningResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into FetchPlanningResult with oneOf schemas: CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into FetchPlanningResult with oneOf schemas: CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CompletedPlanningResult, EmptyPlanningResult, FailedPlanningResult]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


