#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from polaris.catalog.api.iceberg_catalog_api import IcebergCatalogAPI


class TestIcebergCatalogAPI(unittest.TestCase):
    """IcebergCatalogAPI unit test stubs"""

    def setUp(self) -> None:
        self.api = IcebergCatalogAPI()

    def tearDown(self) -> None:
        pass

    def test_cancel_planning(self) -> None:
        """Test case for cancel_planning

        Cancels scan planning for a plan-id
        """
        pass

    def test_commit_transaction(self) -> None:
        """Test case for commit_transaction

        Commit updates to multiple tables in an atomic operation
        """
        pass

    def test_create_namespace(self) -> None:
        """Test case for create_namespace

        Create a namespace
        """
        pass

    def test_create_table(self) -> None:
        """Test case for create_table

        Create a table in the given namespace
        """
        pass

    def test_create_view(self) -> None:
        """Test case for create_view

        Create a view in the given namespace
        """
        pass

    def test_drop_namespace(self) -> None:
        """Test case for drop_namespace

        Drop a namespace from the catalog. Namespace must be empty.
        """
        pass

    def test_drop_table(self) -> None:
        """Test case for drop_table

        Drop a table from the catalog
        """
        pass

    def test_drop_view(self) -> None:
        """Test case for drop_view

        Drop a view from the catalog
        """
        pass

    def test_fetch_planning_result(self) -> None:
        """Test case for fetch_planning_result

        Fetches the result of scan planning for a plan-id
        """
        pass

    def test_fetch_scan_tasks(self) -> None:
        """Test case for fetch_scan_tasks

        Fetches result tasks for a plan task
        """
        pass

    def test_list_namespaces(self) -> None:
        """Test case for list_namespaces

        List namespaces, optionally providing a parent namespace to list underneath
        """
        pass

    def test_list_tables(self) -> None:
        """Test case for list_tables

        List all table identifiers underneath a given namespace
        """
        pass

    def test_list_views(self) -> None:
        """Test case for list_views

        List all view identifiers underneath a given namespace
        """
        pass

    def test_load_credentials(self) -> None:
        """Test case for load_credentials

        Load vended credentials for a table from the catalog
        """
        pass

    def test_load_namespace_metadata(self) -> None:
        """Test case for load_namespace_metadata

        Load the metadata properties for a namespace
        """
        pass

    def test_load_table(self) -> None:
        """Test case for load_table

        Load a table from the catalog
        """
        pass

    def test_load_view(self) -> None:
        """Test case for load_view

        Load a view from the catalog
        """
        pass

    def test_namespace_exists(self) -> None:
        """Test case for namespace_exists

        Check if a namespace exists
        """
        pass

    def test_plan_table_scan(self) -> None:
        """Test case for plan_table_scan

        Submit a scan for planning
        """
        pass

    def test_register_table(self) -> None:
        """Test case for register_table

        Register a table in the given namespace using given metadata file location
        """
        pass

    def test_rename_table(self) -> None:
        """Test case for rename_table

        Rename a table from its current name to a new name
        """
        pass

    def test_rename_view(self) -> None:
        """Test case for rename_view

        Rename a view from its current name to a new name
        """
        pass

    def test_replace_view(self) -> None:
        """Test case for replace_view

        Replace a view
        """
        pass

    def test_report_metrics(self) -> None:
        """Test case for report_metrics

        Send a metrics report to this endpoint to be processed by the backend
        """
        pass

    def test_table_exists(self) -> None:
        """Test case for table_exists

        Check if a table exists
        """
        pass

    def test_update_properties(self) -> None:
        """Test case for update_properties

        Set or remove properties on a namespace
        """
        pass

    def test_update_table(self) -> None:
        """Test case for update_table

        Commit updates to a table
        """
        pass

    def test_view_exists(self) -> None:
        """Test case for view_exists

        Check if a view exists
        """
        pass


if __name__ == '__main__':
    unittest.main()
