/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import io.smallrye.jwt.build.impl.JwtBuildUtils;
import io.smallrye.jwt.build.impl.JwtEncryptionImpl;
import io.smallrye.jwt.build.impl.JwtSignatureImpl;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.base64url.Base64;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.JoseException;

class JwtClaimsBuilderImpl
extends JwtSignatureImpl
implements JwtClaimsBuilder,
JwtSignatureBuilder {
    private static final String SCOPE_CLAIM = "scope";
    private static final StringVerifier STRING_VERIFIER = new StringVerifier();
    private static final InstantVerifier INSTANT_VERIFIER = new InstantVerifier();
    private static final StringCollectionVerifier STRING_COLLECTION_VERIFIER = new StringCollectionVerifier();
    private static final Map<String, ClaimTypeVerifier> REGISTERED_CLAIM_VERIFIERS = new HashMap<String, ClaimTypeVerifier>();

    JwtClaimsBuilderImpl() {
    }

    JwtClaimsBuilderImpl(String jsonLocation) {
        super(JwtClaimsBuilderImpl.parseJsonToClaims(jsonLocation));
    }

    JwtClaimsBuilderImpl(Map<String, Object> claimsMap) {
        super(JwtClaimsBuilderImpl.fromMapToJwtClaims(claimsMap));
    }

    JwtClaimsBuilderImpl(JwtClaims claims) {
        super(claims);
    }

    private static JwtClaims fromMapToJwtClaims(Map<String, Object> claimsMap) {
        JwtClaims claims = new JwtClaims();
        Map newMap = (Map)JwtClaimsBuilderImpl.prepareValue(claimsMap);
        for (Map.Entry entry : newMap.entrySet()) {
            claims.setClaim((String)entry.getKey(), entry.getValue());
        }
        return claims;
    }

    @Override
    public JwtClaimsBuilder claim(String name, Object value) {
        this.claims.setClaim(name, JwtClaimsBuilderImpl.verifyValueType(name, JwtClaimsBuilderImpl.prepareValue(value)));
        return this;
    }

    @Override
    public JwtClaimsBuilder issuer(String issuer) {
        this.claims.setIssuer(issuer);
        return this;
    }

    @Override
    public JwtClaimsBuilder audience(String audience) {
        return this.audience(Collections.singleton(audience));
    }

    @Override
    public JwtClaimsBuilder audience(Set<String> audiences) {
        this.claims.setAudience(audiences.stream().collect(Collectors.toList()));
        return this;
    }

    @Override
    public JwtClaimsBuilder subject(String subject) {
        this.claims.setSubject(subject);
        return this;
    }

    @Override
    public JwtClaimsBuilder upn(String upn) {
        this.claims.setClaim(Claims.upn.name(), (Object)upn);
        return this;
    }

    @Override
    public JwtClaimsBuilder preferredUserName(String preferredUserName) {
        this.claims.setClaim(Claims.preferred_username.name(), (Object)preferredUserName);
        return this;
    }

    @Override
    public JwtClaimsBuilder issuedAt(long issuedAt) {
        this.claims.setIssuedAt(NumericDate.fromSeconds((long)issuedAt));
        return this;
    }

    @Override
    public JwtClaimsBuilder expiresAt(long expiresAt) {
        this.claims.setExpirationTime(NumericDate.fromSeconds((long)expiresAt));
        return this;
    }

    @Override
    public JwtClaimsBuilder expiresIn(long expiresIn) {
        this.tokenLifespan = expiresIn;
        return this;
    }

    @Override
    public JwtClaimsBuilder groups(Set<String> groups) {
        this.claims.setClaim(Claims.groups.name(), groups.stream().collect(Collectors.toList()));
        return this;
    }

    @Override
    public JwtClaimsBuilder scope(Set<String> scopes) {
        this.claims.setClaim(SCOPE_CLAIM, (Object)scopes.stream().collect(Collectors.joining(" ")));
        return this;
    }

    @Override
    public JwtSignatureBuilder jws() {
        return this;
    }

    @Override
    public JwtSignatureBuilder header(String name, Object value) {
        if ("alg".equals(name)) {
            return this.algorithm(JwtClaimsBuilderImpl.toSignatureAlgorithm((String)value));
        }
        this.headers.put(name, value);
        return this;
    }

    @Override
    public JwtSignatureBuilder algorithm(SignatureAlgorithm algorithm) {
        this.headers.put("alg", algorithm.getAlgorithm());
        return this;
    }

    @Override
    public JwtSignatureBuilder keyId(String keyId) {
        this.headers.put("kid", keyId);
        return this;
    }

    @Override
    public JwtSignatureBuilder thumbprint(X509Certificate cert) {
        this.headers.put("x5t", X509Util.x5t((X509Certificate)cert));
        return this;
    }

    @Override
    public JwtSignatureBuilder thumbprintS256(X509Certificate cert) {
        this.headers.put("x5t#S256", X509Util.x5tS256((X509Certificate)cert));
        return this;
    }

    @Override
    public JwtSignatureBuilder chain(List<X509Certificate> chain) {
        ArrayList<String> base64EncodedCerts = new ArrayList<String>(chain.size());
        try {
            for (X509Certificate cert : chain) {
                base64EncodedCerts.add(Base64.encode((byte[])cert.getEncoded()));
            }
            this.headers.put("x5c", base64EncodedCerts);
        }
        catch (CertificateEncodingException ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
        return this;
    }

    @Override
    public JwtSignatureBuilder jwk(PublicKey key) {
        this.headers.put("jwk", JwtClaimsBuilderImpl.convertPublicKeyToJwk(key));
        return this;
    }

    @Override
    public JwtEncryptionBuilder innerSign(PrivateKey signingKey) throws JwtSignatureException {
        return super.innerSign(signingKey);
    }

    @Override
    public JwtEncryptionBuilder innerSign(SecretKey signingKey) throws JwtSignatureException {
        return super.innerSign(signingKey);
    }

    @Override
    public JwtEncryptionBuilder innerSign() throws JwtSignatureException {
        return super.innerSign();
    }

    @Override
    public JwtEncryptionBuilder jwe() {
        JwtBuildUtils.setDefaultJwtClaims(this.claims, this.tokenLifespan);
        try {
            JwtEncryptionImpl jwtEncryptionImpl = new JwtEncryptionImpl(this.claims.toJson());
            return jwtEncryptionImpl;
        }
        finally {
            this.removeJti();
        }
    }

    private static Object prepareValue(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(o -> JwtClaimsBuilderImpl.prepareValue(o)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put((String)entry.getKey(), JwtClaimsBuilderImpl.prepareValue(entry.getValue()));
            }
            return newMap;
        }
        if (value instanceof JsonValue) {
            return JwtClaimsBuilderImpl.convertJsonValue((JsonValue)value);
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Instant) {
            return ((Instant)value).getEpochSecond();
        }
        if (value instanceof PublicKey) {
            return JwtClaimsBuilderImpl.convertPublicKeyToJwk((PublicKey)value);
        }
        return value.toString();
    }

    private static Object convertJsonValue(JsonValue jsonValue) {
        if (jsonValue instanceof JsonString) {
            String jsonString = jsonValue.toString();
            return jsonString.toString().substring(1, jsonString.length() - 1);
        }
        if (jsonValue instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            if (jsonNumber.isIntegral()) {
                return jsonNumber.longValue();
            }
            return jsonNumber.doubleValue();
        }
        if (jsonValue == JsonValue.TRUE) {
            return true;
        }
        if (jsonValue == JsonValue.FALSE) {
            return false;
        }
        return null;
    }

    private static JwtClaims parseJsonToClaims(String jsonLocation) {
        return JwtBuildUtils.parseJwtClaims(jsonLocation);
    }

    private static SignatureAlgorithm toSignatureAlgorithm(String value) {
        try {
            return SignatureAlgorithm.fromAlgorithm((String)value);
        }
        catch (Exception ex) {
            throw ImplMessages.msg.unsupportedSignatureAlgorithm(value, ex);
        }
    }

    private static Object verifyValueType(String name, Object value) {
        ClaimTypeVerifier verifier = REGISTERED_CLAIM_VERIFIERS.get(name);
        return verifier == null ? value : verifier.verify(name, value);
    }

    static Map<String, Object> convertPublicKeyToJwk(PublicKey key) {
        try {
            return PublicJsonWebKey.Factory.newPublicJwk((Key)key).toParams(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
        }
        catch (JoseException ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
    }

    @Override
    public JwtClaimsBuilder remove(String name) {
        this.claims.unsetClaim(name);
        return this;
    }

    static {
        REGISTERED_CLAIM_VERIFIERS.put(Claims.sub.name(), STRING_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.iss.name(), STRING_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.jti.name(), STRING_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.upn.name(), STRING_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.preferred_username.name(), STRING_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.iat.name(), INSTANT_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.auth_time.name(), INSTANT_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.exp.name(), INSTANT_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.aud.name(), STRING_COLLECTION_VERIFIER);
        REGISTERED_CLAIM_VERIFIERS.put(Claims.groups.name(), STRING_COLLECTION_VERIFIER);
    }

    static interface ClaimTypeVerifier {
        public Object verify(String var1, Object var2);
    }

    static class StringVerifier
    implements ClaimTypeVerifier {
        StringVerifier() {
        }

        @Override
        public Object verify(String name, Object value) {
            if (value instanceof String) {
                return value;
            }
            throw new IllegalArgumentException(String.format("'%s' claim value must be String", name));
        }
    }

    static class InstantVerifier
    implements ClaimTypeVerifier {
        InstantVerifier() {
        }

        @Override
        public Object verify(String name, Object value) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            throw new IllegalArgumentException(String.format("'%s' claim value must be long", name));
        }
    }

    static class StringCollectionVerifier
    implements ClaimTypeVerifier {
        StringCollectionVerifier() {
        }

        @Override
        public Object verify(String name, Object value) {
            Iterator it;
            if (value instanceof String) {
                return value;
            }
            if (value instanceof Collection && (it = ((Collection)value).iterator()).hasNext() && it.next() instanceof String) {
                return value;
            }
            throw new IllegalArgumentException(String.format("'%s' claim value must be String or Collection of Strings", name));
        }
    }
}

