/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class PemUtils {
    private static byte[] parsePEMFile(Path pemPath) throws IOException {
        if (!Files.isRegularFile(pemPath, new LinkOption[0]) || !Files.exists(pemPath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("The file '%s' doesn't exist.", pemPath.toAbsolutePath()));
        }
        try (BufferedReader reader = Files.newBufferedReader(pemPath, StandardCharsets.UTF_8);){
            StringBuilder encodedBuilder = new StringBuilder();
            boolean headerFound = false;
            boolean footerFound = false;
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("-----BEGIN")) {
                    headerFound = true;
                } else {
                    if (line.startsWith("-----END")) {
                        footerFound = true;
                        break;
                    }
                    if (!line.isBlank()) {
                        encodedBuilder.append(line);
                    }
                }
                line = reader.readLine();
            }
            if (headerFound) {
                if (!footerFound) {
                    throw new IOException("PEM Footer not found");
                }
            } else {
                throw new IOException("PEM Header not found");
            }
            String encoded = encodedBuilder.toString();
            byte[] parsed = Base64.getMimeDecoder().decode(encoded);
            byte[] byArray = parsed;
            return byArray;
        }
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algorithm) {
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            return kf.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not reconstruct the public key, the given algorithm could not be found", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not reconstruct the public key", e);
        }
    }

    private static PrivateKey getPrivateKey(byte[] keyBytes, String algorithm) {
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            return kf.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not reconstruct the private key, the given algorithm could not be found", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not reconstruct the private key", e);
        }
    }

    public static PublicKey readPublicKeyFromFile(Path filepath, String algorithm) throws IOException {
        byte[] bytes = PemUtils.parsePEMFile(filepath);
        return PemUtils.getPublicKey(bytes, algorithm);
    }

    public static PrivateKey readPrivateKeyFromFile(Path filepath, String algorithm) throws IOException {
        byte[] bytes = PemUtils.parsePEMFile(filepath);
        return PemUtils.getPrivateKey(bytes, algorithm);
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        return kpg.generateKeyPair();
    }

    public static void generateKeyPairFiles(Path privateFileLocation, Path publicFileLocation) throws NoSuchAlgorithmException, IOException {
        PemUtils.writeKeyPairFiles(PemUtils.generateKeyPair(), privateFileLocation, publicFileLocation);
    }

    public static void writeKeyPairFiles(KeyPair keyPair, Path privateFileLocation, Path publicFileLocation) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(privateFileLocation, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("-----BEGIN PRIVATE KEY-----");
            writer.newLine();
            writer.write(Base64.getMimeEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
            writer.newLine();
            writer.write("-----END PRIVATE KEY-----");
            writer.newLine();
        }
        writer = Files.newBufferedWriter(publicFileLocation, StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            writer.write("-----BEGIN PUBLIC KEY-----");
            writer.newLine();
            writer.write(Base64.getMimeEncoder().encodeToString(keyPair.getPublic().getEncoded()));
            writer.newLine();
            writer.write("-----END PUBLIC KEY-----");
            writer.newLine();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

