/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import java.util.Optional;
import org.apache.polaris.service.auth.OAuthTokenErrorResponse;

public class TokenResponse {
    private final Optional<OAuthTokenErrorResponse.Error> error;
    private String accessToken;
    private String tokenType;
    private Integer expiresIn;

    public TokenResponse(OAuthTokenErrorResponse.Error error) {
        this.error = Optional.of(error);
    }

    public TokenResponse(String accessToken, String tokenType, int expiresIn) {
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.tokenType = tokenType;
        this.error = Optional.empty();
    }

    public boolean isValid() {
        return this.error.isEmpty();
    }

    public OAuthTokenErrorResponse.Error getError() {
        return this.error.get();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getTokenType() {
        return this.tokenType;
    }
}

