/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisCredentialVendor;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIOUtil.class);

    private FileIOUtil() {
    }

    public static Optional<PolarisEntity> findStorageInfoFromHierarchy(PolarisResolvedPathWrapper resolvedStorageEntity) {
        Optional<PolarisEntity> storageInfoEntity = resolvedStorageEntity.getRawFullPath().reversed().stream().filter(e -> e.getInternalPropertiesAsMap().containsKey(PolarisEntityConstants.getStorageConfigInfoPropertyName())).findFirst();
        return storageInfoEntity;
    }

    public static AccessConfig refreshAccessConfig(CallContext callContext, PolarisEntityManager entityManager, PolarisCredentialVendor credentialVendor, PolarisConfigurationStore configurationStore, TableIdentifier tableIdentifier, Set<String> tableLocations, Set<PolarisStorageActions> storageActions, PolarisEntity entity) {
        boolean skipCredentialSubscopingIndirection = (Boolean)configurationStore.getConfiguration(callContext.getRealmContext(), FeatureConfiguration.SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION.key, (Object)((Boolean)FeatureConfiguration.SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION.defaultValue));
        if (skipCredentialSubscopingIndirection) {
            LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).log("Skipping generation of subscoped creds for table");
            return AccessConfig.builder().build();
        }
        boolean allowList = storageActions.contains(PolarisStorageActions.LIST) || storageActions.contains(PolarisStorageActions.ALL);
        Set<String> writeLocations = storageActions.contains(PolarisStorageActions.WRITE) || storageActions.contains(PolarisStorageActions.DELETE) || storageActions.contains(PolarisStorageActions.ALL) ? tableLocations : Set.of();
        AccessConfig accessConfig = entityManager.getCredentialCache().getOrGenerateSubScopeCreds(credentialVendor, callContext.getPolarisCallContext(), entity, allowList, tableLocations, writeLocations);
        LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("credentialKeys", accessConfig.credentials().keySet()).addKeyValue("extraProperties", (Object)accessConfig.extraProperties()).log("Loaded scoped credentials for table");
        if (accessConfig.credentials().isEmpty()) {
            LOGGER.debug("No credentials found for table");
        }
        return accessConfig;
    }
}

