/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityType;

public class PolarisEntityCore {
    protected long catalogId;
    protected long id;
    protected long parentId;
    protected int typeCode;
    protected String name;
    protected int entityVersion;

    public PolarisEntityCore() {
    }

    public PolarisEntityCore(long catalogId, long id, long parentId, int typeCode, String name, int entityVersion) {
        this.catalogId = catalogId;
        this.id = id;
        this.parentId = parentId;
        this.typeCode = typeCode;
        this.name = name;
        this.entityVersion = entityVersion;
    }

    public PolarisEntityCore(PolarisBaseEntity entity) {
        this.catalogId = entity.getCatalogId();
        this.id = entity.getId();
        this.parentId = entity.getParentId();
        this.typeCode = entity.getTypeCode();
        this.name = entity.getName();
        this.entityVersion = entity.getEntityVersion();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getEntityVersion() {
        return this.entityVersion;
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(long catalogId) {
        this.catalogId = catalogId;
    }

    public void setEntityVersion(int entityVersion) {
        this.entityVersion = entityVersion;
    }

    @JsonIgnore
    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode(this.typeCode);
    }

    @JsonIgnore
    public boolean cannotBeDroppedOrRenamed() {
        return this.typeCode == PolarisEntityType.CATALOG_ROLE.getCode() && this.name.equals(PolarisEntityConstants.getNameOfCatalogAdminRole()) || this.typeCode == PolarisEntityType.PRINCIPAL_ROLE.getCode() && this.name.equals(PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
    }

    @JsonIgnore
    public boolean isTopLevel() {
        return this.getType().isTopLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolarisEntityCore)) {
            return false;
        }
        PolarisEntityCore that = (PolarisEntityCore)o;
        return this.catalogId == that.catalogId && this.id == that.id && this.parentId == that.parentId && this.typeCode == that.typeCode && this.entityVersion == that.entityVersion && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.catalogId, this.id, this.parentId, this.typeCode, this.name, this.entityVersion);
    }

    public String toString() {
        return "PolarisEntityCore{catalogId=" + this.catalogId + ", id=" + this.id + ", parentId=" + this.parentId + ", typeCode=" + this.typeCode + ", name='" + this.name + "', entityVersion=" + this.entityVersion + "}";
    }
}

