/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink.models;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

@Entity
@Table(name="ENTITIES")
public class ModelEntity {
    @Id
    private long catalogId;
    @Id
    private long id;
    private long parentId;
    private int typeCode;
    private String name;
    private int entityVersion;
    public static final String EMPTY_MAP_STRING = "{}";
    private int subTypeCode;
    private long createTimestamp;
    private long dropTimestamp;
    private long purgeTimestamp;
    private long toPurgeTimestamp;
    private long lastUpdateTimestamp;
    @Column(columnDefinition="TEXT")
    private String properties;
    @Column(columnDefinition="TEXT")
    private String internalProperties;
    private int grantRecordsVersion;
    @Version
    private long version;

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getName() {
        return this.name;
    }

    public int getEntityVersion() {
        return this.entityVersion;
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getDropTimestamp() {
        return this.dropTimestamp;
    }

    public long getPurgeTimestamp() {
        return this.purgeTimestamp;
    }

    public long getToPurgeTimestamp() {
        return this.toPurgeTimestamp;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public String getProperties() {
        return this.properties != null ? this.properties : EMPTY_MAP_STRING;
    }

    public String getInternalProperties() {
        return this.internalProperties != null ? this.internalProperties : EMPTY_MAP_STRING;
    }

    public int getGrantRecordsVersion() {
        return this.grantRecordsVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelEntity fromEntity(PolarisBaseEntity entity) {
        return ModelEntity.builder().catalogId(entity.getCatalogId()).id(entity.getId()).parentId(entity.getParentId()).typeCode(entity.getTypeCode()).name(entity.getName()).entityVersion(entity.getEntityVersion()).subTypeCode(entity.getSubTypeCode()).createTimestamp(entity.getCreateTimestamp()).dropTimestamp(entity.getDropTimestamp()).purgeTimestamp(entity.getPurgeTimestamp()).toPurgeTimestamp(entity.getToPurgeTimestamp()).lastUpdateTimestamp(entity.getLastUpdateTimestamp()).properties(entity.getProperties()).internalProperties(entity.getInternalProperties()).grantRecordsVersion(entity.getGrantRecordsVersion()).build();
    }

    public static PolarisBaseEntity toEntity(ModelEntity model) {
        if (model == null) {
            return null;
        }
        PolarisBaseEntity entity = new PolarisBaseEntity(model.getCatalogId(), model.getId(), PolarisEntityType.fromCode((int)model.getTypeCode()), PolarisEntitySubType.fromCode((int)model.getSubTypeCode()), model.getParentId(), model.getName());
        entity.setEntityVersion(model.getEntityVersion());
        entity.setCreateTimestamp(model.getCreateTimestamp());
        entity.setDropTimestamp(model.getDropTimestamp());
        entity.setPurgeTimestamp(model.getPurgeTimestamp());
        entity.setToPurgeTimestamp(model.getToPurgeTimestamp());
        entity.setLastUpdateTimestamp(model.getLastUpdateTimestamp());
        entity.setProperties(model.getProperties());
        entity.setInternalProperties(model.getInternalProperties());
        entity.setGrantRecordsVersion(model.getGrantRecordsVersion());
        return entity;
    }

    public void update(PolarisBaseEntity entity) {
        if (entity == null) {
            return;
        }
        this.catalogId = entity.getCatalogId();
        this.id = entity.getId();
        this.parentId = entity.getParentId();
        this.typeCode = entity.getTypeCode();
        this.name = entity.getName();
        this.entityVersion = entity.getEntityVersion();
        this.subTypeCode = entity.getSubTypeCode();
        this.createTimestamp = entity.getCreateTimestamp();
        this.dropTimestamp = entity.getDropTimestamp();
        this.purgeTimestamp = entity.getPurgeTimestamp();
        this.toPurgeTimestamp = entity.getToPurgeTimestamp();
        this.lastUpdateTimestamp = entity.getLastUpdateTimestamp();
        this.properties = entity.getProperties();
        this.internalProperties = entity.getInternalProperties();
        this.grantRecordsVersion = entity.getGrantRecordsVersion();
    }

    public static final class Builder {
        private final ModelEntity entity = new ModelEntity();

        private Builder() {
        }

        public Builder catalogId(long catalogId) {
            this.entity.catalogId = catalogId;
            return this;
        }

        public Builder id(long id) {
            this.entity.id = id;
            return this;
        }

        public Builder parentId(long parentId) {
            this.entity.parentId = parentId;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.entity.typeCode = typeCode;
            return this;
        }

        public Builder name(String name) {
            this.entity.name = name;
            return this;
        }

        public Builder entityVersion(int entityVersion) {
            this.entity.entityVersion = entityVersion;
            return this;
        }

        public Builder subTypeCode(int subTypeCode) {
            this.entity.subTypeCode = subTypeCode;
            return this;
        }

        public Builder createTimestamp(long createTimestamp) {
            this.entity.createTimestamp = createTimestamp;
            return this;
        }

        public Builder dropTimestamp(long dropTimestamp) {
            this.entity.dropTimestamp = dropTimestamp;
            return this;
        }

        public Builder purgeTimestamp(long purgeTimestamp) {
            this.entity.purgeTimestamp = purgeTimestamp;
            return this;
        }

        public Builder toPurgeTimestamp(long toPurgeTimestamp) {
            this.entity.toPurgeTimestamp = toPurgeTimestamp;
            return this;
        }

        public Builder lastUpdateTimestamp(long lastUpdateTimestamp) {
            this.entity.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder properties(String properties) {
            this.entity.properties = properties;
            return this;
        }

        public Builder internalProperties(String internalProperties) {
            this.entity.internalProperties = internalProperties;
            return this;
        }

        public Builder grantRecordsVersion(int grantRecordsVersion) {
            this.entity.grantRecordsVersion = grantRecordsVersion;
            return this;
        }

        public ModelEntity build() {
            return this.entity;
        }
    }
}

