/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientConnect;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.PrematureCloseException;
import reactor.util.Logger;
import reactor.util.Loggers;

final class HttpTrafficHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    static final Logger log = Loggers.getLogger(HttpTrafficHandler.class);

    HttpTrafficHandler(ConnectionObserver listener) {
        this.listener = listener;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            if (ctx.pipeline().get("reactor.left.h2MultiplexHandler") == null) {
                ctx.fireChannelActive();
            } else if (ctx.pipeline().get("reactor.left.sslHandler") == null) {
                this.sendNewState(Connection.from((Channel)channel), ConnectionObserver.State.CONNECTED);
                ctx.flush();
                ctx.read();
            } else {
                this.sendNewState(Connection.from((Channel)channel), ConnectionObserver.State.CONNECTED);
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2SettingsFrame) {
            ctx.channel().attr(HttpClientConnect.ENABLE_CONNECT_PROTOCOL).set((Object)((Long)((Http2SettingsFrame)msg).settings().get('\b')));
            this.sendNewState(Connection.from((Channel)ctx.channel()), ConnectionObserver.State.CONFIGURED);
            ctx.pipeline().remove("reactor.right.reactiveBridge");
            ctx.pipeline().remove((ChannelHandler)this);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireExceptionCaught((Throwable)new PrematureCloseException("Connection prematurely closed BEFORE response"));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Channel channel = ctx.channel();
        if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)channel, (String)"An upgrade request was sent to the server."));
            }
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)channel, (String)"The upgrade to H2C protocol was successful."));
            }
            this.sendNewState(Connection.from((Channel)channel), HttpClientState.UPGRADE_SUCCESSFUL);
            ctx.pipeline().remove((ChannelHandler)this);
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)channel, (String)"The upgrade to H2C protocol was rejected, continue using HTTP/1.x protocol."));
            }
            this.sendNewState(Connection.from((Channel)channel), HttpClientState.UPGRADE_REJECTED);
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.fireUserEventTriggered(evt);
    }

    void sendNewState(Connection connection, ConnectionObserver.State state) {
        ChannelOperations ops = (ChannelOperations)connection.as(ChannelOperations.class);
        if (ops != null) {
            this.listener.onStateChange((Connection)ops, state);
        } else {
            this.listener.onStateChange(connection, state);
        }
    }
}

