/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;

public class PolarisEntityResolver {
    private final PolarisDiagnostics diagnostics;
    private final boolean isSuccess;
    private final PolarisEntityCore catalogEntity;
    private final long parentEntityId;

    PolarisEntityResolver(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nullable PolarisEntityCore resolvedEntity, @Nullable List<PolarisEntityCore> otherTopLevelEntities) {
        this.diagnostics = callCtx.getDiagServices();
        if (catalogPath != null) {
            callCtx.getDiagServices().check(!catalogPath.isEmpty(), "catalogPath_cannot_be_empty");
            callCtx.getDiagServices().check(catalogPath.get(0).getTypeCode() == PolarisEntityType.CATALOG.getCode(), "entity_is_not_catalog", "entity={}", this);
        } else if (resolvedEntity != null) {
            callCtx.getDiagServices().check(resolvedEntity.getType().isTopLevel(), "not_top_level_entity", "resolvedEntity={}", resolvedEntity);
        }
        if (otherTopLevelEntities != null) {
            for (PolarisEntityCore topLevelCatalogEntityDto : otherTopLevelEntities) {
                callCtx.getDiagServices().check(topLevelCatalogEntityDto.isTopLevel() || topLevelCatalogEntityDto.getType().getParentType() == PolarisEntityType.CATALOG && catalogPath != null, "not_top_level_or_missing_catalog_path", "entity={} catalogPath={}", topLevelCatalogEntityDto, catalogPath);
            }
        }
        this.isSuccess = this.resolveEntitiesIfNeeded(callCtx, ms, catalogPath, resolvedEntity, otherTopLevelEntities);
        if (!this.isSuccess) {
            this.catalogEntity = null;
            this.parentEntityId = PolarisEntityConstants.getNullId();
        } else if (catalogPath != null) {
            this.catalogEntity = catalogPath.get(0);
            this.parentEntityId = catalogPath.get(catalogPath.size() - 1).getId();
        } else {
            this.catalogEntity = null;
            this.parentEntityId = PolarisEntityConstants.getRootEntityId();
        }
    }

    PolarisEntityResolver(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath) {
        this(callCtx, ms, catalogPath, null, null);
    }

    PolarisEntityResolver(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, PolarisEntityCore resolvedEntityDto) {
        this(callCtx, ms, catalogPath, resolvedEntityDto, null);
    }

    PolarisEntityResolver(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        this(callCtx, ms, catalogPath, new PolarisEntityCore(entity), null);
    }

    boolean isFailure() {
        return !this.isSuccess;
    }

    long getParentId() {
        this.diagnostics.check(this.isSuccess, "resolver_failed");
        return this.parentEntityId;
    }

    long getCatalogIdOrNull() {
        this.diagnostics.check(this.isSuccess, "resolver_failed");
        return this.catalogEntity == null ? PolarisEntityConstants.getNullId() : this.catalogEntity.getId();
    }

    private boolean resolveEntitiesIfNeeded(@Nonnull PolarisCallContext callCtx, @Nonnull TransactionalPersistence ms, @Nullable List<PolarisEntityCore> catalogPath, @Nullable PolarisEntityCore resolvedEntity, @Nullable List<PolarisEntityCore> otherTopLevelEntities) {
        int resolveCount = (catalogPath != null ? catalogPath.size() : 0) + (resolvedEntity != null ? 1 : 0) + (otherTopLevelEntities != null ? otherTopLevelEntities.size() : 0);
        if (resolveCount == 0) {
            return true;
        }
        ArrayList<PolarisEntityCore> toResolve = new ArrayList<PolarisEntityCore>(resolveCount);
        if (otherTopLevelEntities != null) {
            toResolve.addAll(otherTopLevelEntities);
        }
        if (catalogPath != null) {
            toResolve.addAll(catalogPath);
        }
        if (resolvedEntity != null) {
            toResolve.add(resolvedEntity);
        }
        List<PolarisEntitiesActiveKey> entityActiveKeys = toResolve.stream().map(entityCore -> new PolarisEntitiesActiveKey(entityCore.getCatalogId(), entityCore.getParentId(), entityCore.getTypeCode(), entityCore.getName())).collect(Collectors.toList());
        Iterator<EntityNameLookupRecord> activeRecordIt = ms.lookupEntityActiveBatchInCurrentTxn(callCtx, entityActiveKeys).iterator();
        for (PolarisEntityCore resolveEntity : toResolve) {
            EntityNameLookupRecord activeEntityRecord = activeRecordIt.next();
            if (activeEntityRecord != null && activeEntityRecord.getId() == resolveEntity.getId()) continue;
            return false;
        }
        return true;
    }
}

