/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public class AwsStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    @JsonIgnore
    public static final String ROLE_ARN_PATTERN = "^arn:(aws|aws-us-gov):iam::(\\d{12}):role/.+$";
    private static final Pattern ROLE_ARN_PATTERN_COMPILED = Pattern.compile("^arn:(aws|aws-us-gov):iam::(\\d{12}):role/.+$");
    @Nonnull
    private final String roleARN;
    @JsonProperty(value="externalId")
    @Nullable
    private String externalId = null;
    @JsonProperty(value="userARN")
    @Nullable
    private String userARN = null;
    @JsonProperty(value="region")
    @Nullable
    private String region = null;

    @JsonCreator
    public AwsStorageConfigurationInfo(@JsonProperty(value="storageType", required=true) @Nonnull PolarisStorageConfigurationInfo.StorageType storageType, @JsonProperty(value="allowedLocations", required=true) @Nonnull List<String> allowedLocations, @JsonProperty(value="roleARN", required=true) @Nonnull String roleARN, @JsonProperty(value="region", required=false) @Nullable String region) {
        this(storageType, allowedLocations, roleARN, null, region);
    }

    public AwsStorageConfigurationInfo(@Nonnull PolarisStorageConfigurationInfo.StorageType storageType, @Nonnull List<String> allowedLocations, @Nonnull String roleARN, @Nullable String externalId, @Nullable String region) {
        super(storageType, allowedLocations);
        this.roleARN = roleARN;
        this.externalId = externalId;
        this.region = region;
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.aws.s3.S3FileIO";
    }

    public static void validateArn(String arn) {
        if (arn == null || arn.isEmpty()) {
            throw new IllegalArgumentException("ARN cannot be null or empty");
        }
        if (arn.contains("aws-cn")) {
            throw new IllegalArgumentException("AWS China is temporarily not supported");
        }
        if (!Pattern.matches(ROLE_ARN_PATTERN, arn)) {
            throw new IllegalArgumentException("Invalid role ARN format");
        }
    }

    @Nonnull
    public String getRoleARN() {
        return this.roleARN;
    }

    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(@Nullable String externalId) {
        this.externalId = externalId;
    }

    @Nullable
    public String getUserARN() {
        return this.userARN;
    }

    public void setUserARN(@Nullable String userARN) {
        this.userARN = userARN;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    public void setRegion(@Nullable String region) {
        this.region = region;
    }

    @JsonIgnore
    public String getAwsAccountId() {
        return AwsStorageConfigurationInfo.parseAwsAccountId(this.roleARN);
    }

    @JsonIgnore
    public String getAwsPartition() {
        return AwsStorageConfigurationInfo.parseAwsPartition(this.roleARN);
    }

    private static String parseAwsAccountId(String arn) {
        AwsStorageConfigurationInfo.validateArn(arn);
        Matcher matcher = ROLE_ARN_PATTERN_COMPILED.matcher(arn);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        throw new IllegalArgumentException("ARN does not match the expected role ARN pattern");
    }

    private static String parseAwsPartition(String arn) {
        AwsStorageConfigurationInfo.validateArn(arn);
        Matcher matcher = ROLE_ARN_PATTERN_COMPILED.matcher(arn);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("ARN does not match the expected role ARN pattern");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("storageType", (Object)this.getStorageType()).add("storageType", (Object)this.getStorageType().name()).add("roleARN", (Object)this.roleARN).add("userARN", (Object)this.userARN).add("externalId", (Object)this.externalId).add("allowedLocation", this.getAllowedLocations()).add("region", (Object)this.region).toString();
    }
}

