/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import java.util.EnumMap;
import java.util.function.BiConsumer;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.ImmutableAccessConfig;
import org.apache.polaris.core.storage.StorageAccessProperty;

public class StorageCredentialCacheEntry {
    public final EnumMap<StorageAccessProperty, String> credsMap;
    private final ScopedCredentialsResult scopedCredentialsResult;

    public StorageCredentialCacheEntry(ScopedCredentialsResult scopedCredentialsResult) {
        this.scopedCredentialsResult = scopedCredentialsResult;
        this.credsMap = scopedCredentialsResult.getCredentials();
    }

    public long getExpirationTime() {
        if (this.credsMap.containsKey((Object)StorageAccessProperty.GCS_ACCESS_TOKEN_EXPIRES_AT)) {
            return Long.parseLong(this.credsMap.get((Object)StorageAccessProperty.GCS_ACCESS_TOKEN_EXPIRES_AT));
        }
        if (this.credsMap.containsKey((Object)StorageAccessProperty.AWS_SESSION_TOKEN_EXPIRES_AT_MS)) {
            return Long.parseLong(this.credsMap.get((Object)StorageAccessProperty.AWS_SESSION_TOKEN_EXPIRES_AT_MS));
        }
        if (this.credsMap.containsKey((Object)StorageAccessProperty.EXPIRATION_TIME)) {
            return Long.parseLong(this.credsMap.get((Object)StorageAccessProperty.EXPIRATION_TIME));
        }
        return Long.MAX_VALUE;
    }

    private void handleAzureCredential(BiConsumer<String, String> results, StorageAccessProperty credentialProperty, String value) {
        if (credentialProperty.equals((Object)StorageAccessProperty.AZURE_SAS_TOKEN)) {
            String withSuffixStripped;
            int suffixIndex;
            String host = this.credsMap.get((Object)StorageAccessProperty.AZURE_ACCOUNT_HOST);
            results.accept(credentialProperty.getPropertyName() + host, value);
            if (host.endsWith("dfs.core.windows.net") && (suffixIndex = host.lastIndexOf("dfs.core.windows.net") - 1) > 0) {
                withSuffixStripped = host.substring(0, suffixIndex);
                results.accept(credentialProperty.getPropertyName() + withSuffixStripped, value);
            }
            if (host.endsWith("blob.core.windows.net") && (suffixIndex = host.lastIndexOf("blob.core.windows.net") - 1) > 0) {
                withSuffixStripped = host.substring(0, suffixIndex);
                results.accept(credentialProperty.getPropertyName() + withSuffixStripped, value);
            }
        }
    }

    AccessConfig toAccessConfig() {
        ImmutableAccessConfig.Builder config = AccessConfig.builder();
        if (!this.credsMap.isEmpty()) {
            this.credsMap.forEach((key, value) -> {
                if (!key.isCredential()) {
                    config.putExtraProperty(key.getPropertyName(), (String)value);
                    return;
                }
                if (key.equals((Object)StorageAccessProperty.AZURE_SAS_TOKEN)) {
                    this.handleAzureCredential(config::putCredential, (StorageAccessProperty)((Object)key), (String)value);
                } else if (!key.equals((Object)StorageAccessProperty.AZURE_ACCOUNT_HOST)) {
                    config.putCredential(key.getPropertyName(), (String)value);
                }
            });
        }
        return config.build();
    }
}

