/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.actions.ImmutableRewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.actions.RewriteGroupBase;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.DataFileSet;

public class RewriteFileGroup
extends RewriteGroupBase<RewriteDataFiles.FileGroupInfo, FileScanTask, DataFile> {
    private final int outputSpecId;
    private DataFileSet addedFiles = DataFileSet.create();

    @Deprecated
    public RewriteFileGroup(RewriteDataFiles.FileGroupInfo info, List<FileScanTask> fileScanTasks) {
        this(info, fileScanTasks, 0, 0L, 0L, 0);
    }

    public RewriteFileGroup(RewriteDataFiles.FileGroupInfo info, List<FileScanTask> fileScanTasks, int outputSpecId, long writeMaxFileSize, long inputSplitSize, int expectedOutputFiles) {
        super(info, fileScanTasks, writeMaxFileSize, inputSplitSize, expectedOutputFiles);
        this.outputSpecId = outputSpecId;
    }

    @Deprecated
    public List<FileScanTask> fileScans() {
        return this.fileScanTasks();
    }

    public void setOutputFiles(Set<DataFile> files) {
        this.addedFiles = DataFileSet.of(files);
    }

    public Set<DataFile> rewrittenFiles() {
        return (Set)this.fileScanTasks().stream().map(ContentScanTask::file).collect(Collectors.toCollection(DataFileSet::create));
    }

    public Set<DataFile> addedFiles() {
        return this.addedFiles;
    }

    public RewriteDataFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState((this.addedFiles != null ? 1 : 0) != 0, (Object)"Cannot get result, Group was never rewritten");
        return ImmutableRewriteDataFiles.FileGroupRewriteResult.builder().info((RewriteDataFiles.FileGroupInfo)this.info()).addedDataFilesCount(this.addedFiles.size()).rewrittenDataFilesCount(this.fileScanTasks().size()).rewrittenBytesCount(this.inputFilesSizeInBytes()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("info", this.info()).add("numRewrittenFiles", this.fileScanTasks().size()).add("numAddedFiles", (Object)(this.addedFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedFiles.size()))).add("numRewrittenBytes", this.inputFilesSizeInBytes()).add("maxOutputFileSize", this.maxOutputFileSize()).add("inputSplitSize", this.inputSplitSize()).add("expectedOutputFiles", this.expectedOutputFiles()).add("outputSpecId", this.outputSpecId).toString();
    }

    @Deprecated
    public long sizeInBytes() {
        return this.inputFilesSizeInBytes();
    }

    @Deprecated
    public int numFiles() {
        return this.inputFileNum();
    }

    public int outputSpecId() {
        return this.outputSpecId;
    }

    public static Comparator<RewriteFileGroup> comparator(RewriteJobOrder rewriteJobOrder) {
        switch (rewriteJobOrder) {
            case BYTES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes);
            }
            case BYTES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes, Comparator.reverseOrder());
            }
            case FILES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum);
            }
            case FILES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum, Comparator.reverseOrder());
            }
        }
        return (unused, unused2) -> 0;
    }
}

