/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.AbstractDataSourceProvider;

@LoadLevel(name="dbcp")
public class DbcpDataSourceProvider
extends AbstractDataSourceProvider {
    public DataSource doGenerate() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.getDriverClassName());
        ds.setDriverClassLoader(this.getDriverClassLoader());
        ds.setUrl(this.getUrl());
        ds.setUsername(this.getUser());
        ds.setPassword(this.getPassword());
        ds.setInitialSize(this.getMinConn());
        ds.setMaxTotal(this.getMaxConn());
        ds.setMinIdle(this.getMinConn());
        ds.setMaxIdle(this.getMinConn());
        ds.setMaxWaitMillis(this.getMaxWait().longValue());
        ds.setNumTestsPerEvictionRun(1);
        ds.setValidationQuery(this.getValidationQuery(this.getDBType()));
        ds.setConnectionProperties("useUnicode=yes;characterEncoding=utf8;socketTimeout=5000;connectTimeout=500");
        ds.setDefaultTransactionIsolation(2);
        long timeBetweenEvictionRunsMillis = CONFIG.getLong("store.db.dbcp.timeBetweenEvictionRunsMillis", 120000L);
        ds.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis < 0L ? 120000L : timeBetweenEvictionRunsMillis);
        long minEvictableIdleTimeMillis = CONFIG.getLong("store.db.dbcp.minEvictableIdleTimeMillis", 300000L);
        ds.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis < 0L ? 300000L : minEvictableIdleTimeMillis);
        boolean testWhileIdle = CONFIG.getBoolean("store.db.dbcp.testWhileIdle", true);
        ds.setTestWhileIdle(testWhileIdle);
        boolean testOnBorrow = CONFIG.getBoolean("store.db.dbcp.testOnBorrow", false);
        ds.setTestOnBorrow(testOnBorrow);
        return ds;
    }
}

