/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLMapDataType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.HiveUtils;
import com.alibaba.druid.util.MySqlUtils;
import com.alibaba.druid.util.OdpsUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SQLDataTypeValidator
extends SQLASTVisitorAdapter {
    private long[] supportTypeHashCodes;
    private static String[] odpsTypes;
    private static String[] hiveTypes;
    private static String[] mysqlTypes;

    public SQLDataTypeValidator(String[] supportTypes) {
        this.supportTypeHashCodes = FnvHash.fnv1a_64_lower(supportTypes, true);
    }

    public SQLDataTypeValidator(Set<String> typeSet) {
        this.supportTypeHashCodes = new long[typeSet.size()];
        int i = 0;
        for (String type : typeSet) {
            this.supportTypeHashCodes[i++] = FnvHash.fnv1a_64_lower(type);
        }
        Arrays.sort(this.supportTypeHashCodes);
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.validate(x);
        return true;
    }

    @Override
    public boolean visit(SQLCharacterDataType x) {
        this.validate(x);
        return true;
    }

    @Override
    public boolean visit(SQLArrayDataType x) {
        this.validate(x);
        return true;
    }

    @Override
    public boolean visit(SQLMapDataType x) {
        this.validate(x);
        return true;
    }

    @Override
    public boolean visit(SQLStructDataType x) {
        this.validate(x);
        return true;
    }

    public void validate(SQLDataType x) {
        long hash = x.nameHashCode64();
        if (Arrays.binarySearch(this.supportTypeHashCodes, hash) < 0) {
            SQLColumnDefinition column;
            String msg = "illegal dataType : " + x.getName();
            SQLObject parent = x.getParent();
            if (parent instanceof SQLColumnDefinition && (column = (SQLColumnDefinition)parent).getName() != null) {
                msg = msg + ", column " + column.getName();
            }
            throw new FastsqlException(msg);
        }
    }

    public static SQLDataTypeValidator of(DbType dbType) {
        HashSet<String> typeSet = null;
        String[] types = null;
        switch (dbType) {
            case odps: {
                types = odpsTypes;
                if (types != null) break;
                typeSet = new HashSet<String>();
                OdpsUtils.DIALECT.dumpBuiltInDataTypes(typeSet);
                break;
            }
            case hive: {
                types = hiveTypes;
                if (types != null) break;
                typeSet = new HashSet();
                HiveUtils.loadDataTypes(typeSet);
                break;
            }
            case mysql: {
                types = mysqlTypes;
                if (types != null) break;
                typeSet = new HashSet();
                MySqlUtils.loadDataTypes(typeSet);
                break;
            }
        }
        if (types == null && typeSet != null) {
            types = typeSet.toArray(new String[typeSet.size()]);
        }
        if (types == null) {
            throw new FastsqlException("dataType " + (Object)((Object)dbType) + " not support.");
        }
        return new SQLDataTypeValidator(types);
    }

    public static void check(SQLStatement stmt) {
        SQLDataTypeValidator v = SQLDataTypeValidator.of(stmt.getDbType());
        stmt.accept(v);
    }

    public static void check(List<SQLStatement> stmtList) {
        if (stmtList.isEmpty()) {
            return;
        }
        DbType dbType = stmtList.get(0).getDbType();
        SQLDataTypeValidator v = SQLDataTypeValidator.of(dbType);
        SQLDataTypeValidator.check(stmtList, dbType);
    }

    public static void check(List<SQLStatement> stmtList, DbType dbType) {
        if (stmtList.isEmpty()) {
            return;
        }
        SQLDataTypeValidator v = SQLDataTypeValidator.of(dbType);
        for (SQLStatement stmt : stmtList) {
            stmt.accept(v);
        }
    }
}

