<!--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
-->
Add changes here for all PR submitted to the 2.x branch.

<!-- Please add the `changes` to the following location(feature/bugfix/optimize/test) based on the type of PR -->

### feature:

- [[#7485](https://github.com/apache/incubator-seata/pull/7485)] Add http request filter for seata-server
- [[#7509](https://github.com/apache/incubator-seata/pull/7509)] Reuse connection to merge branch transactions
- [[#7492](https://github.com/apache/incubator-seata/pull/7492)] upgrade HTTP client in common module to support HTTP/2
- [[#7503](https://github.com/apache/incubator-seata/pull/7503)] support fory serializer and fory undolog parser
- [[#7551](https://github.com/apache/incubator-seata/pull/7551)] XAUtils add support for DM Database
- [[#7559](https://github.com/apache/incubator-seata/pull/7559)] Introduce Cleanup API for TableMetaRefreshHolder Instance
- [[#7669](https://github.com/apache/incubator-seata/pull/7669)] add support for Jackson serialization and deserialization of PostgreSQL array types
- [[#7664](https://github.com/apache/incubator-seata/pull/7664)] support shentongdatabase XA mode
- [[#7675](https://github.com/apache/incubator-seata/pull/7675)] support Oracle Batch Insert
- [[#7663](https://github.com/apache/incubator-seata/pull/7663)] add Java 25 support in CI configuration files
- [[#7851](https://github.com/apache/incubator-seata/pull/7851)] add support for managing transaction groups
- [[#7857](https://github.com/apache/incubator-seata/pull/7857)] support displaying cluster information in the console
- [[#7826](https://github.com/apache/incubator-seata/pull/7826)] Support HTTP/2 response handling for the Watch API in Server Raft mode
- [[#7863](https://github.com/apache/incubator-seata/pull/7863)] Exclude namingserver and console module builds from build workflows with JDK versions less than 25
- [[#7870](https://github.com/apache/incubator-seata/pull/7870)] upgrade the namingserver and console modules to JDK 25 and SpringBoot 3.5, and add the spring-ai dependency in the console module.
- [[#7872](https://github.com/apache/incubator-seata/pull/7872)] Automatically calculate the values for JVM parameters
- [[#7876](https://github.com/apache/incubator-seata/pull/7876)] feature: add MCP custom configuration and authentication code
- [[#7878](https://github.com/apache/incubator-seata/pull/7878)] console supports creation and modification of transaction groups for Raft clusters
- [[#7893](https://github.com/apache/incubator-seata/pull/7893)] add global and branch session and lock management MCP tools


### bugfix:

- [[#7471](https://github.com/apache/seata/issues/7471)] Fix SerialArray equals() method for multi-dimensional array comparison in Phase 2 rollback
- [[#7482](https://github.com/apache/incubator-seata/pull/7482)] Github Action workflow does not run the corresponding Kotlin test
- [[#7538](https://github.com/apache/incubator-seata/pull/7538)] unify DmdbTimestamp comparison via UTC Instant to prevent rollback failure
- [[#7546](https://github.com/seata/seata/pull/7546)] fix client spring version compatible
- [[#7505](https://github.com/apache/incubator-seata/pull/7505)] prevent Netty I/O thread blocking by async channel release via reconnectExecutor
- [[#7563](https://github.com/apache/incubator-seata/pull/7563)] Fix NPE when server-side filter is disabled and filter chain is null.
- [[#7570](https://github.com/apache/incubator-seata/pull/7570)] Fix order() behavior in GlobalTransactionalInterceptorHandler to ensure correct sorting of invocation handlers
- [[#7596](https://github.com/apache/incubator-seata/pull/7596)] Fixed the issue where deserialization failed when the xss filter obtained the default keyword
- [[#7613](https://github.com/apache/incubator-seata/pull/7613)] Fixed the SQL error in the datetime format time query in the global lock query
- [[#7622](https://github.com/seata/seata/pull/7622)] adjust the order of org.apache.seata.saga.rm.SagaResourceManage
- [[#7624](https://github.com/apache/incubator-seata/pull/7624)] fix the compatibility issue of yml configuration files
- [[#7644](https://github.com/apache/incubator-seata/pull/7644)] fix the compatibility issue of spotless when java 25
- [[#7662](https://github.com/apache/incubator-seata/pull/7662)] ensure visibility of rm and The methods in MockTest are executed in order
- [[#7683](https://github.com/apache/incubator-seata/pull/7683)] Override XABranchXid equals() and hashCode() to fix memory leak in mysql driver
- [[#7643](https://github.com/apache/incubator-seata/pull/7643)] fix DM transaction rollback not using database auto-increment primary keys
- [[#7708](https://github.com/apache/incubator-seata/pull/7708)] Use xaActive to determine whether xaResource needs to execute the end method
- [[#7747](https://github.com/apache/incubator-seata/pull/7747)] undo log table name dynamic derivation
- [[#7749](https://github.com/apache/incubator-seata/pull/7749)] fix error parsing application/x-www-form-urlencoded requests in Http2HttpHandler
- [[#7761](https://github.com/apache/incubator-seata/pull/7761)] special handling is applied to the Byte[] type to ensure the correct primary key value
- [[#7771](https://github.com/apache/incubator-seata/pull/7771)] Shentongdata xa mode should be hold the same connection
- [[#7785](https://github.com/apache/incubator-seata/pull/7785)] fix the failure test
- [[#7796](https://github.com/apache/incubator-seata/pull/7796)] fix the NPE on ConsulConfigurationTest method
- [[#7839](https://github.com/apache/incubator-seata/pull/7839)] resolve TransactionAutoConfiguration compatibility with Spring Boot 4.x
- [[#7843](https://github.com/apache/incubator-seata/pull/7843)] fix index type misjudgment in Dm/KingbaseTableMetaCache
- [[#7856](https://github.com/apache/incubator-seata/pull/7856)] fix comma missing in package.json/min-document
- [[#7860](https://github.com/apache/incubator-seata/pull/7860)] Fix the issue where delayed messages in RocketMQ transactions were silently ignored, now explicitly throwing an exception
- [[#7879](https://github.com/apache/incubator-seata/pull/7879)] fix:correct server port and naming server port
- [[#7881](https://github.com/apache/incubator-seata/pull/7881)] the vgroup_table in the SQL files of all databases should use a three-column unique constraint
- [[#7891](https://github.com/apache/incubator-seata/pull/7891)] raft split-brain causes incorrect cluster information
- [[#7908](https://github.com/apache/incubator-seata/pull/7908)] handle timestamp with time zone in postgresql primary key
- [[#7938](https://github.com/apache/incubator-seata/pull/7938)] ensure the Jakarta-related package paths are correct.
- [[#7959](https://github.com/apache/incubator-seata/pull/7959)] fix consoleApiService bean that could not be found
- [[#7966](https://github.com/apache/incubator-seata/pull/7966)] fix different element order in two lists causes failure to set the index as primary key index


### optimize:

- [[#7460](https://github.com/apache/incubator-seata/pull/7460)] Remove hardcoded port configuration in core module test classes
- [[#7478](https://github.com/apache/incubator-seata/pull/7484)] optimize: remove client id metric
- [[#7557](https://github.com/seata/seata/pull/7557)] upgrade some npmjs dependencies
- [[#7576](https://github.com/seata/seata/pull/7576)] Add empty push protection for Configuration
- [[#7577](https://github.com/seata/seata/pull/7577)]  remove the 4MB size limit when decompressing with zstd
- [[#7578](https://github.com/seata/seata/pull/7578)]  zstd decompression is changed from jni to ZstdInputStream
- [[#7591](https://github.com/seata/seata/pull/7591)]  Optimize default xssFilter config retrieval when no explicit configuration is provided
- [[#7608](https://github.com/seata/seata/pull/7608)]  modify the parameter name in refreshToken method
- [[#7603](https://github.com/seata/seata/pull/7603)] upgrade Apache Tomcat dependency from 9.0.106 to 9.0.108
- [[#7614](https://github.com/seata/seata/pull/7614)] update README.md
- [[#7443](https://github.com/seata/seata/pull/7443)] Replace @LocalTCC with @SagaTransactional in the saga annotation pattern
- [[#7645](https://github.com/seata/seata/pull/7645)] simplifying the relevant transport.* configuration types
- [[#7668](https://github.com/seata/seata/pull/7668)] correct variable name typo in DeflaterUtil
- [[#7673](https://github.com/apache/incubator-seata/pull/7673)] bump @babel/runtime from ^7.26.10 to ^7.27.0
- [[#7689](https://github.com/apache/incubator-seata/pull/7689)] optimize source release
- [[#7711](https://github.com/apache/incubator-seata/pull/7711)] add fastjson support for serialization and deserialization of PostgreSQL array types
- [[#7722](https://github.com/apache/incubator-seata/pull/7722)] optimize serializer type meaning
- [[#7739](https://github.com/apache/incubator-seata/pull/7739)] optimize docker image building process
- [[#7741](https://github.com/apache/incubator-seata/pull/7741)] supports publishing image based on JDK 25
- [[#7743](https://github.com/seata/seata/pull/7743)] upgrade Apache Tomcat dependency from 9.0.108 to 9.0.109
- [[#7740](https://github.com/apache/incubator-seata/pull/7740)] enhance HttpClient to support h2c
- [[#7744](https://github.com/apache/incubator-seata/pull/7744)] upgrade Apache Tomcat dependency from 9.0.109 to 9.0.110
- [[#7751](https://github.com/apache/incubator-seata/pull/7751)] remove unused dependency
- [[#7807](https://github.com/apache/incubator-seata/pull/7807)] support mariadb 3.x
- [[#7781](https://github.com/apache/incubator-seata/pull/7781)] highlight pmd-check log
- [[#7704](https://github.com/apache/incubator-seata/pull/7704)] fix frontend security vulnerabilities
- [[#7710](https://github.com/apache/incubator-seata/pull/7710)] fix some spell errors in code and comments
- [[#7721](https://github.com/apache/incubator-seata/pull/7721)] optimize common module
- [[#7768](https://github.com/apache/incubator-seata/pull/7768)] optimize docker image building process
- [[#7809](https://github.com/apache/incubator-seata/pull/7809)] optimize README.md
- [[#7813](https://github.com/apache/incubator-seata/pull/7813)] add decode buffer limit
- [[#7822](https://github.com/apache/incubator-seata/pull/7822)] add the request and response objects in HTTP thread context
- [[#7829](https://github.com/apache/incubator-seata/pull/7829)] optimize lz4 compressor
- [[#7864](https://github.com/apache/incubator-seata/pull/7864)] automatically skip the compilation of console and namingserver modules in JDK<25
- [[#7867](https://github.com/apache/incubator-seata/pull/7867)] optimize global transaction support non-private modifier methods
- [[#7868](https://github.com/apache/incubator-seata/pull/7868)] change build_arm64-binary CI to JDK25 Version and runs on ubuntu-24.04-arm
- [[#7873](https://github.com/apache/incubator-seata/pull/7873)] upgrade jacoco plugin version from 0.8.7 to 0.8.14 in order to adapt JDK25
- [[#7885](https://github.com/apache/incubator-seata/pull/7885)] replace fury with fory
- [[#7884](https://github.com/apache/incubator-seata/pull/7884)] upgrade tomcat-embed-core version to 11.0.10
- [[#7888](https://github.com/apache/incubator-seata/pull/7888)] bump org.apache.tomcat.embed:tomcat-embed-core
- [[#7889](https://github.com/apache/incubator-seata/pull/7889)] bump org.apache.tomcat.embed:tomcat-embed-core in /console
- [[#7894](https://github.com/apache/incubator-seata/pull/7894)] optimize method and class names in the saga module
- [[#7905](https://github.com/apache/incubator-seata/pull/7905)] format content
- [[#7909](https://github.com/apache/incubator-seata/pull/7909)] add comments to the namingserver address configuration in console application file
- [[#7913](https://github.com/apache/incubator-seata/pull/7913)] remove @author info
- [[#7931](https://github.com/apache/incubator-seata/pull/7931)] pin the Spring version for namingserver and console
- [[#7942](https://github.com/apache/incubator-seata/pull/7942)] update jib-maven-plugin version and increase parallel test execution limits
- [[#7935](https://github.com/apache/incubator-seata/pull/7935)] add OkHttp and MockWebServer dependencies to resolve version conflicts


### security:

- [[#7632](https://github.com/apache/incubator-seata/pull/7632)] upgrade sha.js to version 2.4.12
- [[#7633](https://github.com/apache/incubator-seata/pull/7633)] Upgrade cipher-base to version 1.0.6
- [[#7716](https://github.com/apache/incubator-seata/pull/7716)] Update commons-lang to 3.18.0
- [[#7699](https://github.com/apache/incubator-seata/pull/7699)] Upgrade axios to version 1.12.2
- [[#7845](https://github.com/apache/incubator-seata/pull/7845)] upgrade node-forge to version 1.3.2 or later
- [[#7849](https://github.com/apache/incubator-seata/pull/7849)] upgrade min-document to version 2.19.1 or later
- [[#7847](https://github.com/apache/incubator-seata/pull/7847)] upgrade js-yaml to 3.14.2, 4.1.1 or later

### test:

- [[#7635](https://github.com/apache/incubator-seata/pull/7635)] fix JUnit test method access modifiers and annotations
- [[#7541](https://github.com/seata/seata/pull/7541)] fix jakarta UT failed in jdk17+
- [[#7540](https://github.com/seata/seata/pull/7540)] fix port of mock server
- [[#7580](https://github.com/seata/seata/pull/7580)]  fix the exception caused by the disorder of test case execution order
- [[#7584](https://github.com/apache/incubator-seata/pull/7584)] deflake ConsulConfigurationTest#testInitSeataConfig with short await/retry to absorb CI timing delay
- [[#7610](https://github.com/apache/incubator-seata/pull/7610)] Enable Nacos integration tests when nacosCaseEnabled is true
- [[#7672](https://github.com/apache/incubator-seata/pull/7672)] Add unit tests for the `seata-common` module
- [[#7679](https://github.com/apache/incubator-seata/pull/7679)] fix old version connect timeout
- [[#7638](https://github.com/apache/incubator-seata/pull/7638)]Add unit tests for the `seata-common` module and remove a todo
- [[#7709](https://github.com/apache/incubator-seata/pull/7709)] add UT for dm module
- [[#7725](https://github.com/apache/incubator-seata/pull/7725)] add UT for compressor module
- [[#7718](https://github.com/apache/incubator-seata/pull/7718)] add UT for config module
- [[#7723](https://github.com/apache/incubator-seata/pull/7723)] add UT for fastjson2 to test PostgreSQL Array type
- [[#7731](https://github.com/apache/incubator-seata/pull/7731)] add UT for rm.fence
- [[#7737](https://github.com/apache/incubator-seata/pull/7737)] add UT for DefaultResourceManager and ClusterWatcherManager
- [[#7757](https://github.com/apache/incubator-seata/pull/7757)] add UT for undo module
- [[#7763](https://github.com/apache/incubator-seata/pull/7763)] add UT for RegistryNamingServerProperties and RegistryMetadataProperties
- [[#7764](https://github.com/apache/incubator-seata/pull/7764)] add some UT for server/coordinator module
- [[#7777](https://github.com/apache/incubator-seata/pull/7777)] add UT for seata-saga-statelang module
- [[#7776](https://github.com/apache/incubator-seata/pull/7776)] add UT for XA module
- [[#7788](https://github.com/apache/incubator-seata/pull/7788)] add some UT for rm-datasource module
- [[#7774](https://github.com/apache/incubator-seata/pull/7774)] add some UT for server/console module
- [[#7767](https://github.com/apache/incubator-seata/pull/7767)] add some UT for server/cluster module
- [[#7750](https://github.com/apache/incubator-seata/pull/7750)] add some UT for server module
- [[#7733](https://github.com/apache/incubator-seata/pull/7733)] add some UT for core module
- [[#7728](https://github.com/apache/incubator-seata/pull/7728)] add some UT for compatible module
- [[#7727](https://github.com/apache/incubator-seata/pull/7727)] add some UT for compatible module
- [[#7803](https://github.com/apache/incubator-seata/pull/7803)] Fix flakiness in `DataCompareUtilsTest` caused by non-deterministic Map key iteration order.
- [[#7804](https://github.com/apache/incubator-seata/pull/7804)] fix testXARollbackWithResourceLock() to ensure ci runs normally
- [[#7779](https://github.com/apache/incubator-seata/pull/7779)] improve unit tests for RaftRegistryServiceImpl
- [[#7801](https://github.com/apache/incubator-seata/pull/7801)] Fix non-deteriministic in JsonParserWrapTest#testToJSONString due to key order
- [[#7800](https://github.com/apache/incubator-seata/pull/7800)] fix non-deterministic in StringUtilsTest#testToStringAndCycleDependency
- [[#7802](https://github.com/apache/incubator-seata/pull/7802)] Fix non-deterministic in `ConnectionContextProxyTest`.
- [[#7808](https://github.com/apache/incubator-seata/pull/7808)] Deflake multiple Insert Executor tests by fixing order-dependent primary key (PK) value comparison
- [[#7815](https://github.com/apache/incubator-seata/pull/7815)] test: fix combine test to avoid failure due to ordering
- [[#7819](https://github.com/apache/incubator-seata/pull/7819)] fix brittle RPC status test
- [[#7827](https://github.com/apache/incubator-seata/pull/7827)] Fix non-deteriministic in TableMetaTest#testGetPrimaryKeyOnlyName
- [[#7859](https://github.com/apache/incubator-seata/pull/7859)] Fix flaky tests in MetadataTest caused by shared state and brittle toString assertions
- [[#7858](https://github.com/apache/incubator-seata/pull/7858)] Fix flakiness in HttpTest.convertParamOfJsonStringTest caused by non-deterministic Map iteration order
- [[#7874](https://github.com/apache/incubator-seata/pull/7874)] add unit tests for DBType and RedisKeyConstants in core module
- [[#7900](https://github.com/apache/incubator-seata/pull/7900)] add unit tests for ConnectionContext class
- [[#7901](https://github.com/apache/incubator-seata/pull/7901)] add unit tests for core module (LockStatus, MessageType, ProtocolConstants)
- [[#7906](https://github.com/apache/incubator-seata/pull/7906)] add test for Fury/Fory
- [[#7907](https://github.com/apache/incubator-seata/pull/7907)] test: fixes CI errors caused by timing issues in ZkConfigurationTest
- [[#7912](https://github.com/apache/incubator-seata/pull/7912)] test: add Antlr tests to improve test coverage
- [[#7933](https://github.com/apache/incubator-seata/pull/7933)] oscar test cases should only run on Druid 1.2.5 and higher versions


### refactor:

- [[#7615](https://github.com/seata/seata/pull/7615)] Refactor DataSourceProxy
- [[#7617](https://github.com/seata/seata/pull/7617)] Refactor Alibaba Dubbo and HSF
- [[#7688](https://github.com/seata/seata/pull/7688)] Reactor extensions module
- [[#7719](https://github.com/apache/incubator-seata/pull/7719)] Replace synchronized with ReentrantLock in AbstractNettyRemotingClient to support virtual threads
- [[#7789](https://github.com/apache/incubator-seata/pull/7789)] rename GROUP_UPDATE_TIME to GROUP_UPDATE_TERM in ClusterWatcherManager
- [[#7698](https://github.com/apache/incubator-seata/pull/7698)] refactor test module
- [[#7818](https://github.com/apache/incubator-seata/pull/7818)] run the HTTP filter as a chain of responsibility
- [[#7904](https://github.com/apache/incubator-seata/pull/7904)] Unify HTTP client utility to OkHttp3


### doc:

- [[#7462](https://github.com/seata/seata/pull/7462)] improve TM module Javadoc with comprehensive English documentation
- [[#7531](https://github.com/seata/seata/pull/7531)] Optimize the Readme and change documents
- [[#7571](https://github.com/seata/seata/pull/7571)] Add hyperlink to CONTRIBUTING.md in pull request template
- [[#7605](https://github.com/apache/incubator-seata/pull/7605)] Add the type of registry as seata in application.yml
- [[#7625](https://github.com/apache/incubator-seata/pull/7625)] Polish Javadoc for @EnableAutoDataSourceProxy and DefaultFailureHandlerImpl
- [[#7702](https://github.com/apache/incubator-seata/pull/7702)] change "whether use" to "whether to use" for correct syntax.


Thanks to these contributors for their code commits. Please report an unintended omission.

<!-- Please make sure your Github ID is in the list below -->

- [slievrly](https://github.com/slievrly)
- [YvCeung](https://github.com/YvCeung)
- [xjlgod](https://github.com/xjlgod)
- [YongGoose](https://github.com/YongGoose)
- [KoKimSS](https://github.com/KoKimSS)
- [maple525866](https://github.com/maple525866)
- [funky-eyes](https://github.com/funky-eyes)
- [keepConcentration](https://github.com/keepConcentration)
- [sunheyi6](https://github.com/sunheyi6)
- [WangzJi](https://github.com/WangzJi)
- [unifolio0](https://github.com/unifolio0)
- [Asuka-star](https://github.com/Asuka-star)
- [contrueCT](https://github.com/contrueCT)
- [YoWuwuuuw](https://github.com/YoWuwuuuw)
- [yougecn](https://github.com/yougecn)
- [jongmin-chung](https://github.com/jongmin-chung)
- [jihun4452](https://github.com/jihun4452)
- [psxjoy](https://github.com/psxjoy)
- [dsomehan](https://github.com/dsomehan)
- [LegendPei](https://github.com/LegendPei)
- [lokidundun](https://github.com/lokidundun)
- [xiaoxiangyeyu0](https://github.com/xiaoxiangyeyu0)
- [jsbxyyx](https://github.com/jsbxyyx)
- [xingfudeshi](https://github.com/xingfudeshi)
- [diguage](https://github.com/diguage)
- [aias00](https://github.com/aias00)
- [NiMv1](https://github.com/NiMv1)
- [MaoMaoandSnail](https://github.com/MaoMaoandSnail)
- [neronsoda](https://github.com/neronsoda)


Also, we receive many valuable issues, questions and advices from our community. Thanks for you all.
