/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LastValueAccumulator
implements Accumulator {
    protected final TSDataType seriesDataType;
    protected TsPrimitiveType lastValue;
    protected long maxTime = Long.MIN_VALUE;
    protected boolean initResult = false;

    public LastValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.lastValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(columns, bitMap);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(columns, bitMap);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(columns, bitMap);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of LastValue should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntLastValue(partialResult[0].getInt(0), partialResult[1].getLong(0));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.updateLongLastValue(partialResult[0].getLong(0), partialResult[1].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatLastValue(partialResult[0].getFloat(0), partialResult[1].getLong(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleLastValue(partialResult[0].getDouble(0), partialResult[1].getLong(0));
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryLastValue(partialResult[0].getBinary(0), partialResult[1].getLong(0));
                break;
            }
            case BOOLEAN: {
                this.updateBooleanLastValue(partialResult[0].getBoolean(0), partialResult[1].getLong(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntLastValue((Integer)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.updateLongLastValue((Long)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case FLOAT: {
                this.updateFloatLastValue(((Float)statistics.getLastValue()).floatValue(), statistics.getEndTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleLastValue((Double)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryLastValue((Binary)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanLastValue((Boolean)statistics.getLastValue(), statistics.getEndTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (!finalResult.isNull(0)) {
            this.initResult = true;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    this.lastValue.setInt(finalResult.getInt(0));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.lastValue.setLong(finalResult.getLong(0));
                    break;
                }
                case FLOAT: {
                    this.lastValue.setFloat(finalResult.getFloat(0));
                    break;
                }
                case DOUBLE: {
                    this.lastValue.setDouble(finalResult.getDouble(0));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.lastValue.setBinary(finalResult.getBinary(0));
                    break;
                }
                case BOOLEAN: {
                    this.lastValue.setBoolean(finalResult.getBoolean(0));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of LastValue should be 2");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilders[0].writeInt(this.lastValue.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilders[0].writeLong(this.lastValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.lastValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.lastValue.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilders[0].writeBinary(this.lastValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilders[0].writeBoolean(this.lastValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
        columnBuilders[1].writeLong(this.maxTime);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.lastValue.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.lastValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.lastValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.lastValue.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.lastValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.lastValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxTime = Long.MIN_VALUE;
        this.lastValue.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.lastValue.getDataType(), TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return this.lastValue.getDataType();
    }

    @Override
    public int getPartialResultSize() {
        return 2;
    }

    protected void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntLastValue(column[1].getInt(i), column[0].getLong(i));
        }
    }

    protected void updateIntLastValue(int value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setInt(value);
        }
    }

    protected void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongLastValue(column[1].getLong(i), column[0].getLong(i));
        }
    }

    protected void updateLongLastValue(long value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setLong(value);
        }
    }

    protected void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatLastValue(column[1].getFloat(i), column[0].getLong(i));
        }
    }

    protected void updateFloatLastValue(float value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setFloat(value);
        }
    }

    protected void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleLastValue(column[1].getDouble(i), column[0].getLong(i));
        }
    }

    protected void updateDoubleLastValue(double value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setDouble(value);
        }
    }

    protected void addBooleanInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBooleanLastValue(column[1].getBoolean(i), column[0].getLong(i));
        }
    }

    protected void updateBooleanLastValue(boolean value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBoolean(value);
        }
    }

    protected void addBinaryInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBinaryLastValue(column[1].getBinary(i), column[0].getLong(i));
        }
    }

    protected void updateBinaryLastValue(Binary value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBinary(value);
        }
    }
}

