/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ContentFilterElementResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=604");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=606");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=605");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15211");
    private final StatusCode statusCode;
    private final StatusCode[] operandStatusCodes;
    private final DiagnosticInfo[] operandDiagnosticInfos;

    public ContentFilterElementResult(StatusCode statusCode, StatusCode[] operandStatusCodes, DiagnosticInfo[] operandDiagnosticInfos) {
        this.statusCode = statusCode;
        this.operandStatusCodes = operandStatusCodes;
        this.operandDiagnosticInfos = operandDiagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public StatusCode[] getOperandStatusCodes() {
        return this.operandStatusCodes;
    }

    public DiagnosticInfo[] getOperandDiagnosticInfos() {
        return this.operandDiagnosticInfos;
    }

    protected ContentFilterElementResult(ContentFilterElementResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((ContentFilterElementResultBuilder)b).statusCode;
        this.operandStatusCodes = ((ContentFilterElementResultBuilder)b).operandStatusCodes;
        this.operandDiagnosticInfos = ((ContentFilterElementResultBuilder)b).operandDiagnosticInfos;
    }

    public static ContentFilterElementResultBuilder<?, ?> builder() {
        return new ContentFilterElementResultBuilderImpl();
    }

    public ContentFilterElementResultBuilder<?, ?> toBuilder() {
        return new ContentFilterElementResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentFilterElementResult)) {
            return false;
        }
        ContentFilterElementResult other = (ContentFilterElementResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperandStatusCodes(), other.getOperandStatusCodes())) {
            return false;
        }
        return Arrays.deepEquals(this.getOperandDiagnosticInfos(), other.getOperandDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentFilterElementResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperandStatusCodes());
        result = result * 59 + Arrays.deepHashCode(this.getOperandDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "ContentFilterElementResult(statusCode=" + this.getStatusCode() + ", operandStatusCodes=" + Arrays.deepToString(this.getOperandStatusCodes()) + ", operandDiagnosticInfos=" + Arrays.deepToString(this.getOperandDiagnosticInfos()) + ")";
    }

    private static final class ContentFilterElementResultBuilderImpl
    extends ContentFilterElementResultBuilder<ContentFilterElementResult, ContentFilterElementResultBuilderImpl> {
        private ContentFilterElementResultBuilderImpl() {
        }

        @Override
        protected ContentFilterElementResultBuilderImpl self() {
            return this;
        }

        @Override
        public ContentFilterElementResult build() {
            return new ContentFilterElementResult(this);
        }
    }

    public static abstract class ContentFilterElementResultBuilder<C extends ContentFilterElementResult, B extends ContentFilterElementResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private StatusCode[] operandStatusCodes;
        private DiagnosticInfo[] operandDiagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ContentFilterElementResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ContentFilterElementResult instance, ContentFilterElementResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.operandStatusCodes(instance.operandStatusCodes);
            b.operandDiagnosticInfos(instance.operandDiagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B operandStatusCodes(StatusCode[] operandStatusCodes) {
            this.operandStatusCodes = operandStatusCodes;
            return (B)this.self();
        }

        public B operandDiagnosticInfos(DiagnosticInfo[] operandDiagnosticInfos) {
            this.operandDiagnosticInfos = operandDiagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContentFilterElementResult.ContentFilterElementResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", operandStatusCodes=" + Arrays.deepToString(this.operandStatusCodes) + ", operandDiagnosticInfos=" + Arrays.deepToString(this.operandDiagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ContentFilterElementResult> {
        @Override
        public Class<ContentFilterElementResult> getType() {
            return ContentFilterElementResult.class;
        }

        @Override
        public ContentFilterElementResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            StatusCode[] operandStatusCodes = decoder.readStatusCodeArray("OperandStatusCodes");
            DiagnosticInfo[] operandDiagnosticInfos = decoder.readDiagnosticInfoArray("OperandDiagnosticInfos");
            return new ContentFilterElementResult(statusCode, operandStatusCodes, operandDiagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ContentFilterElementResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeStatusCodeArray("OperandStatusCodes", value.getOperandStatusCodes());
            encoder.writeDiagnosticInfoArray("OperandDiagnosticInfos", value.getOperandDiagnosticInfos());
        }
    }
}

