/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LogicalViewSchemaScanNode
extends SchemaQueryScanNode {
    private final SchemaFilter schemaFilter;

    public LogicalViewSchemaScanNode(PlanNodeId id, PartialPath partialPath, SchemaFilter schemaFilter, long limit, long offset, PathPatternTree scope) {
        super(id, partialPath, limit, offset, false, scope);
        this.schemaFilter = schemaFilter;
    }

    public SchemaFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LOGICAL_VIEW_SCHEMA_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        this.scope.serialize(byteBuffer);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.offset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LOGICAL_VIEW_SCHEMA_SCAN.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        this.scope.serialize(stream);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (DataOutputStream)stream);
        ReadWriteIOUtils.write((long)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.offset, (OutputStream)stream);
    }

    public static LogicalViewSchemaScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize TimeSeriesSchemaScanNode", e);
        }
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        SchemaFilter schemaFilter = SchemaFilter.deserialize((ByteBuffer)byteBuffer);
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LogicalViewSchemaScanNode(planNodeId, path, schemaFilter, limit, offset, scope);
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.LOGICAL_VIEW_SCHEMA_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new LogicalViewSchemaScanNode(this.getPlanNodeId(), this.path, this.schemaFilter, this.limit, this.offset, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showLogicalViewColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogicalViewSchemaScanNode that = (LogicalViewSchemaScanNode)o;
        return Objects.equals(this.schemaFilter, that.schemaFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.schemaFilter);
    }

    @Override
    public String toString() {
        return String.format("LogicalViewSchemaScanNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

