/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.net.SocketException;
import org.apache.iotdb.rpc.TSnappyElasticFramedTransport;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class TimeoutChangeableTSnappyFramedTransport
extends TSnappyElasticFramedTransport
implements TimeoutChangeableTransport {
    private final TSocket underlyingSocket;

    public TimeoutChangeableTSnappyFramedTransport(TSocket underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
        super((TTransport)underlying, thriftDefaultBufferSize, thriftMaxFrameSize, copyBinary);
        this.underlyingSocket = underlying;
    }

    @Override
    public void setTimeout(int timeout) {
        this.underlyingSocket.setTimeout(timeout);
    }

    @Override
    public int getTimeOut() throws SocketException {
        return this.underlyingSocket.getSocket().getSoTimeout();
    }

    @Override
    public TTransport getSocket() {
        return this.underlyingSocket;
    }

    public static class Factory
    extends TTransportFactory {
        private final int thriftDefaultBufferSize;
        protected final int thriftMaxFrameSize;
        protected final boolean copyBinary;

        public Factory(int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            this.copyBinary = copyBinary;
        }

        public TTransport getTransport(TTransport trans) {
            if (trans instanceof TSocket) {
                return new TimeoutChangeableTSnappyFramedTransport((TSocket)trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.copyBinary);
            }
            return new TSnappyElasticFramedTransport(trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.copyBinary);
        }
    }
}

