/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeConsensusTransferFileSealWithModReq
extends TPipeConsensusTransferReq {
    private transient List<String> fileNames;
    private transient List<Long> fileLengths;
    private transient List<Long> pointCounts;
    private transient Map<String, String> parameters;

    public final List<String> getFileNames() {
        return this.fileNames;
    }

    public final List<Long> getFileLengths() {
        return this.fileLengths;
    }

    public final List<Long> getPointCounts() {
        return this.pointCounts;
    }

    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    protected abstract PipeConsensusRequestType getPlanType();

    protected PipeConsensusTransferFileSealWithModReq convertToTPipeConsensusTransferReq(List<String> fileNames, List<Long> fileLengths, List<Long> pointCounts, Map<String, String> parameters, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) throws IOException {
        DataOutputStream outputStream;
        this.fileNames = fileNames;
        this.fileLengths = fileLengths;
        this.pointCounts = pointCounts;
        this.parameters = parameters;
        this.commitId = commitId;
        this.consensusGroupId = consensusGroupId;
        this.dataNodeId = thisDataNodeId;
        this.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
            try {
                ReadWriteIOUtils.write((int)fileNames.size(), (OutputStream)outputStream);
                for (String string : fileNames) {
                    ReadWriteIOUtils.write((String)string, (OutputStream)outputStream);
                }
                ReadWriteIOUtils.write((int)fileLengths.size(), (OutputStream)outputStream);
                for (Long l : fileLengths) {
                    ReadWriteIOUtils.write((long)l, (OutputStream)outputStream);
                }
                ReadWriteIOUtils.write((int)pointCounts.size(), (OutputStream)outputStream);
                for (Long l : pointCounts) {
                    ReadWriteIOUtils.write((long)l, (OutputStream)outputStream);
                }
                ReadWriteIOUtils.write((int)parameters.size(), (OutputStream)outputStream);
                for (Map.Entry entry : parameters.entrySet()) {
                    ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
                }
                this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            finally {
                outputStream.close();
            }
        }
        byteArrayOutputStream = new PublicBAOS();
        try {
            outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
            try {
                progressIndex.serialize(outputStream);
                this.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            byteArrayOutputStream.close();
        }
        return this;
    }

    public PipeConsensusTransferFileSealWithModReq translateFromTPipeConsensusTransferReq(TPipeConsensusTransferReq req) {
        int i;
        this.fileNames = new ArrayList<String>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)req.body);
        for (i = 0; i < size; ++i) {
            this.fileNames.add(ReadWriteIOUtils.readString((ByteBuffer)req.body));
        }
        this.fileLengths = new ArrayList<Long>();
        size = ReadWriteIOUtils.readInt((ByteBuffer)req.body);
        for (i = 0; i < size; ++i) {
            this.fileLengths.add(ReadWriteIOUtils.readLong((ByteBuffer)req.body));
        }
        this.pointCounts = new ArrayList<Long>();
        size = ReadWriteIOUtils.readInt((ByteBuffer)req.body);
        for (i = 0; i < size; ++i) {
            this.pointCounts.add(ReadWriteIOUtils.readLong((ByteBuffer)req.body));
        }
        this.parameters = new HashMap<String, String>();
        size = ReadWriteIOUtils.readInt((ByteBuffer)req.body);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)req.body);
            String value = ReadWriteIOUtils.readString((ByteBuffer)req.body);
            this.parameters.put(key, value);
        }
        this.version = req.version;
        this.type = req.type;
        this.body = req.body;
        this.commitId = req.commitId;
        this.dataNodeId = req.dataNodeId;
        this.consensusGroupId = req.consensusGroupId;
        this.progressIndex = req.progressIndex;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTransferFileSealWithModReq that = (PipeConsensusTransferFileSealWithModReq)((Object)obj);
        return Objects.equals(this.fileNames, that.fileNames) && Objects.equals(this.fileLengths, that.fileLengths) && Objects.equals(this.pointCounts, that.pointCounts) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.version, that.version) && Objects.equals(this.type, that.type) && Objects.equals(this.body, that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.progressIndex, that.progressIndex) && Objects.equals(this.dataNodeId, that.dataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.fileNames, this.fileLengths, this.pointCounts, this.parameters, this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId, this.progressIndex);
    }
}

