/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CountGroupByLevelMergeOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CountGroupByLevelMergeOperator.class);
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final boolean[] childrenHasNext;
    private final Map<String, Long> countMap = new HashMap<String, Long>();
    private List<TsBlock> resultTsBlockList;
    private int currentIndex = 0;

    public CountGroupByLevelMergeOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.childrenHasNext = new boolean[children.size()];
        Arrays.fill(this.childrenHasNext, true);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutureList = new ArrayList(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            ListenableFuture<?> blocked;
            if (!this.childrenHasNext[i] || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutureList.add(blocked);
        }
        return listenableFutureList.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutureList);
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.resultTsBlockList != null) {
            return this.resultTsBlockList.get(this.currentIndex++);
        }
        boolean allChildrenConsumed = true;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.childrenHasNext[i]) continue;
            if (this.children.get(i).hasNextWithTimer()) {
                allChildrenConsumed = false;
                TsBlock tsBlock = this.children.get(i).nextWithTimer();
                if (tsBlock == null || tsBlock.isEmpty()) continue;
                this.consumeChildrenTsBlock(tsBlock);
                continue;
            }
            this.childrenHasNext[i] = false;
        }
        if (allChildrenConsumed) {
            this.generateResultTsBlockList();
            ++this.currentIndex;
            return this.resultTsBlockList.get(this.currentIndex - 1);
        }
        return null;
    }

    private void consumeChildrenTsBlock(TsBlock tsBlock) {
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            String columnName = tsBlock.getColumn(0).getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
            long count = tsBlock.getColumn(1).getLong(i);
            this.countMap.put(columnName, this.countMap.getOrDefault(columnName, 0L) + count);
        }
    }

    private void generateResultTsBlockList() {
        this.resultTsBlockList = SchemaTsBlockUtil.transferSchemaResultToTsBlockList(this.countMap.entrySet().iterator(), Arrays.asList(TSDataType.TEXT, TSDataType.INT64), (entry, tsBlockBuilder) -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary((String)entry.getKey(), TSFileConfig.STRING_CHARSET));
            tsBlockBuilder.getColumnBuilder(1).writeLong(((Long)entry.getValue()).longValue());
            tsBlockBuilder.declarePosition();
        });
        if (this.resultTsBlockList.isEmpty()) {
            TsBlockBuilder tsBlockBuilder2 = new TsBlockBuilder(Arrays.asList(TSDataType.TEXT, TSDataType.INT64));
            this.resultTsBlockList.add(tsBlockBuilder2.build());
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.resultTsBlockList == null || this.currentIndex < this.resultTsBlockList.size();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.childrenHasNext);
    }
}

